"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; desc = parent = getter = undefined; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; continue _function; } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _utilsUtils = require("../utils/utils");

var _utilsChartDataUtil = require("../utils/ChartDataUtil");

var _ToolTipText = require("./ToolTipText");

var _ToolTipText2 = _interopRequireDefault(_ToolTipText);

var _ToolTipTSpanLabel = require("./ToolTipTSpanLabel");

var _ToolTipTSpanLabel2 = _interopRequireDefault(_ToolTipTSpanLabel);

var CompareTooltip = (function (_React$Component) {
	_inherits(CompareTooltip, _React$Component);

	function CompareTooltip() {
		_classCallCheck(this, CompareTooltip);

		_get(Object.getPrototypeOf(CompareTooltip.prototype), "constructor", this).apply(this, arguments);
	}

	_createClass(CompareTooltip, [{
		key: "render",
		value: function render() {
			var _this = this;

			var displayValue = "n/a";

			var chartData = (0, _utilsChartDataUtil.getChartDataForChart)(this.props, this.context);
			var item = (0, _utilsChartDataUtil.getCurrentItemForChart)(this.props, this.context);

			var thisSeries = chartData.config.compareSeries.filter(function (each) {
				return each.id === _this.props.forCompareSeries;
			})[0];

			if (item !== undefined && thisSeries.yAccessor(item) !== undefined) {
				displayValue = thisSeries.yAccessor(item);
			}

			var origin = chartData.config.origin;

			var relativeOrigin = typeof this.props.origin === "function" ? this.props.origin(this.context.width, this.context.height) : this.props.origin;
			var absoluteOrigin = [origin[0] + relativeOrigin[0], origin[1] + relativeOrigin[1]];

			return _react2["default"].createElement(
				"g",
				{ transform: "translate(" + absoluteOrigin[0] + ", " + absoluteOrigin[1] + ")" },
				_react2["default"].createElement(
					_ToolTipText2["default"],
					{ x: 0, y: 0,
						fontFamily: this.props.fontFamily, fontSize: this.props.fontSize },
					_react2["default"].createElement(
						_ToolTipTSpanLabel2["default"],
						{ key: "label", x: 0, dy: "5", fill: thisSeries.stroke },
						thisSeries.displayLabel + ": "
					),
					_react2["default"].createElement(
						"tspan",
						{ key: "value", fill: thisSeries.stroke },
						displayValue
					)
				)
			);
		}
	}]);

	return CompareTooltip;
})(_react2["default"].Component);

CompareTooltip.contextTypes = {
	chartData: _react2["default"].PropTypes.array.isRequired,
	currentItems: _react2["default"].PropTypes.array.isRequired
};

CompareTooltip.propTypes = {
	forChart: _react2["default"].PropTypes.number.isRequired,
	forCompareSeries: _react2["default"].PropTypes.number.isRequired,
	xDisplayFormat: _react2["default"].PropTypes.func.isRequired,
	origin: _react2["default"].PropTypes.array.isRequired,
	fontFamily: _react2["default"].PropTypes.string,
	fontSize: _react2["default"].PropTypes.number
};

CompareTooltip.defaultProps = {
	namespace: "ReStock.CompareTooltip",
	xDisplayFormat: _utilsUtils.displayDateFormat,
	origin: [0, 0]
};

exports["default"] = CompareTooltip;
module.exports = exports["default"];