"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; desc = parent = getter = undefined; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; continue _function; } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _objectAssign = require("object-assign");

var _objectAssign2 = _interopRequireDefault(_objectAssign);

var _ToolTipText = require("./ToolTipText");

var _ToolTipText2 = _interopRequireDefault(_ToolTipText);

var _ToolTipTSpanLabel = require("./ToolTipTSpanLabel");

var _ToolTipTSpanLabel2 = _interopRequireDefault(_ToolTipTSpanLabel);

var _utilsUtils = require("../utils/utils");

var _utilsChartDataUtil = require("../utils/ChartDataUtil");

var SingleMAToolTip = (function (_React$Component) {
	_inherits(SingleMAToolTip, _React$Component);

	function SingleMAToolTip(props) {
		_classCallCheck(this, SingleMAToolTip);

		_get(Object.getPrototypeOf(SingleMAToolTip.prototype), "constructor", this).call(this, props);
		this.handleClick = this.handleClick.bind(this);
	}

	_createClass(SingleMAToolTip, [{
		key: "handleClick",
		value: function handleClick(e) {
			var _props = this.props;
			var onClick = _props.onClick;
			var forChart = _props.forChart;
			var forDataSeries = _props.forDataSeries;
			var options = _props.options;

			onClick((0, _objectAssign2["default"])({ chartId: forChart, dataSeriesId: forDataSeries }, options), e);
		}
	}, {
		key: "render",
		value: function render() {
			var translate = "translate(" + this.props.origin[0] + ", " + this.props.origin[1] + ")";
			return _react2["default"].createElement(
				"g",
				{ transform: translate },
				_react2["default"].createElement("line", { x1: 0, y1: 2, x2: 0, y2: 28, stroke: this.props.color, strokeWidth: "4px" }),
				_react2["default"].createElement(
					_ToolTipText2["default"],
					{ x: 5, y: 11,
						fontFamily: this.props.fontFamily, fontSize: this.props.fontSize },
					_react2["default"].createElement(
						_ToolTipTSpanLabel2["default"],
						null,
						this.props.displayName
					),
					_react2["default"].createElement(
						"tspan",
						{ x: "5", dy: "15" },
						this.props.value
					)
				),
				_react2["default"].createElement("rect", { x: 0, y: 0, width: 55, height: 30,
					onClick: this.handleClick,
					fill: "none", stroke: "none" })
			);
		}
	}]);

	return SingleMAToolTip;
})(_react2["default"].Component);

SingleMAToolTip.propTypes = {
	origin: _react2["default"].PropTypes.array.isRequired,
	color: _react2["default"].PropTypes.string.isRequired,
	displayName: _react2["default"].PropTypes.string.isRequired,
	value: _react2["default"].PropTypes.string.isRequired,
	onClick: _react2["default"].PropTypes.func,
	fontFamily: _react2["default"].PropTypes.string,
	fontSize: _react2["default"].PropTypes.number,
	forChart: _react2["default"].PropTypes.number.isRequired,
	forDataSeries: _react2["default"].PropTypes.number.isRequired,
	options: _react2["default"].PropTypes.object.isRequired
};

var MovingAverageTooltip = (function (_React$Component2) {
	_inherits(MovingAverageTooltip, _React$Component2);

	function MovingAverageTooltip() {
		_classCallCheck(this, MovingAverageTooltip);

		_get(Object.getPrototypeOf(MovingAverageTooltip.prototype), "constructor", this).apply(this, arguments);
	}

	_createClass(MovingAverageTooltip, [{
		key: "render",
		value: function render() {
			var _this = this;

			var chartData = (0, _utilsChartDataUtil.getChartDataForChart)(this.props, this.context);
			var item = (0, _utilsChartDataUtil.getCurrentItemForChart)(this.props, this.context);
			var _props2 = this.props;
			var className = _props2.className;
			var onClick = _props2.onClick;
			var forChart = _props2.forChart;
			var forDataSeries = _props2.forDataSeries;
			var width = _props2.width;
			var fontFamily = _props2.fontFamily;
			var fontSize = _props2.fontSize;
			var origin = chartData.config.origin;

			var relativeOrigin = typeof this.props.origin === "function" ? this.props.origin(this.context.width, this.context.height) : this.props.origin;
			var absoluteOrigin = [origin[0] + relativeOrigin[0], origin[1] + relativeOrigin[1]];

			return _react2["default"].createElement(
				"g",
				{ transform: "translate(" + absoluteOrigin[0] + ", " + absoluteOrigin[1] + ")", className: className },
				chartData.config.overlays.filter(function (eachOverlay) {
					return eachOverlay.indicator !== undefined;
				}).filter(function (eachOverlay) {
					return eachOverlay.indicator.isMovingAverage && eachOverlay.indicator.isMovingAverage();
				}).filter(function (eachOverlay) {
					return forDataSeries === undefined ? true : forDataSeries.indexOf(eachOverlay.id) > -1;
				}).map(function (eachOverlay, idx) {
					var yValue = eachOverlay.yAccessor(item);
					var yDisplayValue = yValue ? _this.props.displayFormat(yValue) : "n/a";
					return _react2["default"].createElement(SingleMAToolTip, {
						key: idx,
						origin: [width * idx, 0],
						color: eachOverlay.stroke,
						displayName: eachOverlay.indicator.tooltipLabel(),
						value: yDisplayValue,
						options: eachOverlay.indicator.options(),
						forChart: forChart, forDataSeries: eachOverlay.id, onClick: onClick,
						fontFamily: fontFamily, fontSize: fontSize });
				})
			);
		}
	}]);

	return MovingAverageTooltip;
})(_react2["default"].Component);

MovingAverageTooltip.contextTypes = {
	chartData: _react2["default"].PropTypes.array.isRequired,
	currentItems: _react2["default"].PropTypes.array.isRequired
};

MovingAverageTooltip.propTypes = {
	className: _react2["default"].PropTypes.string,
	forChart: _react2["default"].PropTypes.number.isRequired,
	displayFormat: _react2["default"].PropTypes.func.isRequired,
	origin: _react2["default"].PropTypes.array.isRequired,
	onClick: _react2["default"].PropTypes.func,
	fontFamily: _react2["default"].PropTypes.string,
	fontSize: _react2["default"].PropTypes.number,
	width: _react2["default"].PropTypes.number,
	forDataSeries: _react2["default"].PropTypes.arrayOf(_react2["default"].PropTypes.number)
};

MovingAverageTooltip.defaultProps = {
	namespace: "ReStock.MovingAverageTooltip",
	className: "react-stockcharts-moving-average-tooltip",
	displayFormat: _utilsUtils.displayNumberFormat,
	origin: [0, 10],
	width: 65
};

exports["default"] = MovingAverageTooltip;
module.exports = exports["default"];