"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; desc = parent = getter = undefined; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; continue _function; } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _d3 = require("d3");

var _d32 = _interopRequireDefault(_d3);

var _utilsUtils = require("../utils/utils");

var _utilsChartDataUtil = require("../utils/ChartDataUtil");

var _ToolTipText = require("./ToolTipText");

var _ToolTipText2 = _interopRequireDefault(_ToolTipText);

var _ToolTipTSpanLabel = require("./ToolTipTSpanLabel");

var _ToolTipTSpanLabel2 = _interopRequireDefault(_ToolTipTSpanLabel);

/*
var billion = 1 * 1000 * 1000 * 1000;
var million = 1 * 1000 * 1000;
var thousand = 1 * 1000;
*/

var OHLCTooltip = (function (_React$Component) {
	_inherits(OHLCTooltip, _React$Component);

	function OHLCTooltip() {
		_classCallCheck(this, OHLCTooltip);

		_get(Object.getPrototypeOf(OHLCTooltip.prototype), "constructor", this).apply(this, arguments);
	}

	_createClass(OHLCTooltip, [{
		key: "render",
		value: function render() {
			var _props = this.props;
			var onClick = _props.onClick;
			var xDisplayFormat = _props.xDisplayFormat;
			var fontFamily = _props.fontFamily;
			var fontSize = _props.fontSize;
			var accessor = _props.accessor;
			var volumeFormat = _props.volumeFormat;

			var displayDate, open, high, low, close, volume;

			displayDate = open = high = low = close = volume = "n/a";

			var item = (0, _utilsChartDataUtil.getCurrentItemForChart)(this.props, this.context);
			var chartData = (0, _utilsChartDataUtil.getChartDataForChart)(this.props, this.context);

			if (item !== undefined && accessor(item).close !== undefined) {
				item = accessor(item);
				volume = volumeFormat(item.volume);
				/* volume = (item.volume / billion > 1)
    	? (item.volume / billion).toFixed(2) + "b"
    	: (item.volume / million > 1)
    		? (item.volume / million).toFixed(2) + "m"
    		: (item.volume / thousand > 1)
    			? (item.volume / thousand).toFixed(2) + "k"
    			: item.volume; */

				displayDate = xDisplayFormat(item.date);
				open = (0, _utilsUtils.displayNumberFormat)(item.open);
				high = (0, _utilsUtils.displayNumberFormat)(item.high);
				low = (0, _utilsUtils.displayNumberFormat)(item.low);
				close = (0, _utilsUtils.displayNumberFormat)(item.close);
			}

			var origin = chartData.config.origin;

			var relativeOrigin = typeof this.props.origin === "function" ? this.props.origin(this.context.width, this.context.height) : this.props.origin;
			var absoluteOrigin = [origin[0] + relativeOrigin[0], origin[1] + relativeOrigin[1]];

			return _react2["default"].createElement(
				"g",
				{ transform: "translate(" + absoluteOrigin[0] + ", " + absoluteOrigin[1] + ")",
					onClick: onClick },
				_react2["default"].createElement(
					_ToolTipText2["default"],
					{ x: 0, y: 0,
						fontFamily: fontFamily, fontSize: fontSize },
					_react2["default"].createElement(
						_ToolTipTSpanLabel2["default"],
						{ key: "label", x: 0, dy: "5" },
						"Date: "
					),
					_react2["default"].createElement(
						"tspan",
						{ key: "value" },
						displayDate
					),
					_react2["default"].createElement(
						_ToolTipTSpanLabel2["default"],
						{ key: "label_O" },
						" O: "
					),
					_react2["default"].createElement(
						"tspan",
						{ key: "value_O" },
						open
					),
					_react2["default"].createElement(
						_ToolTipTSpanLabel2["default"],
						{ key: "label_H" },
						" H: "
					),
					_react2["default"].createElement(
						"tspan",
						{ key: "value_H" },
						high
					),
					_react2["default"].createElement(
						_ToolTipTSpanLabel2["default"],
						{ key: "label_L" },
						" L: "
					),
					_react2["default"].createElement(
						"tspan",
						{ key: "value_L" },
						low
					),
					_react2["default"].createElement(
						_ToolTipTSpanLabel2["default"],
						{ key: "label_C" },
						" C: "
					),
					_react2["default"].createElement(
						"tspan",
						{ key: "value_C" },
						close
					),
					_react2["default"].createElement(
						_ToolTipTSpanLabel2["default"],
						{ key: "label_Vol" },
						" Vol: "
					),
					_react2["default"].createElement(
						"tspan",
						{ key: "value_Vol" },
						volume
					)
				)
			);
		}
	}]);

	return OHLCTooltip;
})(_react2["default"].Component);

OHLCTooltip.contextTypes = {
	chartData: _react2["default"].PropTypes.array.isRequired,
	currentItems: _react2["default"].PropTypes.array.isRequired,
	width: _react2["default"].PropTypes.number.isRequired,
	height: _react2["default"].PropTypes.number.isRequired
};

OHLCTooltip.propTypes = {
	forChart: _react2["default"].PropTypes.number.isRequired,
	accessor: _react2["default"].PropTypes.func.isRequired,
	xDisplayFormat: _react2["default"].PropTypes.func.isRequired,
	origin: _react2["default"].PropTypes.oneOfType([_react2["default"].PropTypes.array, _react2["default"].PropTypes.func]).isRequired,
	fontFamily: _react2["default"].PropTypes.string,
	fontSize: _react2["default"].PropTypes.number,
	onClick: _react2["default"].PropTypes.func,
	volumeFormat: _react2["default"].PropTypes.func
};

OHLCTooltip.defaultProps = {
	namespace: "ReStock.OHLCTooltip",
	accessor: function accessor(d) {
		return { date: d.date, open: d.open, high: d.high, low: d.low, close: d.close, volume: d.volume };
	},
	xDisplayFormat: _utilsUtils.displayDateFormat,
	volumeFormat: _d32["default"].format(".4s"),
	origin: [0, 0]
};

exports["default"] = OHLCTooltip;
module.exports = exports["default"];