"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; desc = parent = getter = undefined; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; continue _function; } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _utilsUtils = require("../utils/utils");

var _utilsChartDataUtil = require("../utils/ChartDataUtil");

var _ToolTipText = require("./ToolTipText");

var _ToolTipText2 = _interopRequireDefault(_ToolTipText);

var _ToolTipTSpanLabel = require("./ToolTipTSpanLabel");

var _ToolTipTSpanLabel2 = _interopRequireDefault(_ToolTipTSpanLabel);

var RSITooltip = (function (_React$Component) {
	_inherits(RSITooltip, _React$Component);

	function RSITooltip() {
		_classCallCheck(this, RSITooltip);

		_get(Object.getPrototypeOf(RSITooltip.prototype), "constructor", this).apply(this, arguments);
	}

	_createClass(RSITooltip, [{
		key: "render",
		value: function render() {
			var _props = this.props;
			var onClick = _props.onClick;
			var forChart = _props.forChart;
			var forDataSeries = _props.forDataSeries;
			var fontSize = _props.fontSize;
			var fontFamily = _props.fontFamily;

			var chartData = (0, _utilsChartDataUtil.getChartDataForChart)(this.props, this.context);

			var overlays = chartData.config.overlays.filter(function (eachOverlay) {
				return forDataSeries === undefined ? true : forDataSeries === eachOverlay.id;
			}).filter(function (eachOverlay) {
				return eachOverlay.indicator !== undefined;
			}).filter(function (eachOverlay) {
				return eachOverlay.indicator.isRSI && eachOverlay.indicator.isRSI();
			});

			if (overlays.length > 1 || overlays.length === 0) {
				console.error("Could not find Exactly one DataSeries with RSI indicator for Chart id=" + forChart + ", either use\n\t\t\t\tsingle RSI indicator per chart\n\t\t\t\tor use forDataSeries property to narrow down to single Series");
			}

			var overlay = overlays[0];
			var options = overlay.indicator.options();

			var item = (0, _utilsChartDataUtil.getCurrentItemForChart)(this.props, this.context);
			var rsi = overlay.yAccessor(item);
			var format = chartData.config.mouseCoordinates.format;

			var value = rsi !== undefined && format(rsi) || "n/a";

			var origin = chartData.config.origin;

			var relativeOrigin = typeof this.props.origin === "function" ? this.props.origin(this.context.width, this.context.height) : this.props.origin;
			var absoluteOrigin = [origin[0] + relativeOrigin[0], origin[1] + relativeOrigin[1]];

			return _react2["default"].createElement(
				"g",
				{ transform: "translate(" + absoluteOrigin[0] + ", " + absoluteOrigin[1] + ")",
					onClick: onClick },
				_react2["default"].createElement(
					_ToolTipText2["default"],
					{ x: 0, y: 0,
						fontFamily: fontFamily, fontSize: fontSize },
					_react2["default"].createElement(
						_ToolTipTSpanLabel2["default"],
						null,
						"RSI (" + options.period + ", " + options.source + ", " + options.overSold + ", " + options.overBought + "): "
					),
					_react2["default"].createElement(
						"tspan",
						null,
						value
					)
				)
			);
		}
	}]);

	return RSITooltip;
})(_react2["default"].Component);

RSITooltip.contextTypes = {
	chartData: _react2["default"].PropTypes.array.isRequired,
	currentItems: _react2["default"].PropTypes.array.isRequired,
	width: _react2["default"].PropTypes.number.isRequired,
	height: _react2["default"].PropTypes.number.isRequired
};

RSITooltip.propTypes = {
	forChart: _react2["default"].PropTypes.number.isRequired,
	xDisplayFormat: _react2["default"].PropTypes.func.isRequired,
	origin: _react2["default"].PropTypes.oneOfType([_react2["default"].PropTypes.array, _react2["default"].PropTypes.func]).isRequired,
	fontFamily: _react2["default"].PropTypes.string,
	fontSize: _react2["default"].PropTypes.number,
	forDataSeries: _react2["default"].PropTypes.number,
	onClick: _react2["default"].PropTypes.func
};

RSITooltip.defaultProps = {
	namespace: "ReStock.RSITooltip",
	xDisplayFormat: _utilsUtils.displayDateFormat,
	origin: [0, 0]
};

exports["default"] = RSITooltip;
module.exports = exports["default"];