"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; desc = parent = getter = undefined; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; continue _function; } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _utilsChartDataUtil = require("../utils/ChartDataUtil");

var _ToolTipText = require("./ToolTipText");

var _ToolTipText2 = _interopRequireDefault(_ToolTipText);

var _ToolTipTSpanLabel = require("./ToolTipTSpanLabel");

var _ToolTipTSpanLabel2 = _interopRequireDefault(_ToolTipTSpanLabel);

var SingleValueTooltip = (function (_React$Component) {
	_inherits(SingleValueTooltip, _React$Component);

	function SingleValueTooltip() {
		_classCallCheck(this, SingleValueTooltip);

		_get(Object.getPrototypeOf(SingleValueTooltip.prototype), "constructor", this).apply(this, arguments);
	}

	_createClass(SingleValueTooltip, [{
		key: "render",
		value: function render() {
			var _props = this.props;
			var fontFamily = _props.fontFamily;
			var fontSize = _props.fontSize;
			var forSeries = _props.forSeries;
			var _props2 = this.props;
			var xDisplayFormat = _props2.xDisplayFormat;
			var yDisplayFormat = _props2.yDisplayFormat;
			var xLabel = _props2.xLabel;
			var yLabel = _props2.yLabel;
			var labelStroke = _props2.labelStroke;
			var valueStroke = _props2.valueStroke;

			var xDisplayValue = "n/a";
			var yDisplayValue = "n/a";

			var chartData = (0, _utilsChartDataUtil.getChartDataForChart)(this.props, this.context);
			var item = (0, _utilsChartDataUtil.getCurrentItemForChart)(this.props, this.context);

			/* var xAccessor;
   if (chartData.plot.scales.xScale.isPolyLinear()) {
   	xAccessor = stockScaleXAccessr;
   } */

			var overlays = chartData.config.overlays;
			var _overlays$filter$0 = overlays.filter(function (each) {
				return each.id === forSeries;
			})[0];
			var yAccessor = _overlays$filter$0.yAccessor;
			var stroke = _overlays$filter$0.stroke;

			var xAccessor = this.props.xAccessor; /* || xAccessor || chartData.config.xAccessor */
			yAccessor = this.props.yAccessor || yAccessor;

			if (item !== undefined && yAccessor(item) !== undefined) {
				xDisplayValue = xDisplayFormat ? xDisplayFormat(xAccessor(item)) : xDisplayValue;
				yDisplayValue = yDisplayFormat(yAccessor(item));
			}

			var origin = chartData.config.origin;

			var relativeOrigin = typeof this.props.origin === "function" ? this.props.origin(this.context.width, this.context.height) : this.props.origin;
			var absoluteOrigin = [origin[0] + relativeOrigin[0], origin[1] + relativeOrigin[1]];

			return _react2["default"].createElement(
				"g",
				{ transform: "translate(" + absoluteOrigin[0] + ", " + absoluteOrigin[1] + ")" },
				_react2["default"].createElement(
					_ToolTipText2["default"],
					{ x: 0, y: 0,
						fontFamily: fontFamily, fontSize: fontSize },
					xLabel ? _react2["default"].createElement(
						_ToolTipTSpanLabel2["default"],
						{ x: 0, dy: "5", fill: labelStroke },
						xLabel + ": "
					) : null,
					xLabel ? _react2["default"].createElement(
						"tspan",
						{ fill: valueStroke || stroke },
						xDisplayValue
					) : null,
					_react2["default"].createElement(
						_ToolTipTSpanLabel2["default"],
						{ fill: labelStroke },
						" " + yLabel + ": "
					),
					_react2["default"].createElement(
						"tspan",
						{ fill: valueStroke || stroke },
						yDisplayValue
					)
				)
			);
		}
	}]);

	return SingleValueTooltip;
})(_react2["default"].Component);

SingleValueTooltip.contextTypes = {
	chartData: _react2["default"].PropTypes.array.isRequired,
	currentItems: _react2["default"].PropTypes.array.isRequired,
	width: _react2["default"].PropTypes.number.isRequired,
	height: _react2["default"].PropTypes.number.isRequired,
	dataTransform: _react2["default"].PropTypes.array
};

SingleValueTooltip.propTypes = {
	forChart: _react2["default"].PropTypes.number.isRequired,
	forSeries: _react2["default"].PropTypes.number.isRequired,
	xDisplayFormat: _react2["default"].PropTypes.func,
	yDisplayFormat: _react2["default"].PropTypes.func.isRequired,
	xLabel: _react2["default"].PropTypes.string,
	yLabel: _react2["default"].PropTypes.string.isRequired,
	labelStroke: _react2["default"].PropTypes.string.isRequired,
	valueStroke: _react2["default"].PropTypes.string,
	origin: _react2["default"].PropTypes.oneOfType([_react2["default"].PropTypes.array, _react2["default"].PropTypes.func]).isRequired,
	fontFamily: _react2["default"].PropTypes.string,
	fontSize: _react2["default"].PropTypes.number,
	onClick: _react2["default"].PropTypes.func,
	xAccessor: _react2["default"].PropTypes.func,
	yAccessor: _react2["default"].PropTypes.func
};

SingleValueTooltip.defaultProps = {
	origin: [0, 0],
	labelStroke: "#4682B4",
	yDisplayFormat: function yDisplayFormat(d) {
		return d;
	},
	xAccessor: function xAccessor(d) {
		return d.date;
	}
};

exports["default"] = SingleValueTooltip;
module.exports = exports["default"];