"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});
function buildHA(data, indexAccessor, indexMutator, dateAccessor, dateMutator) {
	var prevEach;

	var haData = data.map(function (d) {
		var each = {};
		indexMutator(each, indexAccessor(d));
		each.close = (d.open + d.high + d.low + d.close) / 4;

		dateMutator(each, dateAccessor(d));

		if (!prevEach) {
			each.open = d.open;
			each.high = d.high;
			each.low = d.low;
		} else {
			each.open = (prevEach.open + prevEach.close) / 2;
			each.high = Math.max(each.open, d.high, each.close);
			each.low = Math.min(each.open, d.low, each.close);
			each.trueRange = Math.max(d.high - d.low, d.high - prevEach.close, d.low - prevEach.close);
		}
		each.volume = d.volume;

		each.startOfWeek = d.startOfWeek;
		each.startOfMonth = d.startOfMonth;
		each.startOfQuarter = d.startOfQuarter;
		each.startOfYear = d.startOfYear;

		prevEach = each;
		return each;
	});
	// console.table(haData);
	return haData;
}

function HeikinAshiTransformer() {
	var newOptions;
	function transform(data) {
		var _newOptions = newOptions;
		var dateAccessor = _newOptions.dateAccessor;
		var dateMutator = _newOptions.dateMutator;
		var indexAccessor = _newOptions.indexAccessor;
		var indexMutator = _newOptions.indexMutator;

		// console.log(data, options);

		var haData = {};
		Object.keys(data).forEach(function (key) {
			return haData[key] = buildHA(data[key], indexAccessor, indexMutator, dateAccessor, dateMutator);
		});

		return haData;
	};

	transform.options = function (opt) {
		newOptions = opt;
		return opt;
	};
	return transform;
}

exports["default"] = HeikinAshiTransformer;
module.exports = exports["default"];