"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var _utilsATRCalculator = require("../utils/ATRCalculator");

var _utilsATRCalculator2 = _interopRequireDefault(_utilsATRCalculator);

var _objectAssign = require("object-assign");

var _objectAssign2 = _interopRequireDefault(_objectAssign);

var _defaultOptions = require("./defaultOptions");

function KagiTransformer() {
	var newOptions;
	function transform(data) {
		var _newOptions = newOptions;
		var reversalType = _newOptions.reversalType;
		var period = _newOptions.period;
		var reversal = _newOptions.reversal;
		var source = _newOptions.source;
		var _newOptions2 = newOptions;
		var dateAccessor = _newOptions2.dateAccessor;
		var dateMutator = _newOptions2.dateMutator;
		var indexMutator = _newOptions2.indexMutator;

		var reversalThreshold, pricingMethod;
		if (reversalType === "ATR") {
			(0, _utilsATRCalculator2["default"])(data.D, period);
			reversalThreshold = function (d) {
				return d["atr" + period];
			};
		} else {
			reversalThreshold = function () {
				return (/* d */reversal
				);
			};
		}

		pricingMethod = function (d) {
			return d[source];
		};

		var kagiData = [];

		var index = 0,
		    prevPeak,
		    prevTrough,
		    direction;
		var line = {};

		data.D.forEach(function (d) {
			if (line.from === undefined) {
				indexMutator(line, index++);
				dateMutator(line, dateAccessor(d));
				line.from = dateAccessor(d);

				if (!line.open) line.open = d.open;
				line.high = d.high;
				line.low = d.low;
				if (!line.close) line.close = pricingMethod(d);
				line.startOfYear = d.startOfYear;
				line.startOfQuarter = d.startOfQuarter;
				line.startOfMonth = d.startOfMonth;
				line.startOfWeek = d.startOfWeek;
			}

			if (!line.startOfYear) {
				line.startOfYear = d.startOfYear;
				if (line.startOfYear) {
					line.date = d.date;
					// line.displayDate = d.displayDate;
				}
			}

			if (!line.startOfQuarter) {
				line.startOfQuarter = d.startOfQuarter;
				if (line.startOfQuarter && !line.startOfYear) {
					line.date = d.date;
					// line.displayDate = d.displayDate;
				}
			}

			if (!line.startOfMonth) {
				line.startOfMonth = d.startOfMonth;
				if (line.startOfMonth && !line.startOfQuarter) {
					line.date = d.date;
					// line.displayDate = d.displayDate;
				}
			}
			if (!line.startOfWeek) {
				line.startOfWeek = d.startOfWeek;
				if (line.startOfWeek && !line.startOfMonth) {
					line.date = d.date;
					// line.displayDate = d.displayDate;
				}
			}
			line.volume = (line.volume || 0) + d.volume;
			line.high = Math.max(line.high, d.high);
			line.low = Math.min(line.low, d.low);
			line.to = dateAccessor(d);

			var priceMovement = pricingMethod(d) - line.close;

			if (line.close > line.open /* going up */ && priceMovement > 0 /* and moving in same direction */ || line.close < line.open /* going down */ && priceMovement < 0 /* and moving in same direction */) {
					line.close = pricingMethod(d);
					if (prevTrough && line.close < prevTrough) {
						// going below the prevTrough, so change from yang to yin
						// A yin line forms when a Kagi line breaks below the prior trough.
						line.changePoint = prevTrough;
						if (line.startAs !== "yin") {
							line.changeTo = "yin";
							// line.startAs = "yang";
						}
					}
					if (prevPeak && line.close > prevPeak) {
						// going above the prevPeak, so change from yin to yang
						// A yang line forms when a Kagi line breaks above the prior peak
						line.changePoint = prevPeak;
						if (line.startAs !== "yang") {
							line.changeTo = "yang";
							// line.startAs = "yin";
						}
					}
				} else if (line.close > line.open /* going up */
				 && priceMovement < 0 /* and moving in other direction */
				 && Math.abs(priceMovement) > reversalThreshold(d) /* and the movement is big enough for reversal */ || line.close < line.open /* going down */
				 && priceMovement > 0 /* and moving in other direction */
				 && Math.abs(priceMovement) > reversalThreshold(d) /* and the movement is big enough for reversal */) {
						// reverse direction
						var nextLineOpen = line.close;

						direction = (line.close - line.open) / Math.abs(line.close - line.open);

						var nextChangePoint, nextChangeTo;
						if (direction < 0 /* if direction so far has been -ve*/) {
								// compare with line.close becomes prevTrough
								if (prevPeak === undefined) prevPeak = line.open;
								prevTrough = line.close;
								if (pricingMethod(d) > prevPeak) {
									nextChangePoint = prevPeak;
									nextChangeTo = "yang";
								}
							} else {
							if (prevTrough === undefined) prevTrough = line.open;
							prevPeak = line.close;
							if (pricingMethod(d) < prevTrough) {
								nextChangePoint = prevTrough;
								nextChangeTo = "yin";
							}
						}
						if (line.startAs === undefined) {
							line.startAs = direction > 0 ? "yang" : "yin";
						}

						var startAs = line.changeTo || line.startAs;
						line.added = true;
						kagiData.push(line);
						direction = -1 * direction; // direction is reversed

						line = (0, _objectAssign2["default"])({}, line);
						line.open = nextLineOpen;
						line.close = pricingMethod(d);
						line.startAs = startAs;
						line.changePoint = nextChangePoint;
						line.changeTo = nextChangeTo;
						line.added = false;
						line.from = undefined;
						line.volume = 0;
						indexMutator(line, index);
					} else {
					// console.log("MOVING IN REV DIR BUT..", line.open, line.close, pricingMethod(d));
				}
			line.current = pricingMethod(d);
			var dir = line.close - line.open;
			dir = dir / Math.abs(dir);
			line.reverseAt = dir > 0 ? line.close - reversalThreshold(d) : line.open - reversalThreshold(d);
		});
		if (!line.added) kagiData.push(line);

		return { "D": kagiData };
	};

	transform.options = function (opt) {
		newOptions = (0, _objectAssign2["default"])({}, _defaultOptions.Kagi, opt);
		// console.log(newOptions);
		return newOptions;
	};
	return transform;
}

exports["default"] = KagiTransformer;
module.exports = exports["default"];