"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});
exports.containsChart = containsChart;
exports.getCharts = getCharts;
exports.getChartDataForChart = getChartDataForChart;
exports.getCurrentItemForChart = getCurrentItemForChart;
exports.getChartDataForChartNew = getChartDataForChartNew;
exports.getCurrentItemForChartNew = getCurrentItemForChartNew;
exports.getChartOrigin = getChartOrigin;
exports.getChartDataConfig = getChartDataConfig;
exports.getChartData = getChartData;
exports.getChildren = getChildren;
exports.getMainChart = getMainChart;
exports.getClosest = getClosest;
exports.getDimensions = getDimensions;
exports.getChartConfigFor = getChartConfigFor;
exports.getChartPlotFor = getChartPlotFor;
exports.getCompareYAccessors = getCompareYAccessors;
exports.updateComparisonData = updateComparisonData;
exports.defineScales = defineScales;
exports.getIndicator = getIndicator;
exports.getXAccessor = getXAccessor;
exports.getXYAccessors = getXYAccessors;
exports.identifyOverlaysToAdd = identifyOverlaysToAdd;
exports.identifyCompareBase = identifyCompareBase;
exports.identifyCompareSeries = identifyCompareSeries;
exports.calculateOverlays = calculateOverlays;
exports.calculateIndicator = calculateIndicator;
exports.updateOverlayFirstLast = updateOverlayFirstLast;
exports.updateScales = updateScales;
exports.getCurrentItems = getCurrentItems;
exports.getDataToPlotForDomain = getDataToPlotForDomain;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _d3 = require("d3");

var _d32 = _interopRequireDefault(_d3);

var _utilsScaleUtils = require("../utils/ScaleUtils");

var _utilsScaleUtils2 = _interopRequireDefault(_utilsScaleUtils);

var _utilsOverlayUtils = require("../utils/OverlayUtils");

var _utils = require("./utils");

function containsChart(props) {
	return getCharts(props).length > 0;
}

;

function getCharts(props) {
	return getChildren(props.children, /Chart$/);
}

;

function getChartDataForChart(props, context) {
	return getChartDataForChartNew(context.chartData, props.forChart);
}

;

function getCurrentItemForChart(props, context) {
	return getCurrentItemForChartNew(context.currentItems, props.forChart);
}

;

function getChartDataForChartNew(chartData, chartId) {
	return chartData.filter(function (each) {
		return each.id === chartId;
	})[0];
}

;

function getCurrentItemForChartNew(currentItems, chartId) {
	var currentItem = currentItems.filter(function (each) {
		return each.id === chartId;
	})[0];
	var item = currentItem !== undefined ? currentItem.data : {};
	return item;
}

;

function getChartOrigin(origin, contextWidth, contextHeight) {
	var originCoordinates = typeof origin === "function" ? origin(contextWidth, contextHeight) : origin;
	return originCoordinates;
}

;

function getChartDataConfig(props, innerDimensions, other) {
	var charts = getCharts(props);
	return charts.map(function (each) {
		return {
			id: each.props.id,
			config: getChartConfigFor(innerDimensions, each.props, other)
		};
	});
}

;

function getChartData(props, innerDimensions, partialData, fullData, other, domainL, domainR) {
	var charts = getCharts(props);

	return charts.map(function (each) {
		var chartProps = each.props;

		var config = getChartConfigFor(innerDimensions, chartProps, other);
		calculateOverlays(fullData, config.overlays);
		var scaleType = defineScales(chartProps, partialData, other);

		// console.log(config.compareSeries);

		var plot = getChartPlotFor(config, scaleType, partialData, domainL, domainR);

		return {
			id: each.props.id,
			config: config,
			scaleType: scaleType,
			plot: plot
		};
	});
}

;

function getChildren(children, regex) {
	var matchingChildren = [];
	_react2["default"].Children.forEach(children, function (child) {
		if (_react2["default"].isValidElement(child) && regex.test(child.props.namespace)) matchingChildren.push(child);
	});
	return matchingChildren;
}

;

function getMainChart(children) {
	var eventCapture = getChildren(children, /EventCapture$/);
	if (eventCapture.length > 1) throw new Error("only one EventCapture allowed");
	if (eventCapture.length > 0) return eventCapture[0].props.mainChart;
	if (eventCapture.length === 0) return getChildren(children, /Chart$/)[0].props.id;
}

;

function getClosest(plotData, mouseXY, chartData) {
	// console.log(chartData);
	var xValue = chartData.plot.scales.xScale.invert(mouseXY[0]);
	var item = (0, _utils.getClosestItem)(plotData, xValue, chartData.config.xAccessor);
	return item;
}

;

function getDimensions(innerDimension, chartProps) {

	var availableWidth = innerDimension.width;
	var availableHeight = innerDimension.height;

	var fullWidth = chartProps.width || availableWidth;
	var fullHeight = chartProps.height || availableHeight;

	return {
		availableWidth: availableWidth,
		availableHeight: availableHeight,
		width: fullWidth,
		height: fullHeight
	};
}

;

function getChartConfigFor(innerDimension, chartProps, other) {
	var padding = chartProps.padding;

	var dimensions = getDimensions(innerDimension, chartProps);
	// var indicator = getIndicator(chartProps);
	// calculateIndicator(fullData, indicator);

	// var accessors = getXYAccessors(chartProps, other, indicator);
	// identify overlays
	var xAccessor = getXAccessor(chartProps, other);
	var overlaysToAdd = identifyOverlaysToAdd(chartProps);
	var compareBase = identifyCompareBase(chartProps);
	var compareSeries = identifyCompareSeries(chartProps);
	// console.log(compareBase, compareSeries);
	// calculate overlays
	// calculateOverlays(fullData, overlaysToAdd);
	// calculateRateOfReturn(fullData, compareSeries, compareBase, accessors.yAccessor);

	var origin = typeof chartProps.origin === "function" ? chartProps.origin(dimensions.availableWidth, dimensions.availableHeight) : chartProps.origin;

	var indicatorsWithTicks = overlaysToAdd.filter(function (overlay) {
		return overlay.indicator !== undefined;
	}).filter(function (overlay) {
		return overlay.indicator.yTicks !== undefined;
	});

	var yTicks;
	if (indicatorsWithTicks.length > 0) {
		yTicks = indicatorsWithTicks.map(function (overlay) {
			return overlay.indicator.yTicks();
		}).reduce(function (ticks1, ticks2) {
			return ticks1.concat(ticks2);
		});
	}

	var config = {
		width: dimensions.width,
		height: dimensions.height,
		mouseCoordinates: {
			at: chartProps.yMousePointerDisplayLocation,
			format: chartProps.yMousePointerDisplayFormat
		},
		// indicator: indicator,
		// indicatorOptions: indicator && indicator.options(),
		// domain: indicator && indicator.domain && indicator.domain(),
		origin: origin,
		padding: padding,
		xAccessor: xAccessor,
		overlays: overlaysToAdd,
		compareBase: compareBase,
		compareSeries: compareSeries,
		// scaleType: scales,
		yTicks: yTicks
	};
	return config;
}

;

function getChartPlotFor(config, scaleType, partialData, domainL, domainR) {
	var yaccessors = (0, _utils.pluck)((0, _utils.keysAsArray)(config.overlays), "yAccessor");
	// console.log(yaccessors);
	if (config.compareSeries.length > 0) {
		updateComparisonData(partialData, config.compareBase, config.compareSeries);
		yaccessors = [function (d) {
			return d.compare;
		}];
	}
	var xyValues = _utilsScaleUtils2["default"].flattenData(partialData, [config.xAccessor], yaccessors);

	var overlayValues = updateOverlayFirstLast(partialData, config.overlays);
	var indicators = (0, _utils.pluck)((0, _utils.keysAsArray)(config.overlays), "indicator");
	var domains = indicators.filter(function (indicator) {
		return indicator !== undefined;
	}).filter(function (indicator) {
		return indicator.domain !== undefined;
	}).map(function (indicator) {
		return indicator.domain();
	});

	var domain;
	if (domains.length > 0) {
		domain = domains.reduce(function (a, b) {
			return [Math.min(a[0], b[0]), Math.max(a[1], b[1])];
		});
	}

	var scales = updateScales(xyValues, scaleType, partialData, config.width, config.height, config.padding, domain);

	if (domainL !== undefined && domainR !== undefined) {
		scales.xScale.domain([domainL, domainR]);
	}

	var plot = {
		overlayValues: overlayValues,
		scales: scales
	};
	return plot;
}

;

function getCompareYAccessors(compareWith) {
	var yAccessors = compareWith.map(function (eachCompare) {
		return function (d) {
			return d["compare_" + eachCompare.id + "_percent"];
		};
	});
	yAccessors.push(function (d) {
		return d.compare_base_percent;
	});
	return yAccessors;
}

;

function updateComparisonData(partialData, compareBase, compareSeries) {
	var first = partialData[0];
	var base = compareBase(first);

	partialData.forEach(function (d) {
		d.compare = {};

		d.compare.open = (d.open - base) / base;
		d.compare.high = (d.high - base) / base;
		d.compare.low = (d.low - base) / base;
		d.compare.close = (d.close - base) / base;

		compareSeries.forEach(function (eachSeries) {
			var key = "compare_" + eachSeries.id;
			d.compare[key] = (eachSeries.yAccessor(d) - eachSeries.yAccessor(first)) / eachSeries.yAccessor(first);
		});
	});

	// console.table(partialData);
	// console.log(partialData[7].compare);
}

;

function defineScales(props, data, passThroughProps) {
	var xScale = props.xScale,
	    yScale = props.yScale;

	if (xScale === undefined && passThroughProps) xScale = passThroughProps.xScale;

	if (xScale === undefined) {
		var each = data[0];
		if (typeof each === "object") {
			Object.keys(each).forEach(function (key) {
				if (Object.prototype.toString.call(each[key]) === "[object Date]") {
					xScale = _d32["default"].time.scale();
				}
			});
		}
		if (xScale === undefined) xScale = _d32["default"].scale.linear();
		// xScale = polyLinearTimeScale();
	}
	if (yScale === undefined) {
		yScale = _d32["default"].scale.linear();
	}
	return { xScale: xScale, yScale: yScale };
}

;

function getIndicator(props) {
	var indicator; // = new Array();
	_react2["default"].Children.forEach(props.children, function (child) {
		if (["ReStock.DataSeries"].indexOf(child.props.namespace) > -1) {

			if (child.props && child.props.indicator) {
				var indicatorProp = child.props.indicator;
				indicator = indicatorProp(child.props.options, props, child.props);
			}
		}
	});
	return indicator;
}

;

function getXAccessor(props, passThroughProps) {
	var xAccessor = passThroughProps !== undefined && passThroughProps.xAccessor || props.xAccessor !== undefined && props.xAccessor;
	return xAccessor;
}

;

function getXYAccessors(props, passThroughProps, indicator) {
	var accessor = { xAccessor: null, yAccessor: null };

	_react2["default"].Children.forEach(props.children, function (child) {
		if (["ReStock.DataSeries"].indexOf(child.props.namespace) > -1) {
			if (child.props) {

				var xAccessor = passThroughProps !== undefined && passThroughProps.xAccessor ? passThroughProps.xAccessor : child.props.xAccessor;
				accessor.xAccessor = xAccessor;
				accessor.yAccessor = child.props.yAccessor;
			}
		}
	});
	if (!accessor.yAccessor && indicator) {
		accessor.yAccessor = indicator.yAccessor();
	}
	// if (indicator) console.log(indicator.yAccessor());

	return accessor;
}

;

function identifyOverlaysToAdd(chartProps) {
	var overlaysToAdd = [];
	_react2["default"].Children.forEach(chartProps.children, function (child) {
		if (_react2["default"].isValidElement(child) && /DataSeries$/.test(child.props.namespace)) {
			var yAccessor = child.props.yAccessor;

			var indicatorProp = child.props.indicator;
			if (yAccessor === undefined && indicatorProp === undefined) {
				console.error("Either have yAccessor or indicator which provides a yAccessor for Chart " + chartProps.id + " DataSeries " + child.props.id);
			}
			var indicator = indicatorProp !== undefined ? indicatorProp(child.props.options, chartProps, child.props) : undefined;
			var _child$props = child.props;
			var stroke = _child$props.stroke;
			var fill = _child$props.fill;

			if (stroke === undefined && indicator !== undefined && indicator.stroke !== undefined) stroke = indicator.stroke();
			if (fill === undefined && indicator !== undefined && indicator.fill !== undefined) fill = indicator.fill();
			var overlay = {
				id: child.props.id,
				chartId: chartProps.id,
				yAccessor: yAccessor || indicator.yAccessor(),
				indicator: indicator,
				stroke: stroke,
				fill: fill
			};
			// console.error(overlay.id, overlay.chartId, overlay.stroke, indicator);
			// stroke: indicator.options().stroke || overlayColors(child.props.id)
			overlaysToAdd.push(overlay);
		}
	});
	return overlaysToAdd;
}

;

function identifyCompareBase(props) {
	var compareBase;
	_react2["default"].Children.forEach(props.children, function (child) {
		if (_react2["default"].isValidElement(child) && /DataSeries$/.test(child.props.namespace)) {
			compareBase = child.props.compareBase;
		}
	});
	return compareBase;
}

;

function identifyCompareSeries(props) {
	var overlaysToAdd = [];
	_react2["default"].Children.forEach(props.children, function (child) {
		if (_react2["default"].isValidElement(child) && /DataSeries$/.test(child.props.namespace)) {
			_react2["default"].Children.forEach(child.props.children, function (grandChild) {
				if (_react2["default"].isValidElement(grandChild) && /CompareSeries$/.test(grandChild.props.namespace)) {
					overlaysToAdd.push({
						yAccessor: grandChild.props.yAccessor,
						id: grandChild.props.id,
						stroke: grandChild.props.stroke || (0, _utils.overlayColors)(grandChild.props.id),
						displayLabel: grandChild.props.displayLabel,
						percentYAccessor: function percentYAccessor(d) {
							return d.compare["compare_" + grandChild.props.id];
						}
					});
				}
			});
		}
	});
	return overlaysToAdd;
}

;

function calculateOverlays(fullData, overlays) {
	if (Array.isArray(fullData)) {
		overlays.filter(function (eachOverlay) {
			return eachOverlay.id !== undefined;
		}).forEach(function (overlay) {
			overlay.indicator.calculate(fullData);
		});
	} else {
		Object.keys(fullData).filter(function (key) {
			return ["D", "W", "M"].indexOf(key) > -1;
		}).forEach(function (key) {
			overlays.filter(function (eachOverlay) {
				return eachOverlay.indicator !== undefined;
			}).forEach(function (overlay) {
				overlay.indicator.calculate(fullData[key]);
			});
		});
	}
	// console.table(fullData.M);
	// console.log(overlays);
}

;

function calculateIndicator(fullData, indicator) {
	Object.keys(fullData).filter(function (key) {
		return ["D", "W", "M"].indexOf(key) > -1;
	}).forEach(function (key) {
		if (indicator) indicator.calculate(fullData[key]);
	});
}

;

function updateOverlayFirstLast(data, overlays) {
	// console.log("updateOverlayFirstLast");
	var overlayValues = [];

	overlays.forEach(function (eachOverlay) {
		// console.log(JSON.stringify(first), Object.keys(first), yAccessor(first));
		overlayValues.push({
			id: eachOverlay.id,
			first: (0, _utilsOverlayUtils.firstDefined)(data, eachOverlay.yAccessor),
			last: (0, _utilsOverlayUtils.lastDefined)(data, eachOverlay.yAccessor)
		});
	});
	return overlayValues;
}

;

function updateScales(xyValues, scales, data, width, height, padding, overrideDomain) {
	// console.log("updateScales");
	// width = width - margin.left - margin.right/**/
	// height = height - margin.top - margin.bottom/**/

	scales.xScale.range([padding.left, width - padding.right]);
	// if polylinear scale then set data
	if (scales.xScale.isPolyLinear && scales.xScale.isPolyLinear()) {
		scales.xScale.data(data);
	} else {
		// else set the domain
		scales.xScale.domain(_d32["default"].extent(xyValues.xValues));
	}

	scales.yScale.range([height - padding.top, padding.bottom]);

	if (overrideDomain !== undefined) {
		scales.yScale.domain(overrideDomain);
	} else {
		var domain = _d32["default"].extent(xyValues.yValues);
		scales.yScale.domain(domain);
	}

	return {
		xScale: scales.xScale.copy(),
		yScale: scales.yScale.copy()
	};
}

;

function getCurrentItems(chartData, mouseXY, plotData) {
	return chartData.map(function (eachChartData) {
		var xValue = eachChartData.plot.scales.xScale.invert(mouseXY[0]);
		var item = (0, _utils.getClosestItem)(plotData, xValue, eachChartData.config.xAccessor);
		return { id: eachChartData.id, data: item };
	});
}

;

function getDataToPlotForDomain(domainL, domainR, data, width, xAccessor) {
	var threshold = 0.5; // number of datapoints per 1 px
	var allowedIntervals = ["D", "W", "M"];
	// console.log(domainL, domainR, data, width);

	var dataForInterval, filteredData, interval, leftIndex, rightIndex;

	for (var i = 0; i < allowedIntervals.length; i++) {
		if (!data[allowedIntervals[i]]) continue;
		interval = allowedIntervals[i];
		dataForInterval = data[interval];

		leftIndex = (0, _utils.getClosestItemIndexes)(dataForInterval, domainL, xAccessor).left;
		rightIndex = (0, _utils.getClosestItemIndexes)(dataForInterval, domainR, xAccessor).right;

		// leftIndex = leftX.left;
		// rightIndex = rightX.right;

		filteredData = dataForInterval.slice(leftIndex, rightIndex);

		// console.log(filteredData.length, width * threshold);
		if (filteredData.length < width * threshold) break;
	}

	// console.log(leftX, rightX,  (dd[leftX.left]), xAccessor(dd[rightX.right]));

	return {
		interval: interval,
		data: filteredData,
		leftIndex: leftIndex,
		rightIndex: rightIndex
	};
}

;