"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});
exports.getToolTipLabel = getToolTipLabel;
exports.getYAccessorKey = getYAccessorKey;
exports.firstDefined = firstDefined;
exports.lastDefined = lastDefined;

var _utils = require("./utils");

function getToolTipLabel(props) {
	if (props.type === "sma" || props.type === "ema") {
		var tooltip = props.type.toUpperCase() + "(" + props.options.period + ")";
		return tooltip;
	}
	return "N/A";
}

;

function getYAccessorKey(chartId, props) {
	if (props.type === "sma" || props.type === "ema") {
		var key = props.type + props.options.period + "_chart_" + chartId;
		return key;
	}
	return false;
}

;

function firstDefined(data, accessor) {
	var each;
	for (var i = 0; i < data.length; i++) {
		if (accessor(data[i]) === undefined) continue;
		each = data[i];
		// console.log(i, each, accessor(each));
		break;
	}
	return (0, _utils.cloneMe)(each);
}

;

function lastDefined(data, accessor) {
	var each;
	for (var i = data.length - 1; i >= 0; i--) {
		if (accessor(data[i]) === undefined) continue;
		each = data[i];
		// console.log(i, each, accessor(each));
		break;
	}
	return (0, _utils.cloneMe)(each);
}

;