"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});
exports.isReactVersion13 = isReactVersion13;
exports.isReactVersion14 = isReactVersion14;
exports.cloneMe = cloneMe;
exports.displayNumberFormat = displayNumberFormat;
exports.numberWithCommas = numberWithCommas;
exports.isNumeric = isNumeric;
exports.mergeRecursive = mergeRecursive;
exports.mousePosition = mousePosition;
exports.getValue = getValue;
exports.getClosestItem = getClosestItem;
exports.getClosestItemIndex = getClosestItemIndex;
exports.getClosestItemIndexes = getClosestItemIndexes;
exports.pluck = pluck;
exports.keysAsArray = keysAsArray;
exports.sum = sum;
exports.setter = setter;
exports.getter = getter;
exports.hexToRGBA = hexToRGBA;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _d3 = require("d3");

var _d32 = _interopRequireDefault(_d3);

var overlayColors = _d32["default"].scale.category10();

exports.overlayColors = overlayColors;

function isReactVersion13() {
	var version = _react2["default"].version.split(".")[1];
	return version === "13";
}

;

function isReactVersion14() {
	return _react2["default"].version.split(".")[1] === "14";
}

;

function cloneMe(obj) {
	if (obj == null || typeof obj !== "object") {
		return obj;
	}
	if (obj instanceof Date) {
		return new Date(obj.getTime());
	}
	var temp = {}; // obj.constructor(); // changed

	for (var key in obj) {
		if (obj.hasOwnProperty(key)) {
			temp[key] = cloneMe(obj[key]);
		}
	}
	return temp;
}

;

var displayDateFormat = _d32["default"].time.format("%Y-%m-%d");

exports.displayDateFormat = displayDateFormat;

function displayNumberFormat(x) {
	return numberWithCommas(x.toFixed(2));
}

;

function numberWithCommas(x) {
	return x.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
}

;

function isNumeric(n) {
	return !isNaN(parseFloat(n)) && isFinite(n);
}

;

function mergeRecursive(obj1, obj2) {
	for (var p in obj2) {
		try {
			// Property in destination object set; update its value.
			if (obj2[p].constructor === Object) {
				obj1[p] = mergeRecursive(obj1[p], obj2[p]);
			} else {
				obj1[p] = obj2[p];
			}
		} catch (e) {
			// Property in destination object not set; create it and set its value.
			obj1[p] = obj2[p];
		}
	}

	return obj1;
}

;

function mousePosition(e) {
	var container = e.currentTarget,
	    rect = container.getBoundingClientRect(),
	    x = e.clientX - rect.left - container.clientLeft,
	    y = e.clientY - rect.top - container.clientTop,
	    xy = [Math.round(x), Math.round(y)];
	return xy;
}

;

function getValue(d) {
	if (d instanceof Date) {
		return d.getTime();
	}
	return d;
}

function getClosestItem(array, value, accessor) {
	var lo = 0,
	    hi = array.length - 1;
	while (hi - lo > 1) {
		var mid = Math.round((lo + hi) / 2);
		if (accessor(array[mid]) <= value) {
			lo = mid;
		} else {
			hi = mid;
		}
	}
	if (accessor(array[lo]) === value) hi = lo;
	var closest = Math.abs(accessor(array[lo]) - value) < Math.abs(accessor(array[hi]) - value) ? array[lo] : array[hi];
	// console.log(array[lo], array[hi], closest, lo, hi);
	return cloneMe(closest);
}

;

function getClosestItemIndex(array, value, accessor) {
	var lo = 0,
	    hi = array.length - 1;
	while (hi - lo > 1) {
		var mid = Math.round((lo + hi) / 2);
		if (accessor(array[mid]) <= value) {
			lo = mid;
		} else {
			hi = mid;
		}
	}
	if (accessor(array[lo]) === value) hi = lo;
	var closestIndex = Math.abs(accessor(array[lo]) - value) < Math.abs(accessor(array[hi]) - value) ? lo : hi;

	return closestIndex;
}

;

function getClosestItemIndexes(array, value, accessor) {
	var lo = 0,
	    hi = array.length - 1;
	while (hi - lo > 1) {
		var mid = Math.round((lo + hi) / 2);
		if (accessor(array[mid]) <= value) {
			lo = mid;
		} else {
			hi = mid;
		}
	}
	if (accessor(array[lo]) === value) hi = lo;
	// console.log(array[lo], array[hi], closestIndex, lo, hi);
	return {
		left: value > accessor(array[lo]) ? hi : lo,
		right: value >= accessor(array[hi]) ? hi + 1 : hi
	};
}

;

function pluck(array, key) {
	return array.map(function (each) {
		return getter(each, key);
	});
}

function keysAsArray(obj) {
	return Object.keys(obj).filter(function (key) {
		return obj[key] !== null;
	}).map(function (key) {
		return obj[key];
	});
}

;

function sum(array) {
	return array.reduce(function (d1, d2) {
		return d1 + d2;
	});
}

function setter(obj, subObjectKey, key, value) {
	if (subObjectKey) {
		if (obj[subObjectKey] === undefined) obj[subObjectKey] = {};
		obj[subObjectKey][key] = value;
	} else {
		obj[key] = value;
	}
}

;

function getter(obj, pluckKey) {
	var keys = pluckKey.split(".");
	var value;
	keys.forEach(function (key) {
		if (!value) value = obj[key];else value = value[key];
	});
	return value;
}

;

function hexToRGBA(inputHex, opacity) {
	var hex = inputHex.replace("#", "");
	if (inputHex.indexOf("#") > -1 && (hex.length === 3 || hex.length === 6)) {

		var multiplier = hex.length === 3 ? 1 : 2;

		var r = parseInt(hex.substring(0, 1 * multiplier), 16);
		var g = parseInt(hex.substring(1 * multiplier, 2 * multiplier), 16);
		var b = parseInt(hex.substring(2 * multiplier, 3 * multiplier), 16);

		var result = "rgba(" + r + ", " + g + ", " + b + ", " + opacity + ")";

		return result;
	}
	return inputHex;
}

;

// export default Utils;