<div align="center" markdown="1">

<img src="https://d3vv6lp55qjaqc.cloudfront.net/items/061f0A2n1B0H3p0T1p1f/react-styleguidist-logo.png" alt="React Styleguidist" width="400">

**Isolated React component development environment with a living style guide**

[![Build Status](https://travis-ci.org/styleguidist/react-styleguidist.svg)](https://travis-ci.org/styleguidist/react-styleguidist) [![npm](https://img.shields.io/npm/v/react-styleguidist.svg)](https://www.npmjs.com/package/react-styleguidist) [![Join the chat at https://gitter.im/styleguidist/styleguidist](https://badges.gitter.im/styleguidist/styleguidist.svg)](https://gitter.im/styleguidist/styleguidist?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge) [![Codecov](https://codecov.io/gh/styleguidist/react-styleguidist/branch/master/graph/badge.svg)](https://codecov.io/gh/styleguidist/react-styleguidist) [![Open Source Helpers](https://www.codetriage.com/styleguidist/react-styleguidist/badges/users.svg)](https://www.codetriage.com/styleguidist/react-styleguidist)

</div>

React Styleguidist is a component development environment with hot reloaded dev server and a living style guide that you can share with your team. It lists component `propTypes` and shows live, editable usage examples based on Markdown files. Check out [**the demo style guide**](https://react-styleguidist.js.org/examples/basic/).

![](https://d3vv6lp55qjaqc.cloudfront.net/items/271B372x102S0c052i3F/react-styleguidist7.gif)

## Usage

- **[Getting Started](https://react-styleguidist.js.org/docs/getting-started.html): install and run Styleguidist**
- [Documenting components](https://react-styleguidist.js.org/docs/documenting.html): how to write documentation
- [Locating components](https://react-styleguidist.js.org/docs/components.html): point Styleguidist to your React components
- [Configuring webpack](https://react-styleguidist.js.org/docs/webpack.html): tell Styleguidist how to load your code
- [Cookbook](https://react-styleguidist.js.org/docs/cookbook.html): how to solve common tasks with Styleguidist

## Advanced documentation

- [Configuration](https://react-styleguidist.js.org/docs/configuration.html)
- [CLI commands and options](https://react-styleguidist.js.org/docs/cli.html)
- [Node.js API](https://react-styleguidist.js.org/docs/api.html)

## Examples

- [Basic style guide](https://react-styleguidist.js.org/examples/basic/), [source](./examples/basic)
- Style guide with sections, [source](./examples/sections)
- Style guide with customized styles, [source](./examples/customised)
- Style guide with custom express endpoints, [source](./examples/express)
- Create React App integration, [source](./examples/cra)

## Showcase

Real projects using React Styleguidist:

- [Rumble Charts](https://rumble-charts.github.io/rumble-charts/)
- [better-react-spinkit](http://better-react-spinkit.benjamintatum.com/)
- [Semantic UI Components for React](https://hallister.github.io/semantic-react/)
- [Dialog Components](https://dialogs.github.io/dialog-web-components/)
- [Bulma Components](https://bokuweb.github.io/re-bulma/)
- [Yammer Components](https://microsoft.github.io/YamUI/)
- [More projects…](https://github.com/styleguidist/react-styleguidist/issues/127)

## Integration with other tools

- Create React App — just works, see the [Getting Started](https://react-styleguidist.js.org/docs/getting-started.html) guide!
- Create React App + TypeScript, see [Configuring webpack](https://react-styleguidist.js.org/docs/webpack.html)
- TypeScript, see [react-docgen-typescript](https://github.com/styleguidist/react-docgen-typescript)
- Vue, see [Vue Styleguidist](https://github.com/vue-styleguidist/vue-styleguidist)

## Third-party tools

- [snapguidist](https://github.com/styleguidist/snapguidist): snapshot testing for React Styleguidist
- [react-styleguidist-visual](https://github.com/unindented/react-styleguidist-visual): automated visual testing for React Styleguidist, using Puppeteer and pixelmatch
- [styleguidist-scrapper](https://github.com/livechat/styleguidist-scrapper): scrapper script for documentation generated by React Styleguidist

## Resources

- [The Dream of Styleguide Driven Development](https://www.youtube.com/watch?v=JjXnmhNW8Cs) talk by [Sara Vieira](https://github.com/saravieira)
- [Building React Components Library](https://skillsmatter.com/skillscasts/8140-building-react-components-library) talk by [Robert Haritonov](https://github.com/operatino)
- [Say Cheese: Snapshots and Visual Testing](https://developers.livechatinc.com/blog/snapshots-visual-testing/)
- [Interview with Artem Sapegin](https://survivejs.com/blog/styleguidist-interview/) about React Styleguidist.

## Change log

The change log can be found on the [Releases page](https://github.com/styleguidist/react-styleguidist/releases).

## Contributing

Everyone is welcome to contribute. Please take a moment to read the [contributing guidelines](.github/Contributing.md) and the [developer guide](https://react-styleguidist.js.org/docs/development.html).

## Sponsoring

[Become a sponsor](https://opencollective.com/styleguidist#sponsor) and get your logo on our Readme on GitHub with a link to your site.

<!-- prettier-ignore -->
<a href="https://opencollective.com/styleguidist/sponsor/0/website" target="_blank"><img src="https://opencollective.com/styleguidist/sponsor/0/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/sponsor/1/website" target="_blank"><img src="https://opencollective.com/styleguidist/sponsor/1/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/sponsor/2/website" target="_blank"><img src="https://opencollective.com/styleguidist/sponsor/2/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/sponsor/3/website" target="_blank"><img src="https://opencollective.com/styleguidist/sponsor/3/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/sponsor/4/website" target="_blank"><img src="https://opencollective.com/styleguidist/sponsor/4/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/sponsor/5/website" target="_blank"><img src="https://opencollective.com/styleguidist/sponsor/5/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/sponsor/6/website" target="_blank"><img src="https://opencollective.com/styleguidist/sponsor/6/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/sponsor/7/website" target="_blank"><img src="https://opencollective.com/styleguidist/sponsor/7/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/sponsor/8/website" target="_blank"><img src="https://opencollective.com/styleguidist/sponsor/8/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/sponsor/9/website" target="_blank"><img src="https://opencollective.com/styleguidist/sponsor/9/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/sponsor/10/website" target="_blank"><img src="https://opencollective.com/styleguidist/sponsor/10/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/sponsor/11/website" target="_blank"><img src="https://opencollective.com/styleguidist/sponsor/11/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/sponsor/12/website" target="_blank"><img src="https://opencollective.com/styleguidist/sponsor/12/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/sponsor/13/website" target="_blank"><img src="https://opencollective.com/styleguidist/sponsor/13/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/sponsor/14/website" target="_blank"><img src="https://opencollective.com/styleguidist/sponsor/14/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/sponsor/15/website" target="_blank"><img src="https://opencollective.com/styleguidist/sponsor/15/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/sponsor/16/website" target="_blank"><img src="https://opencollective.com/styleguidist/sponsor/16/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/sponsor/17/website" target="_blank"><img src="https://opencollective.com/styleguidist/sponsor/17/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/sponsor/18/website" target="_blank"><img src="https://opencollective.com/styleguidist/sponsor/18/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/sponsor/19/website" target="_blank"><img src="https://opencollective.com/styleguidist/sponsor/19/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/sponsor/20/website" target="_blank"><img src="https://opencollective.com/styleguidist/sponsor/20/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/sponsor/21/website" target="_blank"><img src="https://opencollective.com/styleguidist/sponsor/21/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/sponsor/22/website" target="_blank"><img src="https://opencollective.com/styleguidist/sponsor/22/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/sponsor/23/website" target="_blank"><img src="https://opencollective.com/styleguidist/sponsor/23/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/sponsor/24/website" target="_blank"><img src="https://opencollective.com/styleguidist/sponsor/24/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/sponsor/25/website" target="_blank"><img src="https://opencollective.com/styleguidist/sponsor/25/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/sponsor/26/website" target="_blank"><img src="https://opencollective.com/styleguidist/sponsor/26/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/sponsor/27/website" target="_blank"><img src="https://opencollective.com/styleguidist/sponsor/27/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/sponsor/28/website" target="_blank"><img src="https://opencollective.com/styleguidist/sponsor/28/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/sponsor/29/website" target="_blank"><img src="https://opencollective.com/styleguidist/sponsor/29/avatar.svg"></a>

[Become a backer](https://opencollective.com/styleguidist#backer) get your image on our Readme on GitHub with a link to your site.

<!-- prettier-ignore -->
<a href="https://opencollective.com/styleguidist/backer/0/website" target="_blank"><img src="https://opencollective.com/styleguidist/backer/0/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/backer/1/website" target="_blank"><img src="https://opencollective.com/styleguidist/backer/1/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/backer/2/website" target="_blank"><img src="https://opencollective.com/styleguidist/backer/2/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/backer/3/website" target="_blank"><img src="https://opencollective.com/styleguidist/backer/3/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/backer/4/website" target="_blank"><img src="https://opencollective.com/styleguidist/backer/4/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/backer/5/website" target="_blank"><img src="https://opencollective.com/styleguidist/backer/5/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/backer/6/website" target="_blank"><img src="https://opencollective.com/styleguidist/backer/6/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/backer/7/website" target="_blank"><img src="https://opencollective.com/styleguidist/backer/7/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/backer/8/website" target="_blank"><img src="https://opencollective.com/styleguidist/backer/8/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/backer/9/website" target="_blank"><img src="https://opencollective.com/styleguidist/backer/9/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/backer/10/website" target="_blank"><img src="https://opencollective.com/styleguidist/backer/10/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/backer/11/website" target="_blank"><img src="https://opencollective.com/styleguidist/backer/11/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/backer/12/website" target="_blank"><img src="https://opencollective.com/styleguidist/backer/12/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/backer/13/website" target="_blank"><img src="https://opencollective.com/styleguidist/backer/13/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/backer/14/website" target="_blank"><img src="https://opencollective.com/styleguidist/backer/14/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/backer/15/website" target="_blank"><img src="https://opencollective.com/styleguidist/backer/15/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/backer/16/website" target="_blank"><img src="https://opencollective.com/styleguidist/backer/16/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/backer/17/website" target="_blank"><img src="https://opencollective.com/styleguidist/backer/17/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/backer/18/website" target="_blank"><img src="https://opencollective.com/styleguidist/backer/18/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/backer/19/website" target="_blank"><img src="https://opencollective.com/styleguidist/backer/19/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/backer/20/website" target="_blank"><img src="https://opencollective.com/styleguidist/backer/20/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/backer/21/website" target="_blank"><img src="https://opencollective.com/styleguidist/backer/21/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/backer/22/website" target="_blank"><img src="https://opencollective.com/styleguidist/backer/22/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/backer/23/website" target="_blank"><img src="https://opencollective.com/styleguidist/backer/23/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/backer/24/website" target="_blank"><img src="https://opencollective.com/styleguidist/backer/24/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/backer/25/website" target="_blank"><img src="https://opencollective.com/styleguidist/backer/25/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/backer/26/website" target="_blank"><img src="https://opencollective.com/styleguidist/backer/26/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/backer/27/website" target="_blank"><img src="https://opencollective.com/styleguidist/backer/27/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/backer/28/website" target="_blank"><img src="https://opencollective.com/styleguidist/backer/28/avatar.svg"></a>
<a href="https://opencollective.com/styleguidist/backer/29/website" target="_blank"><img src="https://opencollective.com/styleguidist/backer/29/avatar.svg"></a>

## Authors and license

[Artem Sapegin](http://sapegin.me) and [contributors](https://github.com/styleguidist/react-styleguidist/graphs/contributors).

Logo by [Sara Vieira](https://github.com/SaraVieira) and [Andrey Okonetchnikov](https://github.com/okonet).

MIT License, see the included [License.md](License.md) file.
