import "core-js/modules/es.object.assign";
import "core-js/modules/es.object.keys";

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

import React from 'react';
import PropTypes from 'prop-types';
import Slot from 'rsg-components/Slot';
import SectionHeadingRenderer from 'rsg-components/SectionHeading/SectionHeadingRenderer';
import getUrl from '../../utils/getUrl';
export default function SectionHeading(_ref) {
  var slotName = _ref.slotName,
      slotProps = _ref.slotProps,
      children = _ref.children,
      id = _ref.id,
      pagePerSection = _ref.pagePerSection,
      rest = _objectWithoutPropertiesLoose(_ref, ["slotName", "slotProps", "children", "id", "pagePerSection"]);

  var href = pagePerSection ? getUrl({
    slug: id,
    id: rest.depth !== 1,
    takeHash: true
  }) : getUrl({
    slug: id,
    anchor: true
  });
  return React.createElement(SectionHeadingRenderer, _extends({
    toolbar: React.createElement(Slot, {
      name: slotName,
      props: slotProps
    }),
    id: id,
    href: href
  }, rest), children);
}
SectionHeading.propTypes = {
  children: PropTypes.node,
  id: PropTypes.string.isRequired,
  slotName: PropTypes.string.isRequired,
  slotProps: PropTypes.object.isRequired,
  depth: PropTypes.number.isRequired,
  deprecated: PropTypes.bool,
  pagePerSection: PropTypes.bool
};