import "core-js/modules/es.array.concat";
import "core-js/modules/es.array.map";
import "core-js/modules/es.object.assign";

/**
 * Do things that are hard or impossible to do in a loader: we don’t have access to component name
 * and props in the styleguide-loader because we’re using `require` to load the component module.
 *
 * @param {Array} components
 * @return {Array}
 */
export default function processComponents(components) {
  return components.map(function (component) {
    var newComponent = Object.assign({}, component, {
      // Add .name shortcuts for names instead of .props.displayName.
      name: component.props.displayName,
      visibleName: component.props.visibleName || component.props.displayName,
      props: Object.assign({}, component.props, {
        // Append @example doclet to all examples
        examples: [].concat(component.props.examples || [], component.props.example || [])
      })
    });
    return newComponent;
  });
}