"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createContainer = createContainer;
exports["default"] = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _context = require("../context");

var _store = require("../store");

var _shallowEqual = _interopRequireDefault(require("../utils/shallow-equal"));

var _excluded = ["children", "scope", "isGlobal"];

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var noop = function noop() {
  return function () {};
};

var Container = /*#__PURE__*/function (_Component) {
  _inherits(Container, _Component);

  var _super = _createSuper(Container);

  function Container(_props, context) {
    var _this;

    _classCallCheck(this, Container);

    _this = _super.call(this, _props, context);

    _defineProperty(_assertThisInitialized(_this), "registry", new _store.StoreRegistry('__local__'));

    _defineProperty(_assertThisInitialized(_this), "scopedHooks", {});

    _defineProperty(_assertThisInitialized(_this), "bindContainerActions", function (scope) {
      var _this$constructor = _this.constructor,
          storeType = _this$constructor.storeType,
          hooks = _this$constructor.hooks;
      var api = _this.state.api; // we explicitly pass scope as it might be changed

      var _api$getStore = api.getStore(storeType, scope),
          storeState = _api$getStore.storeState;

      var actions = (0, _store.bindActions)(storeType.actions, storeState, _this.getContainerProps);
      _this.scopedHooks = (0, _store.bindActions)(hooks, storeState, _this.getContainerProps, actions); // make sure we also reset actionProps

      _this.actionProps = null;
      return actions;
    });

    _defineProperty(_assertThisInitialized(_this), "triggerContainerAction", function (nextProps) {
      var nextActionProps = _this.filterActionProps(nextProps);

      var prevActionProps = _this.actionProps;
      if ((0, _shallowEqual["default"])(prevActionProps, nextActionProps)) return; // store restProps on instance so we can diff and use fresh props
      // in actions even before react sets them in this.props

      _this.actionProps = nextActionProps;

      if (_this.scopedHooks.onInit) {
        _this.scopedHooks.onInit();

        _this.scopedHooks.onInit = null;
      } else {
        _this.scopedHooks.onUpdate();
      }
    });

    _defineProperty(_assertThisInitialized(_this), "filterActionProps", function (props) {
      // eslint-disable-next-line no-unused-vars
      var children = props.children,
          scope = props.scope,
          isGlobal = props.isGlobal,
          restProps = _objectWithoutProperties(props, _excluded);

      return restProps;
    });

    _defineProperty(_assertThisInitialized(_this), "getContainerProps", function () {
      return _this.actionProps;
    });

    var _this$context = _this.context,
        _this$context$globalR = _this$context.globalRegistry,
        globalRegistry = _this$context$globalR === void 0 ? _store.defaultRegistry : _this$context$globalR,
        _this$context$getStor = _this$context.getStore,
        _getStore = _this$context$getStor === void 0 ? _store.defaultRegistry.getStore : _this$context$getStor;

    _this.state = {
      api: {
        globalRegistry: globalRegistry,
        getStore: function getStore(Store, scope) {
          return _this.getScopedStore(Store, scope) || _getStore(Store);
        }
      },
      // stored to make them available in getDerivedStateFromProps
      // as js context there is null https://github.com/facebook/react/issues/12612
      bindContainerActions: _this.bindContainerActions,
      triggerContainerAction: _this.triggerContainerAction,
      scope: _props.scope
    };
    _this.state.scopedActions = _this.bindContainerActions(_props.scope);
    return _this;
  }

  _createClass(Container, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (this.props.scope !== prevProps.scope) {
        // Trigger a forced update on all subscribers
        // as render might have been blocked
        this.triggerScopeChange(prevProps.scope); // Check if instance has still subscribers, if not delete

        this.deleteScopedStore(prevProps.scope);
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      var _this2 = this;

      // schedule on next tick as this is called by React before useEffect cleanup
      // so if we run immediately listeners will still be there and run
      Promise.resolve().then(function () {
        _this2.scopedHooks.onCleanup(); // Check if scope has still subscribers, if not delete


        _this2.deleteScopedStore();
      });
    }
  }, {
    key: "getRegistry",
    value: function getRegistry() {
      var isLocal = !this.props.scope && !this.props.isGlobal;
      return isLocal ? this.registry : this.state.api.globalRegistry;
    }
  }, {
    key: "getScopedStore",
    value: function getScopedStore(Store) {
      var scopeId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.props.scope;
      var storeType = this.constructor.storeType;

      if (Store !== storeType) {
        return null;
      }

      var _this$getRegistry$get = this.getRegistry().getStore(Store, scopeId),
          storeState = _this$getRegistry$get.storeState; // instead of returning global bound actions
      // we return the ones with the countainer props binding


      return {
        storeState: storeState,
        actions: this.state.scopedActions
      };
    }
  }, {
    key: "triggerScopeChange",
    value: function triggerScopeChange(prevScopeId) {
      var storeType = this.constructor.storeType;
      var previous = this.getScopedStore(storeType, prevScopeId); // When called, subscribers that have already re-rendered with the new
      // scope are no longer subscribed to the old one, so we "force update"
      // the remaining.
      // This is sub-optimal as if there are other containers with the same
      // old scope id we will re-render those too, but better than using context
      // as that will re-render all children even if pure/memo

      previous.storeState.notify();
    }
  }, {
    key: "deleteScopedStore",
    value: function deleteScopedStore() {
      var scopeId = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.props.scope;
      var storeType = this.constructor.storeType;

      var _this$getScopedStore = this.getScopedStore(storeType, scopeId),
          storeState = _this$getScopedStore.storeState;

      if (scopeId != null && !storeState.listeners().length) {
        this.getRegistry().deleteStore(storeType, scopeId);
      }
    }
  }, {
    key: "render",
    value: function render() {
      var children = this.props.children;
      return /*#__PURE__*/_react["default"].createElement(_context.Context.Provider, {
        value: this.state.api
      }, children);
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(nextProps, prevState) {
      var scope = nextProps.scope;
      var hasScopeChanged = scope !== prevState.scope;
      var nextState = null;

      if (hasScopeChanged) {
        var actions = prevState.bindContainerActions(scope);
        nextState = {
          scope: scope,
          scopedActions: actions
        };
      } // We trigger the action here so subscribers get new values ASAP


      prevState.triggerContainerAction(nextProps);
      return nextState;
    }
  }]);

  return Container;
}(_react.Component);

exports["default"] = Container;

_defineProperty(Container, "propTypes", {
  children: _propTypes["default"].node,
  scope: _propTypes["default"].string,
  isGlobal: _propTypes["default"].bool
});

_defineProperty(Container, "storeType", null);

_defineProperty(Container, "hooks", null);

_defineProperty(Container, "contextType", _context.Context);

function createContainer(Store) {
  var _class;

  var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
      _ref$onInit = _ref.onInit,
      onInit = _ref$onInit === void 0 ? noop : _ref$onInit,
      _ref$onUpdate = _ref.onUpdate,
      onUpdate = _ref$onUpdate === void 0 ? noop : _ref$onUpdate,
      _ref$onCleanup = _ref.onCleanup,
      onCleanup = _ref$onCleanup === void 0 ? noop : _ref$onCleanup,
      _ref$displayName = _ref.displayName,
      displayName = _ref$displayName === void 0 ? '' : _ref$displayName;

  return _class = /*#__PURE__*/function (_Container) {
    _inherits(_class, _Container);

    var _super2 = _createSuper(_class);

    function _class() {
      _classCallCheck(this, _class);

      return _super2.apply(this, arguments);
    }

    return _createClass(_class);
  }(Container), _defineProperty(_class, "storeType", Store), _defineProperty(_class, "displayName", displayName || "Container(".concat(Store.key.split('__')[0], ")")), _defineProperty(_class, "hooks", {
    onInit: onInit,
    onUpdate: onUpdate,
    onCleanup: onCleanup
  }), _class;
}