"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSubscriber = createSubscriber;

var _hook = require("./hook");

var _excluded = ["children"];

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function hasAdditionalProps(props) {
  for (var i in props) {
    return true;
  }

  return false;
}

function createSubscriber(Store) {
  var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
      selector = _ref.selector,
      _ref$displayName = _ref.displayName,
      displayName = _ref$displayName === void 0 ? '' : _ref$displayName;

  var useStore = (0, _hook.createHook)(Store, {
    selector: selector
  });

  var Subscriber = function Subscriber(_ref2) {
    var children = _ref2.children,
        rest = _objectWithoutProperties(_ref2, _excluded);

    var api = useStore(hasAdditionalProps(rest) ? rest : undefined);
    return children.apply(void 0, _toConsumableArray(api));
  };

  Subscriber.displayName = displayName || "Subscriber(".concat(Store.key.split('__')[0], ")");
  return Subscriber;
}