"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _shallowEqual = _interopRequireDefault(require("../utils/shallow-equal"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var updateMiddleware = function updateMiddleware(storeState) {
  return function (next) {
    return function (arg) {
      var output;
      var state = storeState.getState();
      var nextState = next(state, arg, function (out) {
        output = out;
      });

      if (!(0, _shallowEqual["default"])(nextState, state)) {
        storeState.setState(nextState);
      }

      return output;
    };
  };
};

var _default = updateMiddleware;
exports["default"] = _default;