"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bindActions = exports.bindAction = void 0;

var _defaults = _interopRequireDefault(require("../defaults"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var namedMutator = function namedMutator(storeState, actionName) {
  return function () {
    storeState.mutator.actionName = actionName;
    return storeState.mutator.apply(storeState, arguments);
  };
};

var warnings = new WeakMap();

var bindAction = function bindAction(storeState, actionFn, actionKey) {
  var getContainerProps = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : function () {};
  var boundActions = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : {};

  // Setting mutator name so we can log action name for better debuggability
  var dispatch = function dispatch(thunkFn) {
    var actionName = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : "".concat(actionKey, ".dispatch");
    return thunkFn({
      setState: _defaults["default"].devtools ? namedMutator(storeState, actionName) : storeState.mutator,
      getState: storeState.getState,

      get actions() {
        if (!warnings.has(actionFn)) {
          warnings.set(actionFn, console.warn("react-sweet-state 'actions' property has been deprecated and will be removed in the next mayor. " + "Please check action '".concat(actionName, "' of Store '").concat(storeState.key, "' and use 'dispatch' instead")));
        }

        return boundActions;
      },

      dispatch: dispatch
    }, getContainerProps());
  };

  return function () {
    return dispatch(actionFn.apply(void 0, arguments), actionKey);
  };
};

exports.bindAction = bindAction;

var bindActions = function bindActions(actions, storeState) {
  var getContainerProps = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : function () {
    return {};
  };
  var boundActions = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
  return Object.keys(actions).reduce(function (acc, k) {
    acc[k] = bindAction(storeState, actions[k], k, getContainerProps, boundActions || acc);
    return acc;
  }, {});
};

exports.bindActions = bindActions;