"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _middlewares = _interopRequireDefault(require("../middlewares"));

var _devtools = _interopRequireDefault(require("../enhancers/devtools"));

var _defaults = _interopRequireDefault(require("../defaults"));

var _schedule = _interopRequireDefault(require("../utils/schedule"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function createStoreState(key, initialState) {
  var _listeners = [];
  var currentState = initialState;
  var storeState = {
    key: key,
    getState: function getState() {
      return currentState;
    },
    setState: function setState(nextState) {
      currentState = nextState; // Instead of notifying all hooks immediately, we wait next tick
      // so multiple actions affecting the same store gets combined

      (0, _schedule["default"])(storeState.notify);
    },
    resetState: function resetState() {
      storeState.setState(initialState);
    },
    notify: function notify() {
      for (var i = 0; i < _listeners.length; i++) {
        _listeners[i](storeState.getState());
      }
    },
    subscribe: function subscribe(listener) {
      _listeners = _listeners.concat(listener);
      return function unsubscribe() {
        _listeners = _listeners.filter(function (fn) {
          return fn !== listener;
        });
      };
    },
    listeners: function listeners() {
      return _listeners;
    }
  };
  storeState.mutator = (0, _middlewares["default"])(storeState, _defaults["default"].middlewares);
  return storeState;
}

var _default = (0, _devtools["default"])(createStoreState);

exports["default"] = _default;