"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createStore = createStore;

var _hash = _interopRequireDefault(require("../utils/hash"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function createKey(initialState, actions, name) {
  var src = !name ? Object.keys(actions).reduce(function (acc, k) {
    return acc + actions[k].toString();
  }, '') : '';
  return [name, (0, _hash["default"])(src + JSON.stringify(initialState))].filter(Boolean).join('__');
}

function createStore(_ref) {
  var _ref$name = _ref.name,
      name = _ref$name === void 0 ? '' : _ref$name,
      initialState = _ref.initialState,
      actions = _ref.actions;
  var key;
  return {
    get key() {
      // lazy evaluate key on first access
      return key || (key = createKey(initialState, actions, name));
    },

    initialState: initialState,
    actions: actions
  };
}