"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultRegistry = exports.StoreRegistry = exports.GLOBAL_SCOPE = void 0;

var _bindActions = require("./bind-actions");

var _createState = _interopRequireDefault(require("./create-state"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var GLOBAL_SCOPE = '__global__';
exports.GLOBAL_SCOPE = GLOBAL_SCOPE;

var StoreRegistry = /*#__PURE__*/_createClass(function StoreRegistry() {
  var _this = this;

  var defaultScope = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : GLOBAL_SCOPE;

  _classCallCheck(this, StoreRegistry);

  _defineProperty(this, "stores", new Map());

  _defineProperty(this, "initStore", function (key, Store) {
    var initialState = Store.initialState,
        actions = Store.actions;
    var storeState = (0, _createState["default"])(key, initialState);
    var boundActions = (0, _bindActions.bindActions)(actions, storeState);
    var store = {
      storeState: storeState,
      actions: boundActions
    };

    _this.stores.set(key, store);

    return store;
  });

  _defineProperty(this, "getStore", function (Store) {
    var scopeId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : _this.defaultScope;

    var key = _this.generateKey(Store, scopeId);

    return _this.stores.get(key) || _this.initStore(key, Store);
  });

  _defineProperty(this, "deleteStore", function (Store) {
    var scopeId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : _this.defaultScope;

    var key = _this.generateKey(Store, scopeId);

    _this.stores["delete"](key);
  });

  _defineProperty(this, "generateKey", function (Store, scopeId) {
    return "".concat(Store.key, "@").concat(scopeId);
  });

  this.defaultScope = defaultScope;
});

exports.StoreRegistry = StoreRegistry;
var defaultRegistry = new StoreRegistry();
exports.defaultRegistry = defaultRegistry;