"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.batch = batch;

var _reactDom = require("react-dom");

var _scheduler = require("scheduler");

var _defaults = _interopRequireDefault(require("../defaults"));

var _supportedFeatures = _interopRequireDefault(require("./supported-features"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/* eslint-disable import/no-unresolved */
var isInsideBatchedSchedule = false;

function batch(fn) {
  // if we are in node/tests or nested schedule
  if (!_defaults["default"].batchUpdates || !_supportedFeatures["default"].scheduling() || isInsideBatchedSchedule) {
    return (0, _reactDom.unstable_batchedUpdates)(fn);
  }

  isInsideBatchedSchedule = true; // Use ImmediatePriority as it has -1ms timeout
  // https://github.com/facebook/react/blob/main/packages/scheduler/src/forks/Scheduler.js#L65

  return (0, _scheduler.unstable_scheduleCallback)(_scheduler.unstable_ImmediatePriority, function scheduleBatchedUpdates() {
    (0, _reactDom.unstable_batchedUpdates)(fn);
    isInsideBatchedSchedule = false;
  });
}