"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createMemoizedSelector = createMemoizedSelector;
exports.createSelector = createSelector;
exports.getSelectorInstance = getSelectorInstance;

var _memoize = _interopRequireDefault(require("./memoize"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

// customised version of reselect
function createSelector() {
  for (var _len = arguments.length, funcs = new Array(_len), _key = 0; _key < _len; _key++) {
    funcs[_key] = arguments[_key];
  }

  var resultFunc = funcs.pop();
  var dependencies = Array.isArray(funcs[0]) ? funcs[0] : funcs;
  var memoizedResultFunc = (0, _memoize["default"])(function () {
    return resultFunc.apply(null, arguments);
  }); // this memoisation is optimised for 2 arguments (state, props)

  var selector = (0, _memoize["default"])(function () {
    // calculate all dependencies results
    var params = [];

    for (var i = 0; i < dependencies.length; i++) {
      params.push(dependencies[i].apply(null, arguments));
    } // then call the final func with all them as arguments


    return memoizedResultFunc.apply(null, params);
  }, true); // expose so we can create per scope selectors
  // API compatible with reselect@^4

  selector.resultFunc = resultFunc;
  selector.dependencies = dependencies;
  return selector;
}

function createMemoizedSelector(selector) {
  var isReselector = typeof selector.resultFunc === 'function' && Array.isArray(selector.dependencies);
  var dependencies = isReselector ? selector.dependencies : [function (s) {
    return s;
  }, function (_, p) {
    return p;
  }];
  var resultFunc = isReselector ? selector.resultFunc : selector;
  return createSelector(dependencies, resultFunc);
}

var cache = new WeakMap();

function getSelectorInstance(selector, storeState, hasProps) {
  if (!hasProps) {
    if (!cache.has(storeState)) {
      cache.set(storeState, new WeakMap());
    }

    var scopeSelectors = cache.get(storeState);

    if (!scopeSelectors.has(selector)) {
      scopeSelectors.set(selector, createMemoizedSelector(selector));
    }

    return scopeSelectors.get(selector);
  }

  return createMemoizedSelector(selector);
}