"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = _default;

var _shallowEqual = _interopRequireDefault(require("./shallow-equal"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function exactEqual(objA, objB) {
  return objA === objB;
}

function areArgumentsEqual(propsMode, prev, next) {
  if (prev === null || next === null || prev.length !== next.length) return false; // If propsMode and 2 arguments, means it is an input selector
  // and we check for shallow equality on 2nd one to optimise props

  if (propsMode && prev.length === 2) {
    return prev[0] === next[0] && (0, _shallowEqual["default"])(prev[1], next[1]);
  }

  for (var i = 0; i < prev.length; i++) {
    if (!exactEqual(prev[i], next[i])) return false;
  }

  return true;
}
/**
 * Tailor made memoisation
 */


function _default(resultFn) {
  var propsMode = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  var lastArgs = [];
  var lastResult;
  var calledOnce = false;

  var result = function result() {
    if (calledOnce && areArgumentsEqual(propsMode, arguments, lastArgs)) {
      return lastResult;
    }

    var nextResult = resultFn.apply(this, arguments);

    if (!propsMode && (0, _shallowEqual["default"])(nextResult, lastResult)) {
      return lastResult;
    }

    lastResult = nextResult;
    calledOnce = true;
    lastArgs = arguments;
    return lastResult;
  };

  return result;
}