"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = schedule;

var _defaults = _interopRequireDefault(require("../defaults"));

var _batchedUpdates = require("./batched-updates");

var _supportedFeatures = _interopRequireDefault(require("./supported-features"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var QUEUE = [];
var scheduled;

function schedule(fn) {
  // if we are in node/tests or feature disabled, make updates sync batched
  if (!_defaults["default"].batchUpdates || !_supportedFeatures["default"].scheduling()) return (0, _batchedUpdates.batch)(function () {
    return fn();
  }); // Add to queue if not already there
  // so we avoid multiple notifications to same store listeners

  if (!QUEUE.includes(fn)) QUEUE.push(fn); // if something already started schedule, skip

  if (scheduled) return;
  scheduled = (0, _batchedUpdates.batch)(function () {
    var queueFn;

    while (queueFn = QUEUE.shift()) {
      queueFn();
    }

    scheduled = null;
  });
}