"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = shallowEqual;

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

// Mostly copied from fbjs/packages/fbjs/src/core/shallowEqual.js
// enhanced with keys cache as might get called multiple times with same args
var hasOwnProperty = Object.prototype.hasOwnProperty;
var CACHE = new WeakMap();

function shallowEqual(objA, objB) {
  if (objA === objB) {
    return true;
  }

  if (_typeof(objA) !== 'object' || objA === null || _typeof(objB) !== 'object' || objB === null) {
    return false;
  }

  if (Array.isArray(objA) && Array.isArray(objB)) {
    // do array comparison
    if (objA.length !== objB.length) {
      return false;
    }

    for (var i = 0; i < objA.length; i++) {
      if (objA[i] !== objB[i]) {
        return false;
      }
    }

    return true;
  } else {
    // Handle Date, RegExp, String, Number, ... and complex objects
    var strA = '' + objA;
    var strB = '' + objB;

    if (strA !== strB || strA[0] === '[' && strA !== '[object Object]') {
      return false;
    } // do object comparison


    var keysA;

    if (CACHE.has(objA)) {
      keysA = CACHE.get(objA);
    } else {
      keysA = Object.keys(objA);
      CACHE.set(objA, keysA);
    }

    var keysB;

    if (CACHE.has(objB)) {
      keysB = CACHE.get(objB);
    } else {
      keysB = Object.keys(objB);
      CACHE.set(objB, keysB);
    }

    if (keysA.length !== keysB.length) {
      return false;
    } // Test for A's keys different from B.


    for (var _i = 0; _i < keysA.length; _i++) {
      if (!hasOwnProperty.call(objB, keysA[_i]) || objA[keysA[_i]] !== objB[keysA[_i]]) {
        return false;
      }
    }

    return true;
  }
}