'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _swipeJsIso = require('swipe-js-iso');

var _swipeJsIso2 = _interopRequireDefault(_swipeJsIso);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var ReactSwipe = function (_Component) {
    _inherits(ReactSwipe, _Component);

    function ReactSwipe() {
        _classCallCheck(this, ReactSwipe);

        return _possibleConstructorReturn(this, Object.getPrototypeOf(ReactSwipe).apply(this, arguments));
    }

    _createClass(ReactSwipe, [{
        key: 'componentDidMount',
        value: function componentDidMount() {
            var swipeOptions = this.props.swipeOptions;

            this.swipe = (0, _swipeJsIso2.default)(this.refs.container, swipeOptions);
        }
    }, {
        key: 'componentWillUnmount',
        value: function componentWillUnmount() {
            this.swipe.kill();
            this.swipe = void 0;
        }
    }, {
        key: 'next',
        value: function next() {
            this.swipe.next();
        }
    }, {
        key: 'prev',
        value: function prev() {
            this.swipe.prev();
        }
    }, {
        key: 'slide',
        value: function slide() {
            var _swipe;

            (_swipe = this.swipe).slide.apply(_swipe, arguments);
        }
    }, {
        key: 'getPos',
        value: function getPos() {
            return this.swipe.getPos();
        }
    }, {
        key: 'getNumSlides',
        value: function getNumSlides() {
            return this.swipe.getNumSlides();
        }
    }, {
        key: 'render',
        value: function render() {
            var _props = this.props;
            var id = _props.id;
            var className = _props.className;
            var style = _props.style;
            var children = _props.children;

            return _react2.default.createElement(
                'div',
                { ref: 'container', id: id, className: 'react-swipe-container ' + className, style: style.container },
                _react2.default.createElement(
                    'div',
                    { style: style.wrapper },
                    _react2.default.Children.map(children, function (child) {
                        return _react2.default.cloneElement(child, { style: style.child });
                    })
                )
            );
        }
    }]);

    return ReactSwipe;
}(_react.Component);

ReactSwipe.propTypes = {
    swipeOptions: _react.PropTypes.shape({
        startSlide: _react.PropTypes.number,
        speed: _react.PropTypes.number,
        auto: _react.PropTypes.number,
        continuous: _react.PropTypes.bool,
        disableScroll: _react.PropTypes.bool,
        stopPropagation: _react.PropTypes.bool,
        swiping: _react.PropTypes.func,
        callback: _react.PropTypes.func,
        transitionEnd: _react.PropTypes.func
    }),
    style: _react.PropTypes.shape({
        container: _react.PropTypes.object,
        wrapper: _react.PropTypes.object,
        child: _react.PropTypes.object
    }),
    id: _react.PropTypes.string,
    className: _react.PropTypes.string
};
ReactSwipe.defaultProps = {
    swipeOptions: {},
    style: {
        container: {
            overflow: 'hidden',
            visibility: 'hidden',
            position: 'relative'
        },

        wrapper: {
            overflow: 'hidden',
            position: 'relative'
        },

        child: {
            float: 'left',
            width: '100%',
            position: 'relative',
            transitionProperty: 'transform'
        }
    },
    className: ''
};
exports.default = ReactSwipe;
module.exports = exports['default'];
