'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _utils = require('./utils');

var _utils2 = _interopRequireDefault(_utils);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

exports.default = {
  getDataModel: function getDataModel(nextProps, nextState) {
    var _this = this;

    var _getResolvedState = this.getResolvedState(nextProps, nextState),
        columns = _getResolvedState.columns,
        _getResolvedState$piv = _getResolvedState.pivotBy,
        pivotBy = _getResolvedState$piv === undefined ? [] : _getResolvedState$piv,
        data = _getResolvedState.data,
        pivotIDKey = _getResolvedState.pivotIDKey,
        pivotValKey = _getResolvedState.pivotValKey,
        subRowsKey = _getResolvedState.subRowsKey,
        expanderColumnWidth = _getResolvedState.expanderColumnWidth,
        SubComponent = _getResolvedState.SubComponent,
        page = _getResolvedState.page,
        pages = _getResolvedState.pages,
        pageSize = _getResolvedState.pageSize;

    // Determine Header Groups


    var hasHeaderGroups = false;
    columns.forEach(function (column) {
      if (column.columns) {
        hasHeaderGroups = true;
      }
    });

    // Build Header Groups
    var headerGroups = [];
    var currentSpan = [];

    // A convenience function to add a header and reset the currentSpan
    var addHeader = function addHeader(columns) {
      var column = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : columns[0];

      headerGroups.push(_extends({}, _this.props.column, column, {
        columns: columns
      }));
      currentSpan = [];
    };

    var noSubExpanderColumns = columns.map(function (col) {
      return _extends({}, col, {
        columns: col.columns ? col.columns.filter(function (d) {
          return !d.expander;
        }) : undefined
      });
    });

    var expanderColumnIndex = columns.findIndex(function (col) {
      return col.expander;
    });
    var needsExpander = (SubComponent || pivotBy.length) && expanderColumnIndex === -1;
    var columnsWithExpander = needsExpander ? [{ expander: true }].concat(_toConsumableArray(noSubExpanderColumns)) : noSubExpanderColumns;
    if (needsExpander) {
      expanderColumnIndex = 0;
    }

    var makeDecoratedColumn = function makeDecoratedColumn(column) {
      var dcol = _extends({}, _this.props.column, column);

      if (dcol.expander) {
        dcol.width = expanderColumnWidth;
        return dcol;
      }

      if (typeof dcol.accessor === 'string') {
        var _ret = function () {
          dcol.id = dcol.id || dcol.accessor;
          var accessorString = dcol.accessor;
          dcol.accessor = function (row) {
            return _utils2.default.get(row, accessorString);
          };
          return {
            v: dcol
          };
        }();

        if ((typeof _ret === 'undefined' ? 'undefined' : _typeof(_ret)) === "object") return _ret.v;
      }

      if (dcol.accessor && !dcol.id) {
        console.warn(dcol);
        throw new Error('A column id is required if using a non-string accessor for column above.');
      }

      if (!dcol.accessor) {
        dcol.accessor = function (d) {
          return undefined;
        };
      }

      // Ensure minWidth is not greater than maxWidth if set
      if (dcol.maxWidth < dcol.minWidth) {
        dcol.minWidth = dcol.maxWidth;
      }

      return dcol;
    };

    // Decorate the columns
    var decorateAndAddToAll = function decorateAndAddToAll(col) {
      var decoratedColumn = makeDecoratedColumn(col);
      allDecoratedColumns.push(decoratedColumn);
      return decoratedColumn;
    };
    var allDecoratedColumns = [];
    var decoratedColumns = columnsWithExpander.map(function (column, i) {
      if (column.columns) {
        return _extends({}, column, {
          columns: column.columns.map(decorateAndAddToAll)
        });
      } else {
        return decorateAndAddToAll(column);
      }
    });

    // Build the visible columns, headers and flat column list
    var visibleColumns = decoratedColumns.slice();
    var allVisibleColumns = [];

    visibleColumns = visibleColumns.map(function (column, i) {
      if (column.columns) {
        var visibleSubColumns = column.columns.filter(function (d) {
          return pivotBy.indexOf(d.id) > -1 ? false : _utils2.default.getFirstDefined(d.show, true);
        });
        return _extends({}, column, {
          columns: visibleSubColumns
        });
      }
      return column;
    });

    visibleColumns = visibleColumns.filter(function (column) {
      return column.columns ? column.columns.length : pivotBy.indexOf(column.id) > -1 ? false : _utils2.default.getFirstDefined(column.show, true);
    });

    // Move the pivot columns into a single column if needed
    if (pivotBy.length) {
      var pivotColumns = [];
      for (var i = 0; i < allDecoratedColumns.length; i++) {
        if (pivotBy.indexOf(allDecoratedColumns[i].id) > -1) {
          pivotColumns.push(allDecoratedColumns[i]);
        }
      }
      var _pivotColumn = _extends({}, pivotColumns[0], {
        pivotColumns: pivotColumns,
        expander: true
      });
      visibleColumns[expanderColumnIndex] = _pivotColumn;
    }

    // Build flast list of allVisibleColumns and HeaderGroups
    visibleColumns.forEach(function (column, i) {
      if (column.columns) {
        allVisibleColumns = allVisibleColumns.concat(column.columns);
        if (currentSpan.length > 0) {
          addHeader(currentSpan);
        }
        addHeader(column.columns, column);
        return;
      }
      allVisibleColumns.push(column);
      currentSpan.push(column);
    });
    if (hasHeaderGroups && currentSpan.length > 0) {
      addHeader(currentSpan);
    }

    // Access the data
    var resolvedData = data.map(function (d, i) {
      var row = {
        __original: d,
        __index: i
      };
      allDecoratedColumns.forEach(function (column) {
        if (column.expander) return;
        row[column.id] = column.accessor(d);
      });
      return row;
    });

    // If pivoting, recursively group the data
    var aggregate = function aggregate(rows) {
      var aggregationValues = {};
      aggregatingColumns.forEach(function (column) {
        var values = rows.map(function (d) {
          return d[column.id];
        });
        aggregationValues[column.id] = column.aggregate(values, rows);
      });
      return aggregationValues;
    };
    var standardColumns = pivotBy.length ? allVisibleColumns.slice(1) : allVisibleColumns;
    var aggregatingColumns = standardColumns.filter(function (d) {
      return d.aggregate;
    });
    var pivotColumn = void 0;
    if (pivotBy.length) {
      (function () {
        pivotColumn = allVisibleColumns[0];
        var groupRecursively = function groupRecursively(rows, keys) {
          var i = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;

          // This is the last level, just return the rows
          if (i === keys.length) {
            return rows;
          }
          // Group the rows together for this level
          var groupedRows = Object.entries(_utils2.default.groupBy(rows, keys[i])).map(function (_ref) {
            var _ref3;

            var _ref2 = _slicedToArray(_ref, 2),
                key = _ref2[0],
                value = _ref2[1];

            return _ref3 = {}, _defineProperty(_ref3, pivotIDKey, keys[i]), _defineProperty(_ref3, pivotValKey, key), _defineProperty(_ref3, keys[i], key), _defineProperty(_ref3, subRowsKey, value), _ref3;
          });
          // Recurse into the subRows
          groupedRows = groupedRows.map(function (rowGroup) {
            var subRows = groupRecursively(rowGroup[subRowsKey], keys, i + 1);
            return _extends({}, rowGroup, _defineProperty({}, subRowsKey, subRows), aggregate(subRows));
          });
          return groupedRows;
        };
        resolvedData = groupRecursively(resolvedData, pivotBy);
      })();
    }

    var newPages = _utils2.default.getFirstDefined(pages, Math.ceil(resolvedData.length / pageSize));
    var newPage = page > newPages ? newPage - 1 : page;

    return {
      resolvedData: resolvedData,
      pivotColumn: pivotColumn,
      allVisibleColumns: allVisibleColumns,
      headerGroups: headerGroups,
      allDecoratedColumns: allDecoratedColumns,
      hasHeaderGroups: hasHeaderGroups,
      page: Math.max(newPage, 0)
    };
  },
  getSortedData: function getSortedData(resolvedState) {
    var manual = resolvedState.manual,
        sorting = resolvedState.sorting,
        resolvedData = resolvedState.resolvedData;

    // Resolve the data from either manual data or sorted data

    return {
      sortedData: manual ? resolvedData : this.sortData(resolvedData, sorting)
    };
  },
  fireOnChange: function fireOnChange() {
    this.props.onChange(this.getResolvedState(), this);
  },
  getPropOrState: function getPropOrState(key) {
    return _utils2.default.getFirstDefined(this.props[key], this.state[key]);
  },
  getStateOrProp: function getStateOrProp(key) {
    return _utils2.default.getFirstDefined(this.state[key], this.props[key]);
  },
  sortData: function sortData(data, sorting) {
    var _this2 = this;

    if (!sorting.length) {
      return data;
    }
    var sorted = _utils2.default.orderBy(data, sorting.map(function (sort) {
      return function (row) {
        if (row[sort.id] === null || row[sort.id] === undefined) {
          return -Infinity;
        }
        return typeof row[sort.id] === 'string' ? row[sort.id].toLowerCase() : row[sort.id];
      };
    }), sorting.map(function (d) {
      return !d.desc;
    }));

    return sorted.map(function (row) {
      if (!row[_this2.props.subRowsKey]) {
        return row;
      }
      return _extends({}, row, _defineProperty({}, _this2.props.subRowsKey, _this2.sortData(row[_this2.props.subRowsKey], sorting)));
    });
  },
  getMinRows: function getMinRows() {
    return _utils2.default.getFirstDefined(this.props.minRows, this.getStateOrProp('pageSize'));
  },


  // User actions
  onPageChange: function onPageChange(page) {
    var _this3 = this;

    var onPageChange = this.props.onPageChange;

    if (onPageChange) {
      return onPageChange(page);
    }
    this.setStateWithData({
      expandedRows: {},
      page: page
    }, function () {
      _this3.fireOnChange();
    });
  },
  onPageSizeChange: function onPageSizeChange(newPageSize) {
    var _this4 = this;

    var onPageSizeChange = this.props.onPageSizeChange;

    var _getResolvedState2 = this.getResolvedState(),
        pageSize = _getResolvedState2.pageSize,
        page = _getResolvedState2.page;

    // Normalize the page to display


    var currentRow = pageSize * page;
    var newPage = Math.floor(currentRow / newPageSize);

    if (onPageSizeChange) {
      return onPageSizeChange(newPageSize, newPage);
    }

    this.setStateWithData({
      pageSize: newPageSize,
      page: newPage
    }, function () {
      _this4.fireOnChange();
    });
  },
  sortColumn: function sortColumn(column, additive) {
    var _this5 = this;

    var _getResolvedState3 = this.getResolvedState(),
        sorting = _getResolvedState3.sorting;

    var onSortingChange = this.props.onSortingChange;

    if (onSortingChange) {
      return onSortingChange(column, additive);
    }
    var newSorting = _utils2.default.clone(sorting || []).map(function (d) {
      d.desc = _utils2.default.isSortingDesc(d);
      return d;
    });
    if (!_utils2.default.isArray(column)) {
      // Single-Sort
      var existingIndex = newSorting.findIndex(function (d) {
        return d.id === column.id;
      });
      if (existingIndex > -1) {
        var existing = newSorting[existingIndex];
        if (existing.desc) {
          if (additive) {
            newSorting.splice(existingIndex, 1);
          } else {
            existing.desc = false;
            newSorting = [existing];
          }
        } else {
          existing.desc = true;
          if (!additive) {
            newSorting = [existing];
          }
        }
      } else {
        if (additive) {
          newSorting.push({
            id: column.id,
            desc: false
          });
        } else {
          newSorting = [{
            id: column.id,
            desc: false
          }];
        }
      }
    } else {
      (function () {
        // Multi-Sort
        var existingIndex = newSorting.findIndex(function (d) {
          return d.id === column[0].id;
        });
        // Existing Sorted Column
        if (existingIndex > -1) {
          var _existing = newSorting[existingIndex];
          if (_existing.desc) {
            if (additive) {
              newSorting.splice(existingIndex, column.length);
            } else {
              column.forEach(function (d, i) {
                newSorting[existingIndex + i].desc = false;
              });
            }
          } else {
            column.forEach(function (d, i) {
              newSorting[existingIndex + i].desc = true;
            });
          }
          if (!additive) {
            newSorting = newSorting.slice(existingIndex, column.length);
          }
        } else {
          // New Sort Column
          if (additive) {
            newSorting = newSorting.concat(column.map(function (d) {
              return {
                id: d.id,
                desc: false
              };
            }));
          } else {
            newSorting = column.map(function (d) {
              return {
                id: d.id,
                desc: false
              };
            });
          }
        }
      })();
    }
    this.setStateWithData({
      page: !sorting.length && newSorting.length || !additive ? 0 : this.state.page,
      sorting: newSorting
    }, function () {
      _this5.fireOnChange();
    });
  }
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uL3NyYy9jb21wb25lbnRNZXRob2RzLmpzIl0sIm5hbWVzIjpbImdldERhdGFNb2RlbCIsIm5leHRQcm9wcyIsIm5leHRTdGF0ZSIsImdldFJlc29sdmVkU3RhdGUiLCJjb2x1bW5zIiwicGl2b3RCeSIsImRhdGEiLCJwaXZvdElES2V5IiwicGl2b3RWYWxLZXkiLCJzdWJSb3dzS2V5IiwiZXhwYW5kZXJDb2x1bW5XaWR0aCIsIlN1YkNvbXBvbmVudCIsInBhZ2UiLCJwYWdlcyIsInBhZ2VTaXplIiwiaGFzSGVhZGVyR3JvdXBzIiwiZm9yRWFjaCIsImNvbHVtbiIsImhlYWRlckdyb3VwcyIsImN1cnJlbnRTcGFuIiwiYWRkSGVhZGVyIiwicHVzaCIsInByb3BzIiwibm9TdWJFeHBhbmRlckNvbHVtbnMiLCJtYXAiLCJjb2wiLCJmaWx0ZXIiLCJkIiwiZXhwYW5kZXIiLCJ1bmRlZmluZWQiLCJleHBhbmRlckNvbHVtbkluZGV4IiwiZmluZEluZGV4IiwibmVlZHNFeHBhbmRlciIsImxlbmd0aCIsImNvbHVtbnNXaXRoRXhwYW5kZXIiLCJtYWtlRGVjb3JhdGVkQ29sdW1uIiwiZGNvbCIsIndpZHRoIiwiYWNjZXNzb3IiLCJpZCIsImFjY2Vzc29yU3RyaW5nIiwiZ2V0Iiwicm93IiwiY29uc29sZSIsIndhcm4iLCJFcnJvciIsIm1heFdpZHRoIiwibWluV2lkdGgiLCJkZWNvcmF0ZUFuZEFkZFRvQWxsIiwiZGVjb3JhdGVkQ29sdW1uIiwiYWxsRGVjb3JhdGVkQ29sdW1ucyIsImRlY29yYXRlZENvbHVtbnMiLCJpIiwidmlzaWJsZUNvbHVtbnMiLCJzbGljZSIsImFsbFZpc2libGVDb2x1bW5zIiwidmlzaWJsZVN1YkNvbHVtbnMiLCJpbmRleE9mIiwiZ2V0Rmlyc3REZWZpbmVkIiwic2hvdyIsInBpdm90Q29sdW1ucyIsInBpdm90Q29sdW1uIiwiY29uY2F0IiwicmVzb2x2ZWREYXRhIiwiX19vcmlnaW5hbCIsIl9faW5kZXgiLCJhZ2dyZWdhdGUiLCJyb3dzIiwiYWdncmVnYXRpb25WYWx1ZXMiLCJhZ2dyZWdhdGluZ0NvbHVtbnMiLCJ2YWx1ZXMiLCJzdGFuZGFyZENvbHVtbnMiLCJncm91cFJlY3Vyc2l2ZWx5Iiwia2V5cyIsImdyb3VwZWRSb3dzIiwiT2JqZWN0IiwiZW50cmllcyIsImdyb3VwQnkiLCJrZXkiLCJ2YWx1ZSIsInN1YlJvd3MiLCJyb3dHcm91cCIsIm5ld1BhZ2VzIiwiTWF0aCIsImNlaWwiLCJuZXdQYWdlIiwibWF4IiwiZ2V0U29ydGVkRGF0YSIsInJlc29sdmVkU3RhdGUiLCJtYW51YWwiLCJzb3J0aW5nIiwic29ydGVkRGF0YSIsInNvcnREYXRhIiwiZmlyZU9uQ2hhbmdlIiwib25DaGFuZ2UiLCJnZXRQcm9wT3JTdGF0ZSIsInN0YXRlIiwiZ2V0U3RhdGVPclByb3AiLCJzb3J0ZWQiLCJvcmRlckJ5Iiwic29ydCIsIkluZmluaXR5IiwidG9Mb3dlckNhc2UiLCJkZXNjIiwiZ2V0TWluUm93cyIsIm1pblJvd3MiLCJvblBhZ2VDaGFuZ2UiLCJzZXRTdGF0ZVdpdGhEYXRhIiwiZXhwYW5kZWRSb3dzIiwib25QYWdlU2l6ZUNoYW5nZSIsIm5ld1BhZ2VTaXplIiwiY3VycmVudFJvdyIsImZsb29yIiwic29ydENvbHVtbiIsImFkZGl0aXZlIiwib25Tb3J0aW5nQ2hhbmdlIiwibmV3U29ydGluZyIsImNsb25lIiwiaXNTb3J0aW5nRGVzYyIsImlzQXJyYXkiLCJleGlzdGluZ0luZGV4IiwiZXhpc3RpbmciLCJzcGxpY2UiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7OztBQUFBOzs7Ozs7Ozs7O2tCQUVlO0FBQ2JBLGNBRGEsd0JBQ0NDLFNBREQsRUFDWUMsU0FEWixFQUN1QjtBQUFBOztBQUFBLDRCQWE5QixLQUFLQyxnQkFBTCxDQUFzQkYsU0FBdEIsRUFBaUNDLFNBQWpDLENBYjhCO0FBQUEsUUFFaENFLE9BRmdDLHFCQUVoQ0EsT0FGZ0M7QUFBQSxrREFHaENDLE9BSGdDO0FBQUEsUUFHaENBLE9BSGdDLHlDQUd0QixFQUhzQjtBQUFBLFFBSWhDQyxJQUpnQyxxQkFJaENBLElBSmdDO0FBQUEsUUFLaENDLFVBTGdDLHFCQUtoQ0EsVUFMZ0M7QUFBQSxRQU1oQ0MsV0FOZ0MscUJBTWhDQSxXQU5nQztBQUFBLFFBT2hDQyxVQVBnQyxxQkFPaENBLFVBUGdDO0FBQUEsUUFRaENDLG1CQVJnQyxxQkFRaENBLG1CQVJnQztBQUFBLFFBU2hDQyxZQVRnQyxxQkFTaENBLFlBVGdDO0FBQUEsUUFVaENDLElBVmdDLHFCQVVoQ0EsSUFWZ0M7QUFBQSxRQVdoQ0MsS0FYZ0MscUJBV2hDQSxLQVhnQztBQUFBLFFBWWhDQyxRQVpnQyxxQkFZaENBLFFBWmdDOztBQWVsQzs7O0FBQ0EsUUFBSUMsa0JBQWtCLEtBQXRCO0FBQ0FYLFlBQVFZLE9BQVIsQ0FBZ0Isa0JBQVU7QUFDeEIsVUFBSUMsT0FBT2IsT0FBWCxFQUFvQjtBQUNsQlcsMEJBQWtCLElBQWxCO0FBQ0Q7QUFDRixLQUpEOztBQU1BO0FBQ0EsUUFBTUcsZUFBZSxFQUFyQjtBQUNBLFFBQUlDLGNBQWMsRUFBbEI7O0FBRUE7QUFDQSxRQUFNQyxZQUFZLFNBQVpBLFNBQVksQ0FBQ2hCLE9BQUQsRUFBa0M7QUFBQSxVQUF4QmEsTUFBd0IsdUVBQWZiLFFBQVEsQ0FBUixDQUFlOztBQUNsRGMsbUJBQWFHLElBQWIsY0FDSyxNQUFLQyxLQUFMLENBQVdMLE1BRGhCLEVBRUtBLE1BRkw7QUFHRWIsaUJBQVNBO0FBSFg7QUFLQWUsb0JBQWMsRUFBZDtBQUNELEtBUEQ7O0FBU0EsUUFBTUksdUJBQXVCbkIsUUFBUW9CLEdBQVIsQ0FBWSxlQUFPO0FBQzlDLDBCQUNLQyxHQURMO0FBRUVyQixpQkFBU3FCLElBQUlyQixPQUFKLEdBQWNxQixJQUFJckIsT0FBSixDQUFZc0IsTUFBWixDQUFtQjtBQUFBLGlCQUFLLENBQUNDLEVBQUVDLFFBQVI7QUFBQSxTQUFuQixDQUFkLEdBQXFEQztBQUZoRTtBQUlELEtBTDRCLENBQTdCOztBQU9BLFFBQUlDLHNCQUFzQjFCLFFBQVEyQixTQUFSLENBQWtCO0FBQUEsYUFBT04sSUFBSUcsUUFBWDtBQUFBLEtBQWxCLENBQTFCO0FBQ0EsUUFBTUksZ0JBQWdCLENBQUNyQixnQkFBZ0JOLFFBQVE0QixNQUF6QixLQUFvQ0gsd0JBQXdCLENBQUMsQ0FBbkY7QUFDQSxRQUFNSSxzQkFBc0JGLGlCQUFpQixFQUFDSixVQUFVLElBQVgsRUFBakIsNEJBQXNDTCxvQkFBdEMsS0FBOERBLG9CQUExRjtBQUNBLFFBQUlTLGFBQUosRUFBbUI7QUFDakJGLDRCQUFzQixDQUF0QjtBQUNEOztBQUVELFFBQU1LLHNCQUFzQixTQUF0QkEsbUJBQXNCLENBQUNsQixNQUFELEVBQVk7QUFDdEMsVUFBTW1CLG9CQUNELE1BQUtkLEtBQUwsQ0FBV0wsTUFEVixFQUVEQSxNQUZDLENBQU47O0FBS0EsVUFBSW1CLEtBQUtSLFFBQVQsRUFBbUI7QUFDakJRLGFBQUtDLEtBQUwsR0FBYTNCLG1CQUFiO0FBQ0EsZUFBTzBCLElBQVA7QUFDRDs7QUFFRCxVQUFJLE9BQU9BLEtBQUtFLFFBQVosS0FBeUIsUUFBN0IsRUFBdUM7QUFBQTtBQUNyQ0YsZUFBS0csRUFBTCxHQUFVSCxLQUFLRyxFQUFMLElBQVdILEtBQUtFLFFBQTFCO0FBQ0EsY0FBTUUsaUJBQWlCSixLQUFLRSxRQUE1QjtBQUNBRixlQUFLRSxRQUFMLEdBQWdCO0FBQUEsbUJBQU8sZ0JBQUVHLEdBQUYsQ0FBTUMsR0FBTixFQUFXRixjQUFYLENBQVA7QUFBQSxXQUFoQjtBQUNBO0FBQUEsZUFBT0o7QUFBUDtBQUpxQzs7QUFBQTtBQUt0Qzs7QUFFRCxVQUFJQSxLQUFLRSxRQUFMLElBQWlCLENBQUNGLEtBQUtHLEVBQTNCLEVBQStCO0FBQzdCSSxnQkFBUUMsSUFBUixDQUFhUixJQUFiO0FBQ0EsY0FBTSxJQUFJUyxLQUFKLENBQVUsMEVBQVYsQ0FBTjtBQUNEOztBQUVELFVBQUksQ0FBQ1QsS0FBS0UsUUFBVixFQUFvQjtBQUNsQkYsYUFBS0UsUUFBTCxHQUFnQjtBQUFBLGlCQUFLVCxTQUFMO0FBQUEsU0FBaEI7QUFDRDs7QUFFRDtBQUNBLFVBQUlPLEtBQUtVLFFBQUwsR0FBZ0JWLEtBQUtXLFFBQXpCLEVBQW1DO0FBQ2pDWCxhQUFLVyxRQUFMLEdBQWdCWCxLQUFLVSxRQUFyQjtBQUNEOztBQUVELGFBQU9WLElBQVA7QUFDRCxLQWpDRDs7QUFtQ0E7QUFDQSxRQUFNWSxzQkFBc0IsU0FBdEJBLG1CQUFzQixDQUFDdkIsR0FBRCxFQUFTO0FBQ25DLFVBQU13QixrQkFBa0JkLG9CQUFvQlYsR0FBcEIsQ0FBeEI7QUFDQXlCLDBCQUFvQjdCLElBQXBCLENBQXlCNEIsZUFBekI7QUFDQSxhQUFPQSxlQUFQO0FBQ0QsS0FKRDtBQUtBLFFBQUlDLHNCQUFzQixFQUExQjtBQUNBLFFBQU1DLG1CQUFtQmpCLG9CQUFvQlYsR0FBcEIsQ0FBd0IsVUFBQ1AsTUFBRCxFQUFTbUMsQ0FBVCxFQUFlO0FBQzlELFVBQUluQyxPQUFPYixPQUFYLEVBQW9CO0FBQ2xCLDRCQUNLYSxNQURMO0FBRUViLG1CQUFTYSxPQUFPYixPQUFQLENBQWVvQixHQUFmLENBQW1Cd0IsbUJBQW5CO0FBRlg7QUFJRCxPQUxELE1BS087QUFDTCxlQUFPQSxvQkFBb0IvQixNQUFwQixDQUFQO0FBQ0Q7QUFDRixLQVR3QixDQUF6Qjs7QUFXQTtBQUNBLFFBQUlvQyxpQkFBaUJGLGlCQUFpQkcsS0FBakIsRUFBckI7QUFDQSxRQUFJQyxvQkFBb0IsRUFBeEI7O0FBRUFGLHFCQUFpQkEsZUFBZTdCLEdBQWYsQ0FBbUIsVUFBQ1AsTUFBRCxFQUFTbUMsQ0FBVCxFQUFlO0FBQ2pELFVBQUluQyxPQUFPYixPQUFYLEVBQW9CO0FBQ2xCLFlBQU1vRCxvQkFBb0J2QyxPQUFPYixPQUFQLENBQWVzQixNQUFmLENBQXNCO0FBQUEsaUJBQUtyQixRQUFRb0QsT0FBUixDQUFnQjlCLEVBQUVZLEVBQWxCLElBQXdCLENBQUMsQ0FBekIsR0FBNkIsS0FBN0IsR0FBcUMsZ0JBQUVtQixlQUFGLENBQWtCL0IsRUFBRWdDLElBQXBCLEVBQTBCLElBQTFCLENBQTFDO0FBQUEsU0FBdEIsQ0FBMUI7QUFDQSw0QkFDSzFDLE1BREw7QUFFRWIsbUJBQVNvRDtBQUZYO0FBSUQ7QUFDRCxhQUFPdkMsTUFBUDtBQUNELEtBVGdCLENBQWpCOztBQVdBb0MscUJBQWlCQSxlQUFlM0IsTUFBZixDQUFzQixrQkFBVTtBQUMvQyxhQUFPVCxPQUFPYixPQUFQLEdBQWlCYSxPQUFPYixPQUFQLENBQWU2QixNQUFoQyxHQUF5QzVCLFFBQVFvRCxPQUFSLENBQWdCeEMsT0FBT3NCLEVBQXZCLElBQTZCLENBQUMsQ0FBOUIsR0FBa0MsS0FBbEMsR0FBMEMsZ0JBQUVtQixlQUFGLENBQWtCekMsT0FBTzBDLElBQXpCLEVBQStCLElBQS9CLENBQTFGO0FBQ0QsS0FGZ0IsQ0FBakI7O0FBSUE7QUFDQSxRQUFJdEQsUUFBUTRCLE1BQVosRUFBb0I7QUFDbEIsVUFBTTJCLGVBQWUsRUFBckI7QUFDQSxXQUFLLElBQUlSLElBQUksQ0FBYixFQUFnQkEsSUFBSUYsb0JBQW9CakIsTUFBeEMsRUFBZ0RtQixHQUFoRCxFQUFxRDtBQUNuRCxZQUFJL0MsUUFBUW9ELE9BQVIsQ0FBZ0JQLG9CQUFvQkUsQ0FBcEIsRUFBdUJiLEVBQXZDLElBQTZDLENBQUMsQ0FBbEQsRUFBcUQ7QUFDbkRxQix1QkFBYXZDLElBQWIsQ0FBa0I2QixvQkFBb0JFLENBQXBCLENBQWxCO0FBQ0Q7QUFDRjtBQUNELFVBQU1TLDRCQUNERCxhQUFhLENBQWIsQ0FEQztBQUVKQSxrQ0FGSTtBQUdKaEMsa0JBQVU7QUFITixRQUFOO0FBS0F5QixxQkFBZXZCLG1CQUFmLElBQXNDK0IsWUFBdEM7QUFDRDs7QUFFRDtBQUNBUixtQkFBZXJDLE9BQWYsQ0FBdUIsVUFBQ0MsTUFBRCxFQUFTbUMsQ0FBVCxFQUFlO0FBQ3BDLFVBQUluQyxPQUFPYixPQUFYLEVBQW9CO0FBQ2xCbUQsNEJBQW9CQSxrQkFBa0JPLE1BQWxCLENBQXlCN0MsT0FBT2IsT0FBaEMsQ0FBcEI7QUFDQSxZQUFJZSxZQUFZYyxNQUFaLEdBQXFCLENBQXpCLEVBQTRCO0FBQzFCYixvQkFBVUQsV0FBVjtBQUNEO0FBQ0RDLGtCQUFVSCxPQUFPYixPQUFqQixFQUEwQmEsTUFBMUI7QUFDQTtBQUNEO0FBQ0RzQyx3QkFBa0JsQyxJQUFsQixDQUF1QkosTUFBdkI7QUFDQUUsa0JBQVlFLElBQVosQ0FBaUJKLE1BQWpCO0FBQ0QsS0FYRDtBQVlBLFFBQUlGLG1CQUFtQkksWUFBWWMsTUFBWixHQUFxQixDQUE1QyxFQUErQztBQUM3Q2IsZ0JBQVVELFdBQVY7QUFDRDs7QUFFRDtBQUNBLFFBQUk0QyxlQUFlekQsS0FBS2tCLEdBQUwsQ0FBUyxVQUFDRyxDQUFELEVBQUl5QixDQUFKLEVBQVU7QUFDcEMsVUFBTVYsTUFBTTtBQUNWc0Isb0JBQVlyQyxDQURGO0FBRVZzQyxpQkFBU2I7QUFGQyxPQUFaO0FBSUFGLDBCQUFvQmxDLE9BQXBCLENBQTRCLGtCQUFVO0FBQ3BDLFlBQUlDLE9BQU9XLFFBQVgsRUFBcUI7QUFDckJjLFlBQUl6QixPQUFPc0IsRUFBWCxJQUFpQnRCLE9BQU9xQixRQUFQLENBQWdCWCxDQUFoQixDQUFqQjtBQUNELE9BSEQ7QUFJQSxhQUFPZSxHQUFQO0FBQ0QsS0FWa0IsQ0FBbkI7O0FBWUE7QUFDQSxRQUFNd0IsWUFBWSxTQUFaQSxTQUFZLENBQUNDLElBQUQsRUFBVTtBQUMxQixVQUFNQyxvQkFBb0IsRUFBMUI7QUFDQUMseUJBQW1CckQsT0FBbkIsQ0FBMkIsa0JBQVU7QUFDbkMsWUFBTXNELFNBQVNILEtBQUszQyxHQUFMLENBQVM7QUFBQSxpQkFBS0csRUFBRVYsT0FBT3NCLEVBQVQsQ0FBTDtBQUFBLFNBQVQsQ0FBZjtBQUNBNkIsMEJBQWtCbkQsT0FBT3NCLEVBQXpCLElBQStCdEIsT0FBT2lELFNBQVAsQ0FBaUJJLE1BQWpCLEVBQXlCSCxJQUF6QixDQUEvQjtBQUNELE9BSEQ7QUFJQSxhQUFPQyxpQkFBUDtBQUNELEtBUEQ7QUFRQSxRQUFJRyxrQkFBa0JsRSxRQUFRNEIsTUFBUixHQUFpQnNCLGtCQUFrQkQsS0FBbEIsQ0FBd0IsQ0FBeEIsQ0FBakIsR0FBOENDLGlCQUFwRTtBQUNBLFFBQU1jLHFCQUFxQkUsZ0JBQWdCN0MsTUFBaEIsQ0FBdUI7QUFBQSxhQUFLQyxFQUFFdUMsU0FBUDtBQUFBLEtBQXZCLENBQTNCO0FBQ0EsUUFBSUwsb0JBQUo7QUFDQSxRQUFJeEQsUUFBUTRCLE1BQVosRUFBb0I7QUFBQTtBQUNsQjRCLHNCQUFjTixrQkFBa0IsQ0FBbEIsQ0FBZDtBQUNBLFlBQU1pQixtQkFBbUIsU0FBbkJBLGdCQUFtQixDQUFDTCxJQUFELEVBQU9NLElBQVAsRUFBdUI7QUFBQSxjQUFWckIsQ0FBVSx1RUFBTixDQUFNOztBQUM5QztBQUNBLGNBQUlBLE1BQU1xQixLQUFLeEMsTUFBZixFQUF1QjtBQUNyQixtQkFBT2tDLElBQVA7QUFDRDtBQUNEO0FBQ0EsY0FBSU8sY0FBY0MsT0FBT0MsT0FBUCxDQUNoQixnQkFBRUMsT0FBRixDQUFVVixJQUFWLEVBQWdCTSxLQUFLckIsQ0FBTCxDQUFoQixDQURnQixFQUViNUIsR0FGYSxDQUVULGdCQUFrQjtBQUFBOztBQUFBO0FBQUEsZ0JBQWhCc0QsR0FBZ0I7QUFBQSxnQkFBWEMsS0FBVzs7QUFDckIsc0RBQ0d4RSxVQURILEVBQ2dCa0UsS0FBS3JCLENBQUwsQ0FEaEIsMEJBRUc1QyxXQUZILEVBRWlCc0UsR0FGakIsMEJBR0dMLEtBQUtyQixDQUFMLENBSEgsRUFHYTBCLEdBSGIsMEJBSUdyRSxVQUpILEVBSWdCc0UsS0FKaEI7QUFNRCxXQVRhLENBQWxCO0FBV0E7QUFDQUwsd0JBQWNBLFlBQVlsRCxHQUFaLENBQWdCLG9CQUFZO0FBQ3hDLGdCQUFJd0QsVUFBVVIsaUJBQWlCUyxTQUFTeEUsVUFBVCxDQUFqQixFQUF1Q2dFLElBQXZDLEVBQTZDckIsSUFBSSxDQUFqRCxDQUFkO0FBQ0EsZ0NBQ0s2QixRQURMLHNCQUVHeEUsVUFGSCxFQUVnQnVFLE9BRmhCLEdBR0tkLFVBQVVjLE9BQVYsQ0FITDtBQUtELFdBUGEsQ0FBZDtBQVFBLGlCQUFPTixXQUFQO0FBQ0QsU0EzQkQ7QUE0QkFYLHVCQUFlUyxpQkFBaUJULFlBQWpCLEVBQStCMUQsT0FBL0IsQ0FBZjtBQTlCa0I7QUErQm5COztBQUVELFFBQU02RSxXQUFXLGdCQUFFeEIsZUFBRixDQUFrQjdDLEtBQWxCLEVBQXlCc0UsS0FBS0MsSUFBTCxDQUFVckIsYUFBYTlCLE1BQWIsR0FBc0JuQixRQUFoQyxDQUF6QixDQUFqQjtBQUNBLFFBQU11RSxVQUFVekUsT0FBT3NFLFFBQVAsR0FBa0JHLFVBQVUsQ0FBNUIsR0FBZ0N6RSxJQUFoRDs7QUFFQSxXQUFPO0FBQ0xtRCxnQ0FESztBQUVMRiw4QkFGSztBQUdMTiwwQ0FISztBQUlMckMsZ0NBSks7QUFLTGdDLDhDQUxLO0FBTUxuQyxzQ0FOSztBQU9MSCxZQUFNdUUsS0FBS0csR0FBTCxDQUFTRCxPQUFULEVBQWtCLENBQWxCO0FBUEQsS0FBUDtBQVNELEdBbk9ZO0FBb09iRSxlQXBPYSx5QkFvT0VDLGFBcE9GLEVBb09pQjtBQUFBLFFBRTFCQyxNQUYwQixHQUt4QkQsYUFMd0IsQ0FFMUJDLE1BRjBCO0FBQUEsUUFHMUJDLE9BSDBCLEdBS3hCRixhQUx3QixDQUcxQkUsT0FIMEI7QUFBQSxRQUkxQjNCLFlBSjBCLEdBS3hCeUIsYUFMd0IsQ0FJMUJ6QixZQUowQjs7QUFPNUI7O0FBQ0EsV0FBTztBQUNMNEIsa0JBQVlGLFNBQVMxQixZQUFULEdBQXdCLEtBQUs2QixRQUFMLENBQWM3QixZQUFkLEVBQTRCMkIsT0FBNUI7QUFEL0IsS0FBUDtBQUdELEdBL09ZO0FBaVBiRyxjQWpQYSwwQkFpUEc7QUFDZCxTQUFLdkUsS0FBTCxDQUFXd0UsUUFBWCxDQUFvQixLQUFLM0YsZ0JBQUwsRUFBcEIsRUFBNkMsSUFBN0M7QUFDRCxHQW5QWTtBQW9QYjRGLGdCQXBQYSwwQkFvUEdqQixHQXBQSCxFQW9QUTtBQUNuQixXQUFPLGdCQUFFcEIsZUFBRixDQUFrQixLQUFLcEMsS0FBTCxDQUFXd0QsR0FBWCxDQUFsQixFQUFtQyxLQUFLa0IsS0FBTCxDQUFXbEIsR0FBWCxDQUFuQyxDQUFQO0FBQ0QsR0F0UFk7QUF1UGJtQixnQkF2UGEsMEJBdVBHbkIsR0F2UEgsRUF1UFE7QUFDbkIsV0FBTyxnQkFBRXBCLGVBQUYsQ0FBa0IsS0FBS3NDLEtBQUwsQ0FBV2xCLEdBQVgsQ0FBbEIsRUFBbUMsS0FBS3hELEtBQUwsQ0FBV3dELEdBQVgsQ0FBbkMsQ0FBUDtBQUNELEdBelBZO0FBMFBiYyxVQTFQYSxvQkEwUEh0RixJQTFQRyxFQTBQR29GLE9BMVBILEVBMFBZO0FBQUE7O0FBQ3ZCLFFBQUksQ0FBQ0EsUUFBUXpELE1BQWIsRUFBcUI7QUFDbkIsYUFBTzNCLElBQVA7QUFDRDtBQUNELFFBQU00RixTQUFTLGdCQUFFQyxPQUFGLENBQVU3RixJQUFWLEVBQWdCb0YsUUFBUWxFLEdBQVIsQ0FBWSxnQkFBUTtBQUNqRCxhQUFPLGVBQU87QUFDWixZQUFJa0IsSUFBSTBELEtBQUs3RCxFQUFULE1BQWlCLElBQWpCLElBQXlCRyxJQUFJMEQsS0FBSzdELEVBQVQsTUFBaUJWLFNBQTlDLEVBQXlEO0FBQ3ZELGlCQUFPLENBQUN3RSxRQUFSO0FBQ0Q7QUFDRCxlQUFPLE9BQU8zRCxJQUFJMEQsS0FBSzdELEVBQVQsQ0FBUCxLQUF3QixRQUF4QixHQUFtQ0csSUFBSTBELEtBQUs3RCxFQUFULEVBQWErRCxXQUFiLEVBQW5DLEdBQWdFNUQsSUFBSTBELEtBQUs3RCxFQUFULENBQXZFO0FBQ0QsT0FMRDtBQU1ELEtBUDhCLENBQWhCLEVBT1htRCxRQUFRbEUsR0FBUixDQUFZO0FBQUEsYUFBSyxDQUFDRyxFQUFFNEUsSUFBUjtBQUFBLEtBQVosQ0FQVyxDQUFmOztBQVNBLFdBQU9MLE9BQU8xRSxHQUFQLENBQVcsZUFBTztBQUN2QixVQUFJLENBQUNrQixJQUFJLE9BQUtwQixLQUFMLENBQVdiLFVBQWYsQ0FBTCxFQUFpQztBQUMvQixlQUFPaUMsR0FBUDtBQUNEO0FBQ0QsMEJBQ0tBLEdBREwsc0JBRUcsT0FBS3BCLEtBQUwsQ0FBV2IsVUFGZCxFQUUyQixPQUFLbUYsUUFBTCxDQUFjbEQsSUFBSSxPQUFLcEIsS0FBTCxDQUFXYixVQUFmLENBQWQsRUFBMENpRixPQUExQyxDQUYzQjtBQUlELEtBUk0sQ0FBUDtBQVNELEdBaFJZO0FBa1JiYyxZQWxSYSx3QkFrUkM7QUFDWixXQUFPLGdCQUFFOUMsZUFBRixDQUFrQixLQUFLcEMsS0FBTCxDQUFXbUYsT0FBN0IsRUFBc0MsS0FBS1IsY0FBTCxDQUFvQixVQUFwQixDQUF0QyxDQUFQO0FBQ0QsR0FwUlk7OztBQXNSYjtBQUNBUyxjQXZSYSx3QkF1UkM5RixJQXZSRCxFQXVSTztBQUFBOztBQUFBLFFBQ1Y4RixZQURVLEdBQ08sS0FBS3BGLEtBRFosQ0FDVm9GLFlBRFU7O0FBRWxCLFFBQUlBLFlBQUosRUFBa0I7QUFDaEIsYUFBT0EsYUFBYTlGLElBQWIsQ0FBUDtBQUNEO0FBQ0QsU0FBSytGLGdCQUFMLENBQXNCO0FBQ3BCQyxvQkFBYyxFQURNO0FBRXBCaEc7QUFGb0IsS0FBdEIsRUFHRyxZQUFNO0FBQ1AsYUFBS2lGLFlBQUw7QUFDRCxLQUxEO0FBTUQsR0FsU1k7QUFtU2JnQixrQkFuU2EsNEJBbVNLQyxXQW5TTCxFQW1Ta0I7QUFBQTs7QUFBQSxRQUNyQkQsZ0JBRHFCLEdBQ0EsS0FBS3ZGLEtBREwsQ0FDckJ1RixnQkFEcUI7O0FBQUEsNkJBRUYsS0FBSzFHLGdCQUFMLEVBRkU7QUFBQSxRQUVyQlcsUUFGcUIsc0JBRXJCQSxRQUZxQjtBQUFBLFFBRVhGLElBRlcsc0JBRVhBLElBRlc7O0FBSTdCOzs7QUFDQSxRQUFNbUcsYUFBYWpHLFdBQVdGLElBQTlCO0FBQ0EsUUFBTXlFLFVBQVVGLEtBQUs2QixLQUFMLENBQVdELGFBQWFELFdBQXhCLENBQWhCOztBQUVBLFFBQUlELGdCQUFKLEVBQXNCO0FBQ3BCLGFBQU9BLGlCQUFpQkMsV0FBakIsRUFBOEJ6QixPQUE5QixDQUFQO0FBQ0Q7O0FBRUQsU0FBS3NCLGdCQUFMLENBQXNCO0FBQ3BCN0YsZ0JBQVVnRyxXQURVO0FBRXBCbEcsWUFBTXlFO0FBRmMsS0FBdEIsRUFHRyxZQUFNO0FBQ1AsYUFBS1EsWUFBTDtBQUNELEtBTEQ7QUFNRCxHQXJUWTtBQXNUYm9CLFlBdFRhLHNCQXNURGhHLE1BdFRDLEVBc1RPaUcsUUF0VFAsRUFzVGlCO0FBQUE7O0FBQUEsNkJBQ1IsS0FBSy9HLGdCQUFMLEVBRFE7QUFBQSxRQUNwQnVGLE9BRG9CLHNCQUNwQkEsT0FEb0I7O0FBQUEsUUFFcEJ5QixlQUZvQixHQUVBLEtBQUs3RixLQUZMLENBRXBCNkYsZUFGb0I7O0FBRzVCLFFBQUlBLGVBQUosRUFBcUI7QUFDbkIsYUFBT0EsZ0JBQWdCbEcsTUFBaEIsRUFBd0JpRyxRQUF4QixDQUFQO0FBQ0Q7QUFDRCxRQUFJRSxhQUFhLGdCQUFFQyxLQUFGLENBQVEzQixXQUFXLEVBQW5CLEVBQXVCbEUsR0FBdkIsQ0FBMkIsYUFBSztBQUMvQ0csUUFBRTRFLElBQUYsR0FBUyxnQkFBRWUsYUFBRixDQUFnQjNGLENBQWhCLENBQVQ7QUFDQSxhQUFPQSxDQUFQO0FBQ0QsS0FIZ0IsQ0FBakI7QUFJQSxRQUFJLENBQUMsZ0JBQUU0RixPQUFGLENBQVV0RyxNQUFWLENBQUwsRUFBd0I7QUFDdEI7QUFDQSxVQUFNdUcsZ0JBQWdCSixXQUFXckYsU0FBWCxDQUFxQjtBQUFBLGVBQUtKLEVBQUVZLEVBQUYsS0FBU3RCLE9BQU9zQixFQUFyQjtBQUFBLE9BQXJCLENBQXRCO0FBQ0EsVUFBSWlGLGdCQUFnQixDQUFDLENBQXJCLEVBQXdCO0FBQ3RCLFlBQU1DLFdBQVdMLFdBQVdJLGFBQVgsQ0FBakI7QUFDQSxZQUFJQyxTQUFTbEIsSUFBYixFQUFtQjtBQUNqQixjQUFJVyxRQUFKLEVBQWM7QUFDWkUsdUJBQVdNLE1BQVgsQ0FBa0JGLGFBQWxCLEVBQWlDLENBQWpDO0FBQ0QsV0FGRCxNQUVPO0FBQ0xDLHFCQUFTbEIsSUFBVCxHQUFnQixLQUFoQjtBQUNBYSx5QkFBYSxDQUFDSyxRQUFELENBQWI7QUFDRDtBQUNGLFNBUEQsTUFPTztBQUNMQSxtQkFBU2xCLElBQVQsR0FBZ0IsSUFBaEI7QUFDQSxjQUFJLENBQUNXLFFBQUwsRUFBZTtBQUNiRSx5QkFBYSxDQUFDSyxRQUFELENBQWI7QUFDRDtBQUNGO0FBQ0YsT0FmRCxNQWVPO0FBQ0wsWUFBSVAsUUFBSixFQUFjO0FBQ1pFLHFCQUFXL0YsSUFBWCxDQUFnQjtBQUNka0IsZ0JBQUl0QixPQUFPc0IsRUFERztBQUVkZ0Usa0JBQU07QUFGUSxXQUFoQjtBQUlELFNBTEQsTUFLTztBQUNMYSx1QkFBYSxDQUFDO0FBQ1o3RSxnQkFBSXRCLE9BQU9zQixFQURDO0FBRVpnRSxrQkFBTTtBQUZNLFdBQUQsQ0FBYjtBQUlEO0FBQ0Y7QUFDRixLQS9CRCxNQStCTztBQUFBO0FBQ0w7QUFDQSxZQUFNaUIsZ0JBQWdCSixXQUFXckYsU0FBWCxDQUFxQjtBQUFBLGlCQUFLSixFQUFFWSxFQUFGLEtBQVN0QixPQUFPLENBQVAsRUFBVXNCLEVBQXhCO0FBQUEsU0FBckIsQ0FBdEI7QUFDQTtBQUNBLFlBQUlpRixnQkFBZ0IsQ0FBQyxDQUFyQixFQUF3QjtBQUN0QixjQUFNQyxZQUFXTCxXQUFXSSxhQUFYLENBQWpCO0FBQ0EsY0FBSUMsVUFBU2xCLElBQWIsRUFBbUI7QUFDakIsZ0JBQUlXLFFBQUosRUFBYztBQUNaRSx5QkFBV00sTUFBWCxDQUFrQkYsYUFBbEIsRUFBaUN2RyxPQUFPZ0IsTUFBeEM7QUFDRCxhQUZELE1BRU87QUFDTGhCLHFCQUFPRCxPQUFQLENBQWUsVUFBQ1csQ0FBRCxFQUFJeUIsQ0FBSixFQUFVO0FBQ3ZCZ0UsMkJBQVdJLGdCQUFnQnBFLENBQTNCLEVBQThCbUQsSUFBOUIsR0FBcUMsS0FBckM7QUFDRCxlQUZEO0FBR0Q7QUFDRixXQVJELE1BUU87QUFDTHRGLG1CQUFPRCxPQUFQLENBQWUsVUFBQ1csQ0FBRCxFQUFJeUIsQ0FBSixFQUFVO0FBQ3ZCZ0UseUJBQVdJLGdCQUFnQnBFLENBQTNCLEVBQThCbUQsSUFBOUIsR0FBcUMsSUFBckM7QUFDRCxhQUZEO0FBR0Q7QUFDRCxjQUFJLENBQUNXLFFBQUwsRUFBZTtBQUNiRSx5QkFBYUEsV0FBVzlELEtBQVgsQ0FBaUJrRSxhQUFqQixFQUFnQ3ZHLE9BQU9nQixNQUF2QyxDQUFiO0FBQ0Q7QUFDRixTQWxCRCxNQWtCTztBQUNMO0FBQ0EsY0FBSWlGLFFBQUosRUFBYztBQUNaRSx5QkFBYUEsV0FBV3RELE1BQVgsQ0FBa0I3QyxPQUFPTyxHQUFQLENBQVc7QUFBQSxxQkFBTTtBQUM5Q2Usb0JBQUlaLEVBQUVZLEVBRHdDO0FBRTlDZ0Usc0JBQU07QUFGd0MsZUFBTjtBQUFBLGFBQVgsQ0FBbEIsQ0FBYjtBQUlELFdBTEQsTUFLTztBQUNMYSx5QkFBYW5HLE9BQU9PLEdBQVAsQ0FBVztBQUFBLHFCQUFNO0FBQzVCZSxvQkFBSVosRUFBRVksRUFEc0I7QUFFNUJnRSxzQkFBTTtBQUZzQixlQUFOO0FBQUEsYUFBWCxDQUFiO0FBSUQ7QUFDRjtBQW5DSTtBQW9DTjtBQUNELFNBQUtJLGdCQUFMLENBQXNCO0FBQ3BCL0YsWUFBUSxDQUFDOEUsUUFBUXpELE1BQVQsSUFBbUJtRixXQUFXbkYsTUFBL0IsSUFBMEMsQ0FBQ2lGLFFBQTVDLEdBQXdELENBQXhELEdBQTRELEtBQUtsQixLQUFMLENBQVdwRixJQUR6RDtBQUVwQjhFLGVBQVMwQjtBQUZXLEtBQXRCLEVBR0csWUFBTTtBQUNQLGFBQUt2QixZQUFMO0FBQ0QsS0FMRDtBQU1EO0FBMVlZLEMiLCJmaWxlIjoiY29tcG9uZW50TWV0aG9kcy5qcyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBfIGZyb20gJy4vdXRpbHMnXG5cbmV4cG9ydCBkZWZhdWx0IHtcbiAgZ2V0RGF0YU1vZGVsIChuZXh0UHJvcHMsIG5leHRTdGF0ZSkge1xuICAgIGNvbnN0IHtcbiAgICAgIGNvbHVtbnMsXG4gICAgICBwaXZvdEJ5ID0gW10sXG4gICAgICBkYXRhLFxuICAgICAgcGl2b3RJREtleSxcbiAgICAgIHBpdm90VmFsS2V5LFxuICAgICAgc3ViUm93c0tleSxcbiAgICAgIGV4cGFuZGVyQ29sdW1uV2lkdGgsXG4gICAgICBTdWJDb21wb25lbnQsXG4gICAgICBwYWdlLFxuICAgICAgcGFnZXMsXG4gICAgICBwYWdlU2l6ZVxuICAgIH0gPSB0aGlzLmdldFJlc29sdmVkU3RhdGUobmV4dFByb3BzLCBuZXh0U3RhdGUpXG5cbiAgICAvLyBEZXRlcm1pbmUgSGVhZGVyIEdyb3Vwc1xuICAgIGxldCBoYXNIZWFkZXJHcm91cHMgPSBmYWxzZVxuICAgIGNvbHVtbnMuZm9yRWFjaChjb2x1bW4gPT4ge1xuICAgICAgaWYgKGNvbHVtbi5jb2x1bW5zKSB7XG4gICAgICAgIGhhc0hlYWRlckdyb3VwcyA9IHRydWVcbiAgICAgIH1cbiAgICB9KVxuXG4gICAgLy8gQnVpbGQgSGVhZGVyIEdyb3Vwc1xuICAgIGNvbnN0IGhlYWRlckdyb3VwcyA9IFtdXG4gICAgbGV0IGN1cnJlbnRTcGFuID0gW11cblxuICAgIC8vIEEgY29udmVuaWVuY2UgZnVuY3Rpb24gdG8gYWRkIGEgaGVhZGVyIGFuZCByZXNldCB0aGUgY3VycmVudFNwYW5cbiAgICBjb25zdCBhZGRIZWFkZXIgPSAoY29sdW1ucywgY29sdW1uID0gY29sdW1uc1swXSkgPT4ge1xuICAgICAgaGVhZGVyR3JvdXBzLnB1c2goe1xuICAgICAgICAuLi50aGlzLnByb3BzLmNvbHVtbixcbiAgICAgICAgLi4uY29sdW1uLFxuICAgICAgICBjb2x1bW5zOiBjb2x1bW5zXG4gICAgICB9KVxuICAgICAgY3VycmVudFNwYW4gPSBbXVxuICAgIH1cblxuICAgIGNvbnN0IG5vU3ViRXhwYW5kZXJDb2x1bW5zID0gY29sdW1ucy5tYXAoY29sID0+IHtcbiAgICAgIHJldHVybiB7XG4gICAgICAgIC4uLmNvbCxcbiAgICAgICAgY29sdW1uczogY29sLmNvbHVtbnMgPyBjb2wuY29sdW1ucy5maWx0ZXIoZCA9PiAhZC5leHBhbmRlcikgOiB1bmRlZmluZWRcbiAgICAgIH1cbiAgICB9KVxuXG4gICAgbGV0IGV4cGFuZGVyQ29sdW1uSW5kZXggPSBjb2x1bW5zLmZpbmRJbmRleChjb2wgPT4gY29sLmV4cGFuZGVyKVxuICAgIGNvbnN0IG5lZWRzRXhwYW5kZXIgPSAoU3ViQ29tcG9uZW50IHx8IHBpdm90QnkubGVuZ3RoKSAmJiBleHBhbmRlckNvbHVtbkluZGV4ID09PSAtMVxuICAgIGNvbnN0IGNvbHVtbnNXaXRoRXhwYW5kZXIgPSBuZWVkc0V4cGFuZGVyID8gW3tleHBhbmRlcjogdHJ1ZX0sIC4uLm5vU3ViRXhwYW5kZXJDb2x1bW5zXSA6IG5vU3ViRXhwYW5kZXJDb2x1bW5zXG4gICAgaWYgKG5lZWRzRXhwYW5kZXIpIHtcbiAgICAgIGV4cGFuZGVyQ29sdW1uSW5kZXggPSAwXG4gICAgfVxuXG4gICAgY29uc3QgbWFrZURlY29yYXRlZENvbHVtbiA9IChjb2x1bW4pID0+IHtcbiAgICAgIGNvbnN0IGRjb2wgPSB7XG4gICAgICAgIC4uLnRoaXMucHJvcHMuY29sdW1uLFxuICAgICAgICAuLi5jb2x1bW5cbiAgICAgIH1cblxuICAgICAgaWYgKGRjb2wuZXhwYW5kZXIpIHtcbiAgICAgICAgZGNvbC53aWR0aCA9IGV4cGFuZGVyQ29sdW1uV2lkdGhcbiAgICAgICAgcmV0dXJuIGRjb2xcbiAgICAgIH1cblxuICAgICAgaWYgKHR5cGVvZiBkY29sLmFjY2Vzc29yID09PSAnc3RyaW5nJykge1xuICAgICAgICBkY29sLmlkID0gZGNvbC5pZCB8fCBkY29sLmFjY2Vzc29yXG4gICAgICAgIGNvbnN0IGFjY2Vzc29yU3RyaW5nID0gZGNvbC5hY2Nlc3NvclxuICAgICAgICBkY29sLmFjY2Vzc29yID0gcm93ID0+IF8uZ2V0KHJvdywgYWNjZXNzb3JTdHJpbmcpXG4gICAgICAgIHJldHVybiBkY29sXG4gICAgICB9XG5cbiAgICAgIGlmIChkY29sLmFjY2Vzc29yICYmICFkY29sLmlkKSB7XG4gICAgICAgIGNvbnNvbGUud2FybihkY29sKVxuICAgICAgICB0aHJvdyBuZXcgRXJyb3IoJ0EgY29sdW1uIGlkIGlzIHJlcXVpcmVkIGlmIHVzaW5nIGEgbm9uLXN0cmluZyBhY2Nlc3NvciBmb3IgY29sdW1uIGFib3ZlLicpXG4gICAgICB9XG5cbiAgICAgIGlmICghZGNvbC5hY2Nlc3Nvcikge1xuICAgICAgICBkY29sLmFjY2Vzc29yID0gZCA9PiB1bmRlZmluZWRcbiAgICAgIH1cblxuICAgICAgLy8gRW5zdXJlIG1pbldpZHRoIGlzIG5vdCBncmVhdGVyIHRoYW4gbWF4V2lkdGggaWYgc2V0XG4gICAgICBpZiAoZGNvbC5tYXhXaWR0aCA8IGRjb2wubWluV2lkdGgpIHtcbiAgICAgICAgZGNvbC5taW5XaWR0aCA9IGRjb2wubWF4V2lkdGhcbiAgICAgIH1cblxuICAgICAgcmV0dXJuIGRjb2xcbiAgICB9XG5cbiAgICAvLyBEZWNvcmF0ZSB0aGUgY29sdW1uc1xuICAgIGNvbnN0IGRlY29yYXRlQW5kQWRkVG9BbGwgPSAoY29sKSA9PiB7XG4gICAgICBjb25zdCBkZWNvcmF0ZWRDb2x1bW4gPSBtYWtlRGVjb3JhdGVkQ29sdW1uKGNvbClcbiAgICAgIGFsbERlY29yYXRlZENvbHVtbnMucHVzaChkZWNvcmF0ZWRDb2x1bW4pXG4gICAgICByZXR1cm4gZGVjb3JhdGVkQ29sdW1uXG4gICAgfVxuICAgIGxldCBhbGxEZWNvcmF0ZWRDb2x1bW5zID0gW11cbiAgICBjb25zdCBkZWNvcmF0ZWRDb2x1bW5zID0gY29sdW1uc1dpdGhFeHBhbmRlci5tYXAoKGNvbHVtbiwgaSkgPT4ge1xuICAgICAgaWYgKGNvbHVtbi5jb2x1bW5zKSB7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgLi4uY29sdW1uLFxuICAgICAgICAgIGNvbHVtbnM6IGNvbHVtbi5jb2x1bW5zLm1hcChkZWNvcmF0ZUFuZEFkZFRvQWxsKVxuICAgICAgICB9XG4gICAgICB9IGVsc2Uge1xuICAgICAgICByZXR1cm4gZGVjb3JhdGVBbmRBZGRUb0FsbChjb2x1bW4pXG4gICAgICB9XG4gICAgfSlcblxuICAgIC8vIEJ1aWxkIHRoZSB2aXNpYmxlIGNvbHVtbnMsIGhlYWRlcnMgYW5kIGZsYXQgY29sdW1uIGxpc3RcbiAgICBsZXQgdmlzaWJsZUNvbHVtbnMgPSBkZWNvcmF0ZWRDb2x1bW5zLnNsaWNlKClcbiAgICBsZXQgYWxsVmlzaWJsZUNvbHVtbnMgPSBbXVxuXG4gICAgdmlzaWJsZUNvbHVtbnMgPSB2aXNpYmxlQ29sdW1ucy5tYXAoKGNvbHVtbiwgaSkgPT4ge1xuICAgICAgaWYgKGNvbHVtbi5jb2x1bW5zKSB7XG4gICAgICAgIGNvbnN0IHZpc2libGVTdWJDb2x1bW5zID0gY29sdW1uLmNvbHVtbnMuZmlsdGVyKGQgPT4gcGl2b3RCeS5pbmRleE9mKGQuaWQpID4gLTEgPyBmYWxzZSA6IF8uZ2V0Rmlyc3REZWZpbmVkKGQuc2hvdywgdHJ1ZSkpXG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgLi4uY29sdW1uLFxuICAgICAgICAgIGNvbHVtbnM6IHZpc2libGVTdWJDb2x1bW5zXG4gICAgICAgIH1cbiAgICAgIH1cbiAgICAgIHJldHVybiBjb2x1bW5cbiAgICB9KVxuXG4gICAgdmlzaWJsZUNvbHVtbnMgPSB2aXNpYmxlQ29sdW1ucy5maWx0ZXIoY29sdW1uID0+IHtcbiAgICAgIHJldHVybiBjb2x1bW4uY29sdW1ucyA/IGNvbHVtbi5jb2x1bW5zLmxlbmd0aCA6IHBpdm90QnkuaW5kZXhPZihjb2x1bW4uaWQpID4gLTEgPyBmYWxzZSA6IF8uZ2V0Rmlyc3REZWZpbmVkKGNvbHVtbi5zaG93LCB0cnVlKVxuICAgIH0pXG5cbiAgICAvLyBNb3ZlIHRoZSBwaXZvdCBjb2x1bW5zIGludG8gYSBzaW5nbGUgY29sdW1uIGlmIG5lZWRlZFxuICAgIGlmIChwaXZvdEJ5Lmxlbmd0aCkge1xuICAgICAgY29uc3QgcGl2b3RDb2x1bW5zID0gW11cbiAgICAgIGZvciAodmFyIGkgPSAwOyBpIDwgYWxsRGVjb3JhdGVkQ29sdW1ucy5sZW5ndGg7IGkrKykge1xuICAgICAgICBpZiAocGl2b3RCeS5pbmRleE9mKGFsbERlY29yYXRlZENvbHVtbnNbaV0uaWQpID4gLTEpIHtcbiAgICAgICAgICBwaXZvdENvbHVtbnMucHVzaChhbGxEZWNvcmF0ZWRDb2x1bW5zW2ldKVxuICAgICAgICB9XG4gICAgICB9XG4gICAgICBjb25zdCBwaXZvdENvbHVtbiA9IHtcbiAgICAgICAgLi4ucGl2b3RDb2x1bW5zWzBdLFxuICAgICAgICBwaXZvdENvbHVtbnMsXG4gICAgICAgIGV4cGFuZGVyOiB0cnVlXG4gICAgICB9XG4gICAgICB2aXNpYmxlQ29sdW1uc1tleHBhbmRlckNvbHVtbkluZGV4XSA9IHBpdm90Q29sdW1uXG4gICAgfVxuXG4gICAgLy8gQnVpbGQgZmxhc3QgbGlzdCBvZiBhbGxWaXNpYmxlQ29sdW1ucyBhbmQgSGVhZGVyR3JvdXBzXG4gICAgdmlzaWJsZUNvbHVtbnMuZm9yRWFjaCgoY29sdW1uLCBpKSA9PiB7XG4gICAgICBpZiAoY29sdW1uLmNvbHVtbnMpIHtcbiAgICAgICAgYWxsVmlzaWJsZUNvbHVtbnMgPSBhbGxWaXNpYmxlQ29sdW1ucy5jb25jYXQoY29sdW1uLmNvbHVtbnMpXG4gICAgICAgIGlmIChjdXJyZW50U3Bhbi5sZW5ndGggPiAwKSB7XG4gICAgICAgICAgYWRkSGVhZGVyKGN1cnJlbnRTcGFuKVxuICAgICAgICB9XG4gICAgICAgIGFkZEhlYWRlcihjb2x1bW4uY29sdW1ucywgY29sdW1uKVxuICAgICAgICByZXR1cm5cbiAgICAgIH1cbiAgICAgIGFsbFZpc2libGVDb2x1bW5zLnB1c2goY29sdW1uKVxuICAgICAgY3VycmVudFNwYW4ucHVzaChjb2x1bW4pXG4gICAgfSlcbiAgICBpZiAoaGFzSGVhZGVyR3JvdXBzICYmIGN1cnJlbnRTcGFuLmxlbmd0aCA+IDApIHtcbiAgICAgIGFkZEhlYWRlcihjdXJyZW50U3BhbilcbiAgICB9XG5cbiAgICAvLyBBY2Nlc3MgdGhlIGRhdGFcbiAgICBsZXQgcmVzb2x2ZWREYXRhID0gZGF0YS5tYXAoKGQsIGkpID0+IHtcbiAgICAgIGNvbnN0IHJvdyA9IHtcbiAgICAgICAgX19vcmlnaW5hbDogZCxcbiAgICAgICAgX19pbmRleDogaVxuICAgICAgfVxuICAgICAgYWxsRGVjb3JhdGVkQ29sdW1ucy5mb3JFYWNoKGNvbHVtbiA9PiB7XG4gICAgICAgIGlmIChjb2x1bW4uZXhwYW5kZXIpIHJldHVyblxuICAgICAgICByb3dbY29sdW1uLmlkXSA9IGNvbHVtbi5hY2Nlc3NvcihkKVxuICAgICAgfSlcbiAgICAgIHJldHVybiByb3dcbiAgICB9KVxuXG4gICAgLy8gSWYgcGl2b3RpbmcsIHJlY3Vyc2l2ZWx5IGdyb3VwIHRoZSBkYXRhXG4gICAgY29uc3QgYWdncmVnYXRlID0gKHJvd3MpID0+IHtcbiAgICAgIGNvbnN0IGFnZ3JlZ2F0aW9uVmFsdWVzID0ge31cbiAgICAgIGFnZ3JlZ2F0aW5nQ29sdW1ucy5mb3JFYWNoKGNvbHVtbiA9PiB7XG4gICAgICAgIGNvbnN0IHZhbHVlcyA9IHJvd3MubWFwKGQgPT4gZFtjb2x1bW4uaWRdKVxuICAgICAgICBhZ2dyZWdhdGlvblZhbHVlc1tjb2x1bW4uaWRdID0gY29sdW1uLmFnZ3JlZ2F0ZSh2YWx1ZXMsIHJvd3MpXG4gICAgICB9KVxuICAgICAgcmV0dXJuIGFnZ3JlZ2F0aW9uVmFsdWVzXG4gICAgfVxuICAgIGxldCBzdGFuZGFyZENvbHVtbnMgPSBwaXZvdEJ5Lmxlbmd0aCA/IGFsbFZpc2libGVDb2x1bW5zLnNsaWNlKDEpIDogYWxsVmlzaWJsZUNvbHVtbnNcbiAgICBjb25zdCBhZ2dyZWdhdGluZ0NvbHVtbnMgPSBzdGFuZGFyZENvbHVtbnMuZmlsdGVyKGQgPT4gZC5hZ2dyZWdhdGUpXG4gICAgbGV0IHBpdm90Q29sdW1uXG4gICAgaWYgKHBpdm90QnkubGVuZ3RoKSB7XG4gICAgICBwaXZvdENvbHVtbiA9IGFsbFZpc2libGVDb2x1bW5zWzBdXG4gICAgICBjb25zdCBncm91cFJlY3Vyc2l2ZWx5ID0gKHJvd3MsIGtleXMsIGkgPSAwKSA9PiB7XG4gICAgICAgIC8vIFRoaXMgaXMgdGhlIGxhc3QgbGV2ZWwsIGp1c3QgcmV0dXJuIHRoZSByb3dzXG4gICAgICAgIGlmIChpID09PSBrZXlzLmxlbmd0aCkge1xuICAgICAgICAgIHJldHVybiByb3dzXG4gICAgICAgIH1cbiAgICAgICAgLy8gR3JvdXAgdGhlIHJvd3MgdG9nZXRoZXIgZm9yIHRoaXMgbGV2ZWxcbiAgICAgICAgbGV0IGdyb3VwZWRSb3dzID0gT2JqZWN0LmVudHJpZXMoXG4gICAgICAgICAgXy5ncm91cEJ5KHJvd3MsIGtleXNbaV0pKVxuICAgICAgICAgICAgLm1hcCgoW2tleSwgdmFsdWVdKSA9PiB7XG4gICAgICAgICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICAgICAgW3Bpdm90SURLZXldOiBrZXlzW2ldLFxuICAgICAgICAgICAgICAgIFtwaXZvdFZhbEtleV06IGtleSxcbiAgICAgICAgICAgICAgICBba2V5c1tpXV06IGtleSxcbiAgICAgICAgICAgICAgICBbc3ViUm93c0tleV06IHZhbHVlXG4gICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH1cbiAgICAgICAgKVxuICAgICAgICAvLyBSZWN1cnNlIGludG8gdGhlIHN1YlJvd3NcbiAgICAgICAgZ3JvdXBlZFJvd3MgPSBncm91cGVkUm93cy5tYXAocm93R3JvdXAgPT4ge1xuICAgICAgICAgIGxldCBzdWJSb3dzID0gZ3JvdXBSZWN1cnNpdmVseShyb3dHcm91cFtzdWJSb3dzS2V5XSwga2V5cywgaSArIDEpXG4gICAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIC4uLnJvd0dyb3VwLFxuICAgICAgICAgICAgW3N1YlJvd3NLZXldOiBzdWJSb3dzLFxuICAgICAgICAgICAgLi4uYWdncmVnYXRlKHN1YlJvd3MpXG4gICAgICAgICAgfVxuICAgICAgICB9KVxuICAgICAgICByZXR1cm4gZ3JvdXBlZFJvd3NcbiAgICAgIH1cbiAgICAgIHJlc29sdmVkRGF0YSA9IGdyb3VwUmVjdXJzaXZlbHkocmVzb2x2ZWREYXRhLCBwaXZvdEJ5KVxuICAgIH1cblxuICAgIGNvbnN0IG5ld1BhZ2VzID0gXy5nZXRGaXJzdERlZmluZWQocGFnZXMsIE1hdGguY2VpbChyZXNvbHZlZERhdGEubGVuZ3RoIC8gcGFnZVNpemUpKVxuICAgIGNvbnN0IG5ld1BhZ2UgPSBwYWdlID4gbmV3UGFnZXMgPyBuZXdQYWdlIC0gMSA6IHBhZ2VcblxuICAgIHJldHVybiB7XG4gICAgICByZXNvbHZlZERhdGEsXG4gICAgICBwaXZvdENvbHVtbixcbiAgICAgIGFsbFZpc2libGVDb2x1bW5zLFxuICAgICAgaGVhZGVyR3JvdXBzLFxuICAgICAgYWxsRGVjb3JhdGVkQ29sdW1ucyxcbiAgICAgIGhhc0hlYWRlckdyb3VwcyxcbiAgICAgIHBhZ2U6IE1hdGgubWF4KG5ld1BhZ2UsIDApXG4gICAgfVxuICB9LFxuICBnZXRTb3J0ZWREYXRhIChyZXNvbHZlZFN0YXRlKSB7XG4gICAgY29uc3Qge1xuICAgICAgbWFudWFsLFxuICAgICAgc29ydGluZyxcbiAgICAgIHJlc29sdmVkRGF0YVxuICAgIH0gPSByZXNvbHZlZFN0YXRlXG5cbiAgICAvLyBSZXNvbHZlIHRoZSBkYXRhIGZyb20gZWl0aGVyIG1hbnVhbCBkYXRhIG9yIHNvcnRlZCBkYXRhXG4gICAgcmV0dXJuIHtcbiAgICAgIHNvcnRlZERhdGE6IG1hbnVhbCA/IHJlc29sdmVkRGF0YSA6IHRoaXMuc29ydERhdGEocmVzb2x2ZWREYXRhLCBzb3J0aW5nKVxuICAgIH1cbiAgfSxcblxuICBmaXJlT25DaGFuZ2UgKCkge1xuICAgIHRoaXMucHJvcHMub25DaGFuZ2UodGhpcy5nZXRSZXNvbHZlZFN0YXRlKCksIHRoaXMpXG4gIH0sXG4gIGdldFByb3BPclN0YXRlIChrZXkpIHtcbiAgICByZXR1cm4gXy5nZXRGaXJzdERlZmluZWQodGhpcy5wcm9wc1trZXldLCB0aGlzLnN0YXRlW2tleV0pXG4gIH0sXG4gIGdldFN0YXRlT3JQcm9wIChrZXkpIHtcbiAgICByZXR1cm4gXy5nZXRGaXJzdERlZmluZWQodGhpcy5zdGF0ZVtrZXldLCB0aGlzLnByb3BzW2tleV0pXG4gIH0sXG4gIHNvcnREYXRhIChkYXRhLCBzb3J0aW5nKSB7XG4gICAgaWYgKCFzb3J0aW5nLmxlbmd0aCkge1xuICAgICAgcmV0dXJuIGRhdGFcbiAgICB9XG4gICAgY29uc3Qgc29ydGVkID0gXy5vcmRlckJ5KGRhdGEsIHNvcnRpbmcubWFwKHNvcnQgPT4ge1xuICAgICAgcmV0dXJuIHJvdyA9PiB7XG4gICAgICAgIGlmIChyb3dbc29ydC5pZF0gPT09IG51bGwgfHwgcm93W3NvcnQuaWRdID09PSB1bmRlZmluZWQpIHtcbiAgICAgICAgICByZXR1cm4gLUluZmluaXR5XG4gICAgICAgIH1cbiAgICAgICAgcmV0dXJuIHR5cGVvZiByb3dbc29ydC5pZF0gPT09ICdzdHJpbmcnID8gcm93W3NvcnQuaWRdLnRvTG93ZXJDYXNlKCkgOiByb3dbc29ydC5pZF1cbiAgICAgIH1cbiAgICB9KSwgc29ydGluZy5tYXAoZCA9PiAhZC5kZXNjKSlcblxuICAgIHJldHVybiBzb3J0ZWQubWFwKHJvdyA9PiB7XG4gICAgICBpZiAoIXJvd1t0aGlzLnByb3BzLnN1YlJvd3NLZXldKSB7XG4gICAgICAgIHJldHVybiByb3dcbiAgICAgIH1cbiAgICAgIHJldHVybiB7XG4gICAgICAgIC4uLnJvdyxcbiAgICAgICAgW3RoaXMucHJvcHMuc3ViUm93c0tleV06IHRoaXMuc29ydERhdGEocm93W3RoaXMucHJvcHMuc3ViUm93c0tleV0sIHNvcnRpbmcpXG4gICAgICB9XG4gICAgfSlcbiAgfSxcblxuICBnZXRNaW5Sb3dzICgpIHtcbiAgICByZXR1cm4gXy5nZXRGaXJzdERlZmluZWQodGhpcy5wcm9wcy5taW5Sb3dzLCB0aGlzLmdldFN0YXRlT3JQcm9wKCdwYWdlU2l6ZScpKVxuICB9LFxuXG4gIC8vIFVzZXIgYWN0aW9uc1xuICBvblBhZ2VDaGFuZ2UgKHBhZ2UpIHtcbiAgICBjb25zdCB7IG9uUGFnZUNoYW5nZSB9ID0gdGhpcy5wcm9wc1xuICAgIGlmIChvblBhZ2VDaGFuZ2UpIHtcbiAgICAgIHJldHVybiBvblBhZ2VDaGFuZ2UocGFnZSlcbiAgICB9XG4gICAgdGhpcy5zZXRTdGF0ZVdpdGhEYXRhKHtcbiAgICAgIGV4cGFuZGVkUm93czoge30sXG4gICAgICBwYWdlXG4gICAgfSwgKCkgPT4ge1xuICAgICAgdGhpcy5maXJlT25DaGFuZ2UoKVxuICAgIH0pXG4gIH0sXG4gIG9uUGFnZVNpemVDaGFuZ2UgKG5ld1BhZ2VTaXplKSB7XG4gICAgY29uc3QgeyBvblBhZ2VTaXplQ2hhbmdlIH0gPSB0aGlzLnByb3BzXG4gICAgY29uc3QgeyBwYWdlU2l6ZSwgcGFnZSB9ID0gdGhpcy5nZXRSZXNvbHZlZFN0YXRlKClcblxuICAgIC8vIE5vcm1hbGl6ZSB0aGUgcGFnZSB0byBkaXNwbGF5XG4gICAgY29uc3QgY3VycmVudFJvdyA9IHBhZ2VTaXplICogcGFnZVxuICAgIGNvbnN0IG5ld1BhZ2UgPSBNYXRoLmZsb29yKGN1cnJlbnRSb3cgLyBuZXdQYWdlU2l6ZSlcblxuICAgIGlmIChvblBhZ2VTaXplQ2hhbmdlKSB7XG4gICAgICByZXR1cm4gb25QYWdlU2l6ZUNoYW5nZShuZXdQYWdlU2l6ZSwgbmV3UGFnZSlcbiAgICB9XG5cbiAgICB0aGlzLnNldFN0YXRlV2l0aERhdGEoe1xuICAgICAgcGFnZVNpemU6IG5ld1BhZ2VTaXplLFxuICAgICAgcGFnZTogbmV3UGFnZVxuICAgIH0sICgpID0+IHtcbiAgICAgIHRoaXMuZmlyZU9uQ2hhbmdlKClcbiAgICB9KVxuICB9LFxuICBzb3J0Q29sdW1uIChjb2x1bW4sIGFkZGl0aXZlKSB7XG4gICAgY29uc3QgeyBzb3J0aW5nIH0gPSB0aGlzLmdldFJlc29sdmVkU3RhdGUoKVxuICAgIGNvbnN0IHsgb25Tb3J0aW5nQ2hhbmdlIH0gPSB0aGlzLnByb3BzXG4gICAgaWYgKG9uU29ydGluZ0NoYW5nZSkge1xuICAgICAgcmV0dXJuIG9uU29ydGluZ0NoYW5nZShjb2x1bW4sIGFkZGl0aXZlKVxuICAgIH1cbiAgICBsZXQgbmV3U29ydGluZyA9IF8uY2xvbmUoc29ydGluZyB8fCBbXSkubWFwKGQgPT4ge1xuICAgICAgZC5kZXNjID0gXy5pc1NvcnRpbmdEZXNjKGQpXG4gICAgICByZXR1cm4gZFxuICAgIH0pXG4gICAgaWYgKCFfLmlzQXJyYXkoY29sdW1uKSkge1xuICAgICAgLy8gU2luZ2xlLVNvcnRcbiAgICAgIGNvbnN0IGV4aXN0aW5nSW5kZXggPSBuZXdTb3J0aW5nLmZpbmRJbmRleChkID0+IGQuaWQgPT09IGNvbHVtbi5pZClcbiAgICAgIGlmIChleGlzdGluZ0luZGV4ID4gLTEpIHtcbiAgICAgICAgY29uc3QgZXhpc3RpbmcgPSBuZXdTb3J0aW5nW2V4aXN0aW5nSW5kZXhdXG4gICAgICAgIGlmIChleGlzdGluZy5kZXNjKSB7XG4gICAgICAgICAgaWYgKGFkZGl0aXZlKSB7XG4gICAgICAgICAgICBuZXdTb3J0aW5nLnNwbGljZShleGlzdGluZ0luZGV4LCAxKVxuICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICBleGlzdGluZy5kZXNjID0gZmFsc2VcbiAgICAgICAgICAgIG5ld1NvcnRpbmcgPSBbZXhpc3RpbmddXG4gICAgICAgICAgfVxuICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgIGV4aXN0aW5nLmRlc2MgPSB0cnVlXG4gICAgICAgICAgaWYgKCFhZGRpdGl2ZSkge1xuICAgICAgICAgICAgbmV3U29ydGluZyA9IFtleGlzdGluZ11cbiAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgIH0gZWxzZSB7XG4gICAgICAgIGlmIChhZGRpdGl2ZSkge1xuICAgICAgICAgIG5ld1NvcnRpbmcucHVzaCh7XG4gICAgICAgICAgICBpZDogY29sdW1uLmlkLFxuICAgICAgICAgICAgZGVzYzogZmFsc2VcbiAgICAgICAgICB9KVxuICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgIG5ld1NvcnRpbmcgPSBbe1xuICAgICAgICAgICAgaWQ6IGNvbHVtbi5pZCxcbiAgICAgICAgICAgIGRlc2M6IGZhbHNlXG4gICAgICAgICAgfV1cbiAgICAgICAgfVxuICAgICAgfVxuICAgIH0gZWxzZSB7XG4gICAgICAvLyBNdWx0aS1Tb3J0XG4gICAgICBjb25zdCBleGlzdGluZ0luZGV4ID0gbmV3U29ydGluZy5maW5kSW5kZXgoZCA9PiBkLmlkID09PSBjb2x1bW5bMF0uaWQpXG4gICAgICAvLyBFeGlzdGluZyBTb3J0ZWQgQ29sdW1uXG4gICAgICBpZiAoZXhpc3RpbmdJbmRleCA+IC0xKSB7XG4gICAgICAgIGNvbnN0IGV4aXN0aW5nID0gbmV3U29ydGluZ1tleGlzdGluZ0luZGV4XVxuICAgICAgICBpZiAoZXhpc3RpbmcuZGVzYykge1xuICAgICAgICAgIGlmIChhZGRpdGl2ZSkge1xuICAgICAgICAgICAgbmV3U29ydGluZy5zcGxpY2UoZXhpc3RpbmdJbmRleCwgY29sdW1uLmxlbmd0aClcbiAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgY29sdW1uLmZvckVhY2goKGQsIGkpID0+IHtcbiAgICAgICAgICAgICAgbmV3U29ydGluZ1tleGlzdGluZ0luZGV4ICsgaV0uZGVzYyA9IGZhbHNlXG4gICAgICAgICAgICB9KVxuICAgICAgICAgIH1cbiAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICBjb2x1bW4uZm9yRWFjaCgoZCwgaSkgPT4ge1xuICAgICAgICAgICAgbmV3U29ydGluZ1tleGlzdGluZ0luZGV4ICsgaV0uZGVzYyA9IHRydWVcbiAgICAgICAgICB9KVxuICAgICAgICB9XG4gICAgICAgIGlmICghYWRkaXRpdmUpIHtcbiAgICAgICAgICBuZXdTb3J0aW5nID0gbmV3U29ydGluZy5zbGljZShleGlzdGluZ0luZGV4LCBjb2x1bW4ubGVuZ3RoKVxuICAgICAgICB9XG4gICAgICB9IGVsc2Uge1xuICAgICAgICAvLyBOZXcgU29ydCBDb2x1bW5cbiAgICAgICAgaWYgKGFkZGl0aXZlKSB7XG4gICAgICAgICAgbmV3U29ydGluZyA9IG5ld1NvcnRpbmcuY29uY2F0KGNvbHVtbi5tYXAoZCA9PiAoe1xuICAgICAgICAgICAgaWQ6IGQuaWQsXG4gICAgICAgICAgICBkZXNjOiBmYWxzZVxuICAgICAgICAgIH0pKSlcbiAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICBuZXdTb3J0aW5nID0gY29sdW1uLm1hcChkID0+ICh7XG4gICAgICAgICAgICBpZDogZC5pZCxcbiAgICAgICAgICAgIGRlc2M6IGZhbHNlXG4gICAgICAgICAgfSkpXG4gICAgICAgIH1cbiAgICAgIH1cbiAgICB9XG4gICAgdGhpcy5zZXRTdGF0ZVdpdGhEYXRhKHtcbiAgICAgIHBhZ2U6ICgoIXNvcnRpbmcubGVuZ3RoICYmIG5ld1NvcnRpbmcubGVuZ3RoKSB8fCAhYWRkaXRpdmUpID8gMCA6IHRoaXMuc3RhdGUucGFnZSxcbiAgICAgIHNvcnRpbmc6IG5ld1NvcnRpbmdcbiAgICB9LCAoKSA9PiB7XG4gICAgICB0aGlzLmZpcmVPbkNoYW5nZSgpXG4gICAgfSlcbiAgfVxufVxuIl19