'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _utils = require('./utils');

var _utils2 = _interopRequireDefault(_utils);

var _pagination = require('./pagination');

var _pagination2 = _interopRequireDefault(_pagination);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }
//


var emptyObj = function emptyObj() {
  return {};
};

exports.default = {
  // General
  data: [],
  loading: false,
  showPagination: true,
  showPageSizeOptions: true,
  pageSizeOptions: [5, 10, 20, 25, 50, 100],
  defaultPageSize: 20,
  showPageJump: true,
  collapseOnSortingChange: true,
  collapseOnPageChange: true,
  collapseOnDataChange: true,
  freezeWhenExpanded: false,
  defaultSorting: [],
  showFilters: false,
  defaultFiltering: [],
  defaultFilterMethod: function defaultFilterMethod(filter, row, column) {
    var id = filter.pivotId || filter.id;
    return row[id] !== undefined ? String(row[id]).startsWith(filter.value) : true;
  },
  resizable: true,
  defaultResizing: [],

  // Controlled State Overrides
  // page: undefined,
  // pageSize: undefined,
  // sorting: undefined,

  // Controlled State Callbacks
  onExpandSubComponent: undefined,
  onPageChange: undefined,
  onPageSizeChange: undefined,
  onSortingChange: undefined,
  onFilteringChange: undefined,
  onResize: undefined,

  // Pivoting
  pivotBy: undefined,
  pivotColumnWidth: 200,
  pivotValKey: '_pivotVal',
  pivotIDKey: '_pivotID',
  subRowsKey: '_subRows',

  // Pivoting State Overrides
  // expandedRows: {},

  // Pivoting State Callbacks
  onExpandRow: undefined,

  // General Callbacks
  onChange: function onChange() {
    return null;
  },

  // Classes
  className: '',
  style: {},

  // Component decorators
  getProps: emptyObj,
  getTableProps: emptyObj,
  getTheadGroupProps: emptyObj,
  getTheadGroupTrProps: emptyObj,
  getTheadGroupThProps: emptyObj,
  getTheadProps: emptyObj,
  getTheadTrProps: emptyObj,
  getTheadThProps: emptyObj,
  getTheadFilterProps: emptyObj,
  getTheadFilterTrProps: emptyObj,
  getTheadFilterThProps: emptyObj,
  getTbodyProps: emptyObj,
  getTrGroupProps: emptyObj,
  getTrProps: emptyObj,
  getTdProps: emptyObj,
  getTfootProps: emptyObj,
  getTfootTrProps: emptyObj,
  getTfootTdProps: emptyObj,
  getPaginationProps: emptyObj,
  getLoadingProps: emptyObj,
  getNoDataProps: emptyObj,
  getResizerProps: emptyObj,

  // Global Column Defaults
  column: {
    sortable: true,
    show: true,
    minWidth: 100,
    // Cells only
    render: undefined,
    className: '',
    style: {},
    getProps: emptyObj,
    // Headers only
    header: undefined,
    headerClassName: '',
    headerStyle: {},
    getHeaderProps: emptyObj,
    // Footers only
    footer: undefined,
    footerClassName: '',
    footerStyle: {},
    getFooterProps: emptyObj,
    filterMethod: undefined,
    hideFilter: false,
    filterRender: function filterRender(_ref) {
      var filter = _ref.filter,
          onFilterChange = _ref.onFilterChange;
      return _react2.default.createElement('input', { type: 'text',
        style: {
          width: '100%'
        },
        value: filter ? filter.value : '',
        onChange: function onChange(event) {
          return onFilterChange(event.target.value);
        }
      });
    }
  },

  // Global Expander Column Defaults
  expanderDefaults: {
    sortable: false,
    width: 35,
    hideFilter: true
    // render: will be overriden in methods.js to display ExpanderComponent
  },

  // Global Pivot Column Defaults
  pivotDefaults: {
    // render: will be overriden in methods.js to display ExpanderComponent
  },

  // Text
  previousText: 'Previous',
  nextText: 'Next',
  loadingText: 'Loading...',
  noDataText: 'No rows found',
  pageText: 'Page',
  ofText: 'of',
  rowsText: 'rows',

  // Components
  TableComponent: _utils2.default.makeTemplateComponent('rt-table'),
  TheadComponent: _utils2.default.makeTemplateComponent('rt-thead'),
  TbodyComponent: _utils2.default.makeTemplateComponent('rt-tbody'),
  TrGroupComponent: _utils2.default.makeTemplateComponent('rt-tr-group'),
  TrComponent: _utils2.default.makeTemplateComponent('rt-tr'),
  ThComponent: function ThComponent(_ref2) {
    var toggleSort = _ref2.toggleSort,
        className = _ref2.className,
        children = _ref2.children,
        rest = _objectWithoutProperties(_ref2, ['toggleSort', 'className', 'children']);

    return _react2.default.createElement(
      'div',
      _extends({
        className: (0, _classnames2.default)(className, 'rt-th'),
        onClick: function onClick(e) {
          toggleSort && toggleSort(e);
        }
      }, rest),
      children
    );
  },
  TdComponent: _utils2.default.makeTemplateComponent('rt-td'),
  TfootComponent: _utils2.default.makeTemplateComponent('rt-tfoot'),
  ExpanderComponent: function ExpanderComponent(_ref3) {
    var isExpanded = _ref3.isExpanded;

    return _react2.default.createElement(
      'div',
      { className: (0, _classnames2.default)('rt-expander', isExpanded && '-open') },
      '\u2022'
    );
  },
  PaginationComponent: _pagination2.default,
  PreviousComponent: undefined,
  NextComponent: undefined,
  LoadingComponent: function LoadingComponent(_ref4) {
    var className = _ref4.className,
        loading = _ref4.loading,
        loadingText = _ref4.loadingText,
        rest = _objectWithoutProperties(_ref4, ['className', 'loading', 'loadingText']);

    return _react2.default.createElement(
      'div',
      _extends({ className: (0, _classnames2.default)('-loading', { '-active': loading }, className)
      }, rest),
      _react2.default.createElement(
        'div',
        { className: '-loading-inner' },
        loadingText
      )
    );
  },
  NoDataComponent: _utils2.default.makeTemplateComponent('rt-noData'),
  ResizerComponent: _utils2.default.makeTemplateComponent('rt-resizer')
};
//# sourceMappingURL=data:application/json;base64,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