'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReactTableDefaults = undefined;

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _utils = require('./utils');

var _utils2 = _interopRequireDefault(_utils);

var _lifecycle = require('./lifecycle');

var _lifecycle2 = _interopRequireDefault(_lifecycle);

var _methods = require('./methods');

var _methods2 = _interopRequireDefault(_methods);

var _defaultProps = require('./defaultProps');

var _defaultProps2 = _interopRequireDefault(_defaultProps);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }
//


var ReactTableDefaults = exports.ReactTableDefaults = _defaultProps2.default;

var ReactTable = function (_Methods) {
  _inherits(ReactTable, _Methods);

  function ReactTable(props) {
    _classCallCheck(this, ReactTable);

    var _this = _possibleConstructorReturn(this, (ReactTable.__proto__ || Object.getPrototypeOf(ReactTable)).call(this));

    _this.getResolvedState = _this.getResolvedState.bind(_this);
    _this.getDataModel = _this.getDataModel.bind(_this);
    _this.getSortedData = _this.getSortedData.bind(_this);
    _this.fireOnChange = _this.fireOnChange.bind(_this);
    _this.getPropOrState = _this.getPropOrState.bind(_this);
    _this.getStateOrProp = _this.getStateOrProp.bind(_this);
    _this.filterData = _this.filterData.bind(_this);
    _this.sortData = _this.sortData.bind(_this);
    _this.getMinRows = _this.getMinRows.bind(_this);
    _this.onPageChange = _this.onPageChange.bind(_this);
    _this.onPageSizeChange = _this.onPageSizeChange.bind(_this);
    _this.sortColumn = _this.sortColumn.bind(_this);
    _this.filterColumn = _this.filterColumn.bind(_this);
    _this.resizeColumnStart = _this.resizeColumnStart.bind(_this);
    _this.resizeColumnEnd = _this.resizeColumnEnd.bind(_this);
    _this.resizeColumnMoving = _this.resizeColumnMoving.bind(_this);

    _this.state = {
      page: 0,
      pageSize: props.defaultPageSize || 10,
      sorting: props.defaultSorting,
      expandedRows: {},
      filtering: props.defaultFiltering,
      resizing: props.defaultResizing,
      currentlyResizing: undefined,
      skipNextSort: false
    };
    return _this;
  }

  _createClass(ReactTable, [{
    key: 'render',
    value: function render() {
      var _this2 = this;

      var resolvedState = this.getResolvedState();
      var children = resolvedState.children,
          className = resolvedState.className,
          style = resolvedState.style,
          getProps = resolvedState.getProps,
          getTableProps = resolvedState.getTableProps,
          getTheadGroupProps = resolvedState.getTheadGroupProps,
          getTheadGroupTrProps = resolvedState.getTheadGroupTrProps,
          getTheadGroupThProps = resolvedState.getTheadGroupThProps,
          getTheadProps = resolvedState.getTheadProps,
          getTheadTrProps = resolvedState.getTheadTrProps,
          getTheadThProps = resolvedState.getTheadThProps,
          getTheadFilterProps = resolvedState.getTheadFilterProps,
          getTheadFilterTrProps = resolvedState.getTheadFilterTrProps,
          getTheadFilterThProps = resolvedState.getTheadFilterThProps,
          getTbodyProps = resolvedState.getTbodyProps,
          getTrGroupProps = resolvedState.getTrGroupProps,
          getTrProps = resolvedState.getTrProps,
          getTdProps = resolvedState.getTdProps,
          getTfootProps = resolvedState.getTfootProps,
          getTfootTrProps = resolvedState.getTfootTrProps,
          getTfootTdProps = resolvedState.getTfootTdProps,
          getPaginationProps = resolvedState.getPaginationProps,
          getLoadingProps = resolvedState.getLoadingProps,
          getNoDataProps = resolvedState.getNoDataProps,
          getResizerProps = resolvedState.getResizerProps,
          showPagination = resolvedState.showPagination,
          manual = resolvedState.manual,
          loadingText = resolvedState.loadingText,
          noDataText = resolvedState.noDataText,
          showFilters = resolvedState.showFilters,
          resizable = resolvedState.resizable,
          loading = resolvedState.loading,
          pageSize = resolvedState.pageSize,
          page = resolvedState.page,
          sorting = resolvedState.sorting,
          filtering = resolvedState.filtering,
          resizing = resolvedState.resizing,
          pages = resolvedState.pages,
          pivotValKey = resolvedState.pivotValKey,
          subRowsKey = resolvedState.subRowsKey,
          expandedRows = resolvedState.expandedRows,
          onExpandRow = resolvedState.onExpandRow,
          TableComponent = resolvedState.TableComponent,
          TheadComponent = resolvedState.TheadComponent,
          TbodyComponent = resolvedState.TbodyComponent,
          TrGroupComponent = resolvedState.TrGroupComponent,
          TrComponent = resolvedState.TrComponent,
          ThComponent = resolvedState.ThComponent,
          TdComponent = resolvedState.TdComponent,
          TfootComponent = resolvedState.TfootComponent,
          PaginationComponent = resolvedState.PaginationComponent,
          LoadingComponent = resolvedState.LoadingComponent,
          SubComponent = resolvedState.SubComponent,
          NoDataComponent = resolvedState.NoDataComponent,
          ResizerComponent = resolvedState.ResizerComponent,
          resolvedData = resolvedState.resolvedData,
          allVisibleColumns = resolvedState.allVisibleColumns,
          headerGroups = resolvedState.headerGroups,
          hasHeaderGroups = resolvedState.hasHeaderGroups,
          sortedData = resolvedState.sortedData;

      // Pagination

      var startRow = pageSize * page;
      var endRow = startRow + pageSize;
      var pageRows = manual ? resolvedData : sortedData.slice(startRow, endRow);
      var minRows = this.getMinRows();
      var padRows = _utils2.default.range(Math.max(minRows - pageRows.length, 0));

      var hasColumnFooter = allVisibleColumns.some(function (d) {
        return d.footer;
      });

      var recurseRowsViewIndex = function recurseRowsViewIndex(rows) {
        var path = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
        var index = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : -1;

        return [rows.map(function (row, i) {
          index++;
          var rowWithViewIndex = _extends({}, row, {
            _viewIndex: index
          });
          var newPath = path.concat([i]);
          if (rowWithViewIndex[subRowsKey] && _utils2.default.get(expandedRows, newPath)) {
            var _recurseRowsViewIndex = recurseRowsViewIndex(rowWithViewIndex[subRowsKey], newPath, index);

            var _recurseRowsViewIndex2 = _slicedToArray(_recurseRowsViewIndex, 2);

            rowWithViewIndex[subRowsKey] = _recurseRowsViewIndex2[0];
            index = _recurseRowsViewIndex2[1];
          }
          return rowWithViewIndex;
        }), index];
      };

      var _recurseRowsViewIndex3 = recurseRowsViewIndex(pageRows);

      var _recurseRowsViewIndex4 = _slicedToArray(_recurseRowsViewIndex3, 1);

      pageRows = _recurseRowsViewIndex4[0];


      var canPrevious = page > 0;
      var canNext = page + 1 < pages;

      var rowMinWidth = _utils2.default.sum(allVisibleColumns.map(function (d) {
        var resized = resizing.find(function (x) {
          return x.id === d.id;
        }) || {};
        return _utils2.default.getFirstDefined(resized.value, d.width, d.minWidth);
      }));

      var rowIndex = -1;

      var finalState = _extends({}, resolvedState, {
        startRow: startRow,
        endRow: endRow,
        pageRows: pageRows,
        minRows: minRows,
        padRows: padRows,
        hasColumnFooter: hasColumnFooter,
        canPrevious: canPrevious,
        canNext: canNext,
        rowMinWidth: rowMinWidth
      });

      // Visual Components

      var makeHeaderGroups = function makeHeaderGroups() {
        var theadGroupProps = _utils2.default.splitProps(getTheadGroupProps(finalState, undefined, undefined, _this2));
        var theadGroupTrProps = _utils2.default.splitProps(getTheadGroupTrProps(finalState, undefined, undefined, _this2));
        return _react2.default.createElement(
          TheadComponent,
          _extends({
            className: (0, _classnames2.default)('-headerGroups', theadGroupProps.className),
            style: _extends({}, theadGroupProps.style, {
              minWidth: rowMinWidth + 'px'
            })
          }, theadGroupProps.rest),
          _react2.default.createElement(
            TrComponent,
            _extends({
              className: theadGroupTrProps.className,
              style: theadGroupTrProps.style
            }, theadGroupTrProps.rest),
            headerGroups.map(makeHeaderGroup)
          )
        );
      };

      var makeHeaderGroup = function makeHeaderGroup(column, i) {
        var flex = _utils2.default.sum(column.columns.map(function (d) {
          var resized = resizing.find(function (x) {
            return x.id === d.id;
          }) || {};
          return d.width || resized.value ? 0 : d.minWidth;
        }));
        var width = _utils2.default.sum(column.columns.map(function (d) {
          var resized = resizing.find(function (x) {
            return x.id === d.id;
          }) || {};
          return _utils2.default.getFirstDefined(resized.value, d.width, d.minWidth);
        }));
        var maxWidth = _utils2.default.sum(column.columns.map(function (d) {
          var resized = resizing.find(function (x) {
            return x.id === d.id;
          }) || {};
          return _utils2.default.getFirstDefined(resized.value, d.width, d.maxWidth);
        }));
        var theadGroupThProps = _utils2.default.splitProps(getTheadGroupThProps(finalState, undefined, column, _this2));
        var columnHeaderProps = _utils2.default.splitProps(column.getHeaderProps(finalState, undefined, column, _this2));

        var classes = [column.headerClassName, theadGroupThProps.className, columnHeaderProps.className];

        var styles = _extends({}, column.headerStyle, theadGroupThProps.style, columnHeaderProps.style);

        var rest = _extends({}, theadGroupThProps.rest, columnHeaderProps.rest);

        var flexStyles = {
          flex: flex + ' 0 auto',
          width: width + 'px',
          maxWidth: maxWidth + 'px'
        };

        return _react2.default.createElement(
          ThComponent,
          _extends({
            key: i,
            className: (0, _classnames2.default)(classes),
            style: _extends({}, styles, flexStyles)
          }, rest),
          _utils2.default.normalizeComponent(column.header, {
            data: sortedData,
            column: column
          })
        );
      };

      var makeHeaders = function makeHeaders() {
        var theadProps = _utils2.default.splitProps(getTheadProps(finalState, undefined, undefined, _this2));
        var theadTrProps = _utils2.default.splitProps(getTheadTrProps(finalState, undefined, undefined, _this2));
        return _react2.default.createElement(
          TheadComponent,
          _extends({
            className: (0, _classnames2.default)('-header', theadProps.className),
            style: _extends({}, theadProps.style, {
              minWidth: rowMinWidth + 'px'
            })
          }, theadProps.rest),
          _react2.default.createElement(
            TrComponent,
            _extends({
              className: theadTrProps.className,
              style: theadTrProps.style
            }, theadTrProps.rest),
            allVisibleColumns.map(makeHeader)
          )
        );
      };

      var makeHeader = function makeHeader(column, i) {
        var resized = resizing.find(function (x) {
          return x.id === column.id;
        }) || {};
        var sort = sorting.find(function (d) {
          return d.id === column.id;
        });
        var show = typeof column.show === 'function' ? column.show() : column.show;
        var width = _utils2.default.getFirstDefined(resized.value, column.width, column.minWidth);
        var maxWidth = _utils2.default.getFirstDefined(resized.value, column.width, column.maxWidth);
        var theadThProps = _utils2.default.splitProps(getTheadThProps(finalState, undefined, column, _this2));
        var columnHeaderProps = _utils2.default.splitProps(column.getHeaderProps(finalState, undefined, column, _this2));

        var classes = [column.headerClassName, theadThProps.className, columnHeaderProps.className];

        var styles = _extends({}, column.headerStyle, theadThProps.style, columnHeaderProps.style);

        var rest = _extends({}, theadThProps.rest, columnHeaderProps.rest);

        var resizer = resizable ? _react2.default.createElement(ResizerComponent, _extends({
          onMouseDown: function onMouseDown(e) {
            return _this2.resizeColumnStart(column, e, false);
          },
          onTouchStart: function onTouchStart(e) {
            return _this2.resizeColumnStart(column, e, true);
          }
        }, resizerProps)) : null;

        if (column.expander) {
          if (column.pivotColumns) {
            var pivotSort = sorting.find(function (d) {
              return d.id === column.id;
            });
            return _react2.default.createElement(
              ThComponent,
              _extends({
                key: i,
                className: (0, _classnames2.default)('rt-pivot-header', 'rt-resizable-header', column.sortable && '-cursor-pointer', classes, pivotSort ? pivotSort.desc ? '-sort-desc' : '-sort-asc' : ''),
                style: _extends({}, styles, {
                  flex: width + ' 0 auto',
                  width: width + 'px',
                  maxWidth: maxWidth + 'px'
                }),
                toggleSort: function toggleSort(e) {
                  column.sortable && _this2.sortColumn(column.pivotColumns, e.shiftKey);
                }
              }, rest),
              _react2.default.createElement(
                'div',
                { className: 'rt-resizable-header-content' },
                column.pivotColumns.map(function (pivotColumn, i) {
                  return _react2.default.createElement(
                    'span',
                    { key: pivotColumn.id },
                    _utils2.default.normalizeComponent(pivotColumn.header, {
                      data: sortedData,
                      column: column
                    }),
                    i < column.pivotColumns.length - 1 && _utils2.default.normalizeComponent(column.render, {
                      data: sortedData,
                      column: column
                    })
                  );
                })
              ),
              resizer
            );
          }
        }

        return _react2.default.createElement(
          ThComponent,
          _extends({
            key: i,
            className: (0, _classnames2.default)(classes, 'rt-resizable-header', sort ? sort.desc ? '-sort-desc' : '-sort-asc' : '', column.sortable && '-cursor-pointer', !show && '-hidden'),
            style: _extends({}, styles, {
              flex: width + ' 0 auto',
              width: width + 'px',
              maxWidth: maxWidth + 'px'
            }),
            toggleSort: function toggleSort(e) {
              column.sortable && _this2.sortColumn(column, e.shiftKey);
            }
          }, rest),
          _react2.default.createElement(
            'div',
            { className: 'rt-resizable-header-content' },
            _utils2.default.normalizeComponent(column.header, {
              data: sortedData,
              column: column
            })
          ),
          resizer
        );
      };

      var makeFilters = function makeFilters() {
        var theadFilterProps = _utils2.default.splitProps(getTheadFilterProps(finalState, undefined, undefined, _this2));
        var theadFilterTrProps = _utils2.default.splitProps(getTheadFilterTrProps(finalState, undefined, undefined, _this2));
        return _react2.default.createElement(
          TheadComponent,
          _extends({
            className: (0, _classnames2.default)('-filters', theadFilterProps.className),
            style: _extends({}, theadFilterProps.style, {
              minWidth: rowMinWidth + 'px'
            })
          }, theadFilterProps.rest),
          _react2.default.createElement(
            TrComponent,
            _extends({
              className: theadFilterTrProps.className,
              style: theadFilterTrProps.style
            }, theadFilterTrProps.rest),
            allVisibleColumns.map(makeFilter)
          )
        );
      };

      var makeFilter = function makeFilter(column, i) {
        var resized = resizing.find(function (x) {
          return x.id === column.id;
        }) || {};
        var width = _utils2.default.getFirstDefined(resized.value, column.width, column.minWidth);
        var maxWidth = _utils2.default.getFirstDefined(resized.value, column.width, column.maxWidth);
        var theadFilterThProps = _utils2.default.splitProps(getTheadFilterThProps(finalState, undefined, column, _this2));
        var columnHeaderProps = _utils2.default.splitProps(column.getHeaderProps(finalState, undefined, column, _this2));

        var classes = [column.headerClassName, theadFilterThProps.className, columnHeaderProps.className];

        var styles = _extends({}, column.headerStyle, theadFilterThProps.style, columnHeaderProps.style);

        var rest = _extends({}, theadFilterThProps.rest, columnHeaderProps.rest);

        if (column.expander) {
          if (column.pivotColumns) {
            var pivotCols = [];

            var _loop = function _loop(_i) {
              var col = column.pivotColumns[_i];
              var filter = filtering.find(function (filter) {
                return filter.id === column.id && filter.pivotId === col.id;
              });
              pivotCols.push(_react2.default.createElement(
                'span',
                { key: col.id,
                  style: { flex: 1 } },
                !col.hideFilter ? _utils2.default.normalizeComponent(col.filterRender, {
                  col: col,
                  filter: filter,
                  onFilterChange: function onFilterChange(value) {
                    return _this2.filterColumn(column, value, col);
                  }
                }, _defaultProps2.default.column.filterRender) : null
              ));
              if (_i < column.pivotColumns.length - 1) {
                pivotCols.push(_utils2.default.normalizeComponent(column.filterRender, {
                  column: column,
                  filter: filter,
                  key: col.id + '-' + _i
                }, _defaultProps2.default.column.filterRender));
              }
            };

            for (var _i = 0; _i < column.pivotColumns.length; _i++) {
              _loop(_i);
            }
            return _react2.default.createElement(
              ThComponent,
              _extends({
                key: i,
                className: (0, _classnames2.default)('rt-pivot-header', column.sortable && '-cursor-pointer', classes),
                style: _extends({}, styles, {
                  flex: width + ' 0 auto',
                  width: width + 'px',
                  maxWidth: maxWidth + 'px',
                  display: 'flex'
                })
              }, rest),
              pivotCols
            );
          }
        }

        var filter = filtering.find(function (filter) {
          return filter.id === column.id;
        });

        return _react2.default.createElement(
          ThComponent,
          _extends({
            key: i,
            className: (0, _classnames2.default)(classes),
            style: _extends({}, styles, {
              flex: width + ' 0 auto',
              width: width + 'px',
              maxWidth: maxWidth + 'px'
            })
          }, rest),
          !column.hideFilter ? _utils2.default.normalizeComponent(column.filterRender, {
            column: column,
            filter: filter,
            onFilterChange: function onFilterChange(value) {
              return _this2.filterColumn(column, value);
            }
          }, _defaultProps2.default.column.filterRender) : null
        );
      };

      var makePageRow = function makePageRow(row, i) {
        var path = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [];

        var rowInfo = {
          row: row.__original,
          rowValues: row,
          index: row.__index,
          viewIndex: ++rowIndex,
          level: path.length,
          nestingPath: path.concat([i]),
          aggregated: !!row[subRowsKey],
          subRows: row[subRowsKey]
        };
        var isExpanded = _utils2.default.get(expandedRows, rowInfo.nestingPath);
        var trGroupProps = getTrGroupProps(finalState, rowInfo, undefined, _this2);
        var trProps = _utils2.default.splitProps(getTrProps(finalState, rowInfo, undefined, _this2));
        return _react2.default.createElement(
          TrGroupComponent,
          _extends({
            key: rowInfo.nestingPath.join('_')
          }, trGroupProps),
          _react2.default.createElement(
            TrComponent,
            _extends({
              className: (0, _classnames2.default)(trProps.className, row._viewIndex % 2 ? '-even' : '-odd'),
              style: trProps.style
            }, trProps.rest),
            allVisibleColumns.map(function (column, i2) {
              var resized = resizing.find(function (x) {
                return x.id === column.id;
              }) || {};
              var show = typeof column.show === 'function' ? column.show() : column.show;
              var width = _utils2.default.getFirstDefined(resized.value, column.width, column.minWidth);
              var maxWidth = _utils2.default.getFirstDefined(resized.value, column.width, column.maxWidth);
              var tdProps = _utils2.default.splitProps(getTdProps(finalState, rowInfo, column, _this2));
              var columnProps = _utils2.default.splitProps(column.getProps(finalState, rowInfo, column, _this2));

              var classes = [tdProps.className, column.className, columnProps.className];

              var styles = _extends({}, tdProps.style, column.style, columnProps.style);

              var extraProps = {};

              if (column.expander) {
                var onTdClick = function onTdClick(e) {
                  if (onExpandRow) {
                    return onExpandRow(rowInfo.nestingPath, e);
                  }
                  var newExpandedRows = _utils2.default.clone(expandedRows);
                  if (isExpanded) {
                    return _this2.setStateWithData({
                      expandedRows: _utils2.default.set(newExpandedRows, rowInfo.nestingPath, false)
                    });
                  }
                  return _this2.setStateWithData({
                    expandedRows: _utils2.default.set(newExpandedRows, rowInfo.nestingPath, {})
                  });
                };

                extraProps['onClick'] = onTdClick;

                if (column.pivotColumns) {
                  // Return the pivot expander cell
                  var PivotCell = column.pivotRender;
                  return _react2.default.createElement(
                    TdComponent,
                    _extends({
                      key: i2,
                      className: (0, _classnames2.default)('rt-pivot', classes),
                      style: _extends({}, styles, {
                        paddingLeft: rowInfo.nestingPath.length === 1 ? undefined : 30 * (rowInfo.nestingPath.length - 1) + 'px',
                        flex: width + ' 0 auto',
                        width: width + 'px',
                        maxWidth: maxWidth + 'px'
                      })
                    }, tdProps.rest, {
                      onClick: onTdClick
                    }),
                    rowInfo.subRows ? _react2.default.createElement(
                      'span',
                      null,
                      _utils2.default.normalizeComponent(column.render, _extends({}, rowInfo, {
                        value: rowInfo.rowValues[column.id],
                        isExpanded: isExpanded
                      }), rowInfo.rowValues[column.id]),
                      column && column.pivotRender ? _react2.default.createElement(PivotCell, _extends({}, rowInfo, {
                        value: rowInfo.rowValues[pivotValKey]
                      })) : _react2.default.createElement(
                        'span',
                        null,
                        row[pivotValKey],
                        ' (',
                        rowInfo.subRows.length,
                        ')'
                      )
                    ) : SubComponent ? _react2.default.createElement(
                      'span',
                      null,
                      _utils2.default.normalizeComponent(column.render, _extends({}, rowInfo, {
                        value: rowInfo.rowValues[column.id],
                        isExpanded: isExpanded
                      }), rowInfo.rowValues[column.id])
                    ) : null
                  );
                }
              }

              // Return regular cell
              return _react2.default.createElement(
                TdComponent,
                _extends({
                  key: i2,
                  className: (0, _classnames2.default)(classes, !show && 'hidden'),
                  style: _extends({}, styles, {
                    flex: width + ' 0 auto',
                    width: width + 'px',
                    maxWidth: maxWidth + 'px'
                  })
                }, tdProps.rest, extraProps),
                _utils2.default.normalizeComponent(column.render, _extends({}, rowInfo, {
                  value: rowInfo.rowValues[column.id],
                  isExpanded: isExpanded
                }), rowInfo.rowValues[column.id])
              );
            })
          ),
          rowInfo.subRows && isExpanded && rowInfo.subRows.map(function (d, i) {
            return makePageRow(d, i, rowInfo.nestingPath);
          }),
          SubComponent && !rowInfo.subRows && isExpanded && SubComponent(rowInfo)
        );
      };

      var makePadRow = function makePadRow(row, i) {
        var trGroupProps = getTrGroupProps(finalState, undefined, undefined, _this2);
        var trProps = _utils2.default.splitProps(getTrProps(finalState, undefined, undefined, _this2));
        return _react2.default.createElement(
          TrGroupComponent,
          _extends({
            key: i
          }, trGroupProps),
          _react2.default.createElement(
            TrComponent,
            {
              className: (0, _classnames2.default)('-padRow', trProps.className),
              style: trProps.style || {}
            },
            allVisibleColumns.map(function (column, i2) {
              var resized = resizing.find(function (x) {
                return x.id === column.id;
              }) || {};
              var show = typeof column.show === 'function' ? column.show() : column.show;
              var width = _utils2.default.getFirstDefined(resized.value, column.width, column.minWidth);
              var maxWidth = _utils2.default.getFirstDefined(resized.value, column.width, column.maxWidth);
              var tdProps = _utils2.default.splitProps(getTdProps(finalState, undefined, column, _this2));
              var columnProps = _utils2.default.splitProps(column.getProps(finalState, undefined, column, _this2));

              var classes = [tdProps.className, column.className, columnProps.className];

              var styles = _extends({}, tdProps.style, column.style, columnProps.style);

              return _react2.default.createElement(
                TdComponent,
                _extends({
                  key: i2,
                  className: (0, _classnames2.default)(classes, !show && 'hidden'),
                  style: _extends({}, styles, {
                    flex: width + ' 0 auto',
                    width: width + 'px',
                    maxWidth: maxWidth + 'px'
                  })
                }, tdProps.rest),
                '\xA0'
              );
            })
          )
        );
      };

      var makeColumnFooters = function makeColumnFooters() {
        var tFootProps = getTfootProps(finalState, undefined, undefined, _this2);
        var tFootTrProps = _utils2.default.splitProps(getTfootTrProps(finalState, undefined, undefined, _this2));
        return _react2.default.createElement(
          TfootComponent,
          _extends({
            className: tFootProps.className,
            style: _extends({}, tFootProps.style, {
              minWidth: rowMinWidth + 'px'
            })
          }, tFootProps.rest),
          _react2.default.createElement(
            TrComponent,
            _extends({
              className: (0, _classnames2.default)(tFootTrProps.className),
              style: tFootTrProps.style
            }, tFootTrProps.rest),
            allVisibleColumns.map(function (column, i2) {
              var resized = resizing.find(function (x) {
                return x.id === column.id;
              }) || {};
              var show = typeof column.show === 'function' ? column.show() : column.show;
              var width = _utils2.default.getFirstDefined(resized.value, column.width, column.minWidth);
              var maxWidth = _utils2.default.getFirstDefined(resized.value, column.width, column.maxWidth);
              var tFootTdProps = _utils2.default.splitProps(getTfootTdProps(finalState, undefined, undefined, _this2));
              var columnProps = _utils2.default.splitProps(column.getProps(finalState, undefined, column, _this2));
              var columnFooterProps = _utils2.default.splitProps(column.getFooterProps(finalState, undefined, column, _this2));

              var classes = [tFootTdProps.className, column.className, columnProps.className, columnFooterProps.className];

              var styles = _extends({}, tFootTdProps.style, column.style, columnProps.style, columnFooterProps.style);

              if (column.expander) {
                if (column.pivotColumns) {
                  return _react2.default.createElement(
                    TdComponent,
                    _extends({
                      key: i2,
                      className: (0, _classnames2.default)('rt-pivot', classes),
                      style: _extends({}, styles, {
                        flex: width + ' 0 auto',
                        width: width + 'px',
                        maxWidth: maxWidth + 'px'
                      })
                    }, columnProps.rest, tFootTdProps.rest, columnFooterProps.rest),
                    _utils2.default.normalizeComponent(column.footer)
                  );
                }
              }

              // Return regular cell
              return _react2.default.createElement(
                TdComponent,
                _extends({
                  key: i2,
                  className: (0, _classnames2.default)(classes, !show && 'hidden'),
                  style: _extends({}, styles, {
                    flex: width + ' 0 auto',
                    width: width + 'px',
                    maxWidth: maxWidth + 'px'
                  })
                }, columnProps.rest, tFootTdProps.rest, columnFooterProps.rest),
                _utils2.default.normalizeComponent(column.footer, {
                  data: sortedData,
                  column: column
                })
              );
            })
          )
        );
      };

      var rootProps = _utils2.default.splitProps(getProps(finalState, undefined, undefined, this));
      var tableProps = _utils2.default.splitProps(getTableProps(finalState, undefined, undefined, this));
      var tBodyProps = _utils2.default.splitProps(getTbodyProps(finalState, undefined, undefined, this));
      var paginationProps = _utils2.default.splitProps(getPaginationProps(finalState, undefined, undefined, this));
      var loadingProps = getLoadingProps(finalState, undefined, undefined, this);
      var noDataProps = getNoDataProps(finalState, undefined, undefined, this);
      var resizerProps = getResizerProps(finalState, undefined, undefined, this);

      var makeTable = function makeTable() {
        return _react2.default.createElement(
          'div',
          _extends({
            className: (0, _classnames2.default)('ReactTable', className, rootProps.className),
            style: _extends({}, style, rootProps.style)
          }, rootProps.rest),
          _react2.default.createElement(
            TableComponent,
            _extends({
              className: (0, _classnames2.default)(tableProps.className),
              style: tableProps.style
            }, tableProps.rest),
            hasHeaderGroups ? makeHeaderGroups() : null,
            makeHeaders(),
            showFilters ? makeFilters() : null,
            _react2.default.createElement(
              TbodyComponent,
              _extends({
                className: (0, _classnames2.default)(tBodyProps.className),
                style: _extends({}, tBodyProps.style, {
                  minWidth: rowMinWidth + 'px'
                })
              }, tBodyProps.rest),
              pageRows.map(function (d, i) {
                return makePageRow(d, i);
              }),
              padRows.map(makePadRow)
            ),
            hasColumnFooter ? makeColumnFooters() : null
          ),
          showPagination ? _react2.default.createElement(PaginationComponent, _extends({}, resolvedState, {
            pages: pages,
            canPrevious: canPrevious,
            canNext: canNext,
            onPageChange: _this2.onPageChange,
            onPageSizeChange: _this2.onPageSizeChange,
            className: paginationProps.className,
            style: paginationProps.style
          }, paginationProps.rest)) : null,
          !pageRows.length && _react2.default.createElement(
            NoDataComponent,
            noDataProps,
            _utils2.default.normalizeComponent(noDataText)
          ),
          _react2.default.createElement(LoadingComponent, _extends({
            loading: loading,
            loadingText: loadingText
          }, loadingProps))
        );
      };

      // childProps are optionally passed to a function-as-a-child
      return children ? children(finalState, makeTable, this) : makeTable();
    }
  }]);

  return ReactTable;
}((0, _methods2.default)((0, _lifecycle2.default)(_react.Component)));

ReactTable.defaultProps = _defaultProps2.default;
exports.default = ReactTable;
//# sourceMappingURL=data:application/json;base64,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