"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

exports.default = function (Base) {
  return function (_Base) {
    _inherits(_class, _Base);

    function _class() {
      _classCallCheck(this, _class);

      return _possibleConstructorReturn(this, (_class.__proto__ || Object.getPrototypeOf(_class)).apply(this, arguments));
    }

    _createClass(_class, [{
      key: "componentWillMount",
      value: function componentWillMount() {
        this.setStateWithData(this.getDataModel(this.getResolvedState()));
      }
    }, {
      key: "componentDidMount",
      value: function componentDidMount() {
        this.fireOnChange();
      }
    }, {
      key: "componentWillReceiveProps",
      value: function componentWillReceiveProps(nextProps, nextState) {
        var oldState = this.getResolvedState();
        var newState = this.getResolvedState(nextProps, nextState);

        if (oldState.defaultSorting !== newState.defaultSorting) {
          newState.sorting = newState.defaultSorting;
        }

        if (oldState.showFilters !== newState.showFilters || oldState.showFilters !== newState.showFilters) {
          newState.filtering = newState.defaultFiltering;
        }

        // Props that trigger a data update
        if (oldState.data !== newState.data || oldState.columns !== newState.columns || oldState.pivotBy !== newState.pivotBy || oldState.sorting !== newState.sorting || oldState.showFilters !== newState.showFilters || oldState.filtering !== newState.filtering) {
          this.setStateWithData(this.getDataModel(newState));
        }
      }
    }, {
      key: "setStateWithData",
      value: function setStateWithData(newState, cb) {
        var oldState = this.getResolvedState();
        var newResolvedState = this.getResolvedState({}, newState);
        var freezeWhenExpanded = newResolvedState.freezeWhenExpanded;

        // Default to unfrozen state

        newResolvedState.frozen = false;

        // If freezeWhenExpanded is set, check for frozen conditions
        if (freezeWhenExpanded) {
          // if any rows are expanded, freeze the existing data and sorting
          var keys = Object.keys(newResolvedState.expandedRows);
          for (var i = 0; i < keys.length; i++) {
            if (newResolvedState.expandedRows[keys[i]]) {
              newResolvedState.frozen = true;
              break;
            }
          }
        }

        // If the data isn't frozen and either the data or
        // sorting model has changed, update the data
        if (oldState.frozen && !newResolvedState.frozen || oldState.sorting !== newResolvedState.sorting || oldState.filtering !== newResolvedState.filtering || oldState.showFilters !== newResolvedState.showFilters || !newResolvedState.frozen && oldState.resolvedData !== newResolvedState.resolvedData) {
          // Handle collapseOnSortingChange & collapseOnDataChange
          if (oldState.sorting !== newResolvedState.sorting && this.props.collapseOnSortingChange || oldState.filtering !== newResolvedState.filtering || oldState.showFilters !== newResolvedState.showFilters || !newResolvedState.frozen && oldState.resolvedData !== newResolvedState.resolvedData && this.props.collapseOnDataChange) {
            newResolvedState.expandedRows = {};
          }

          Object.assign(newResolvedState, this.getSortedData(newResolvedState));
        }

        // Calculate pageSize all the time
        if (newResolvedState.sortedData) {
          newResolvedState.pages = newResolvedState.manual ? newResolvedState.pages : Math.ceil(newResolvedState.sortedData.length / newResolvedState.pageSize);
          newResolvedState.page = Math.max(newResolvedState.page >= newResolvedState.pages ? newResolvedState.pages - 1 : newResolvedState.page, 0);
        }

        return this.setState(newResolvedState, cb);
      }
    }]);

    return _class;
  }(Base);
};
//# sourceMappingURL=data:application/json;base64,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