'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _utils = require('./utils');

var _utils2 = _interopRequireDefault(_utils);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

exports.default = function (Base) {
  return function (_Base) {
    _inherits(_class, _Base);

    function _class() {
      _classCallCheck(this, _class);

      return _possibleConstructorReturn(this, (_class.__proto__ || Object.getPrototypeOf(_class)).apply(this, arguments));
    }

    _createClass(_class, [{
      key: 'getResolvedState',
      value: function getResolvedState(props, state) {
        var resolvedState = _extends({}, _utils2.default.compactObject(this.state), _utils2.default.compactObject(this.props), _utils2.default.compactObject(state), _utils2.default.compactObject(props));
        return resolvedState;
      }
    }, {
      key: 'getDataModel',
      value: function getDataModel(newState) {
        var _this2 = this;

        var columns = newState.columns,
            _newState$pivotBy = newState.pivotBy,
            pivotBy = _newState$pivotBy === undefined ? [] : _newState$pivotBy,
            data = newState.data,
            pivotIDKey = newState.pivotIDKey,
            pivotValKey = newState.pivotValKey,
            subRowsKey = newState.subRowsKey,
            SubComponent = newState.SubComponent;

        // Determine Header Groups

        var hasHeaderGroups = false;
        columns.forEach(function (column) {
          if (column.columns) {
            hasHeaderGroups = true;
          }
        });

        // Build Header Groups
        var headerGroups = [];
        var currentSpan = [];

        // A convenience function to add a header and reset the currentSpan
        var addHeader = function addHeader(columns) {
          var column = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : columns[0];

          headerGroups.push(_extends({}, _this2.props.column, column, {
            columns: columns
          }));
          currentSpan = [];
        };

        var columnsWithExpander = [].concat(_toConsumableArray(columns));

        var expanderColumn = columns.find(function (col) {
          return col.expander || col.columns && col.columns.some(function (col2) {
            return col2.expander;
          });
        });
        // The actual expander might be in the columns field of a group column
        if (expanderColumn && !expanderColumn.expander) {
          expanderColumn = expanderColumn.columns.find(function (col) {
            return col.expander;
          });
        }

        // If it has subrows or pivot columns we need to make sure we have an expander column
        if ((SubComponent || pivotBy.length) && !expanderColumn) {
          expanderColumn = { expander: true };
          columnsWithExpander = [expanderColumn].concat(_toConsumableArray(columnsWithExpander));
        }

        var makeDecoratedColumn = function makeDecoratedColumn(column) {
          var dcol = void 0;
          if (pivotBy.length && column.expander) {
            dcol = _extends({}, _this2.props.column, {
              render: _this2.props.ExpanderComponent,
              filterRender: _this2.props.ExpanderComponent
            }, _this2.props.pivotDefaults, column);
          } else if (column.expander) {
            dcol = _extends({}, _this2.props.column, {
              render: _this2.props.ExpanderComponent
            }, _this2.props.expanderDefaults, column);
          } else {
            dcol = _extends({}, _this2.props.column, column);
          }

          if (typeof dcol.accessor === 'string') {
            var _ret = function () {
              dcol.id = dcol.id || dcol.accessor;
              var accessorString = dcol.accessor;
              dcol.accessor = function (row) {
                return _utils2.default.get(row, accessorString);
              };
              return {
                v: dcol
              };
            }();

            if ((typeof _ret === 'undefined' ? 'undefined' : _typeof(_ret)) === "object") return _ret.v;
          }

          if (dcol.accessor && !dcol.id) {
            console.warn(dcol);
            throw new Error('A column id is required if using a non-string accessor for column above.');
          }

          if (!dcol.accessor) {
            dcol.accessor = function (d) {
              return undefined;
            };
          }

          // Ensure minWidth is not greater than maxWidth if set
          if (dcol.maxWidth < dcol.minWidth) {
            dcol.minWidth = dcol.maxWidth;
          }

          return dcol;
        };

        // Decorate the columns
        var decorateAndAddToAll = function decorateAndAddToAll(col) {
          var decoratedColumn = makeDecoratedColumn(col);
          allDecoratedColumns.push(decoratedColumn);
          return decoratedColumn;
        };
        var allDecoratedColumns = [];
        var decoratedColumns = columnsWithExpander.map(function (column, i) {
          if (column.columns) {
            return _extends({}, column, {
              columns: column.columns.map(decorateAndAddToAll)
            });
          } else {
            return decorateAndAddToAll(column);
          }
        });

        // Build the visible columns, headers and flat column list
        var visibleColumns = decoratedColumns.slice();
        var allVisibleColumns = [];

        visibleColumns = visibleColumns.map(function (column, i) {
          if (column.columns) {
            var visibleSubColumns = column.columns.filter(function (d) {
              return pivotBy.indexOf(d.id) > -1 ? false : _utils2.default.getFirstDefined(d.show, true);
            });
            return _extends({}, column, {
              columns: visibleSubColumns
            });
          }
          return column;
        });

        visibleColumns = visibleColumns.filter(function (column) {
          return column.columns ? column.columns.length : pivotBy.indexOf(column.id) > -1 ? false : _utils2.default.getFirstDefined(column.show, true);
        });

        // Move the pivot columns into a single column if needed
        if (pivotBy.length) {
          var pivotColumns = [];
          for (var i = 0; i < allDecoratedColumns.length; i++) {
            if (pivotBy.indexOf(allDecoratedColumns[i].id) > -1) {
              pivotColumns.push(allDecoratedColumns[i]);
            }
          }

          var pivotExpanderColumn = visibleColumns.findIndex(function (col) {
            return col.expander || col.columns && col.columns.some(function (col2) {
              return col2.expander;
            });
          });
          if (pivotExpanderColumn >= 0) {
            var _pivotColumn = _extends({}, visibleColumns[pivotExpanderColumn], {
              pivotColumns: pivotColumns
            });
            visibleColumns[pivotExpanderColumn] = _pivotColumn;
          } else {
            // If the expander column wasn't on the top level column, find it in the `columns` option.
            var pivotExpanderSubColumn = visibleColumns[pivotExpanderColumn].columns.findIndex(function (col) {
              return col.expander;
            });
            var _pivotColumn2 = _extends({}, visibleColumns[pivotExpanderColumn].columns[pivotExpanderSubColumn], {
              pivotColumns: pivotColumns
            });
            // Add the pivot columns to the expander column
            visibleColumns[pivotExpanderColumn].columns[pivotExpanderSubColumn] = _pivotColumn2;
          }
        }

        // Build flast list of allVisibleColumns and HeaderGroups
        visibleColumns.forEach(function (column, i) {
          if (column.columns) {
            allVisibleColumns = allVisibleColumns.concat(column.columns);
            if (currentSpan.length > 0) {
              addHeader(currentSpan);
            }
            addHeader(column.columns, column);
            return;
          }
          allVisibleColumns.push(column);
          currentSpan.push(column);
        });
        if (hasHeaderGroups && currentSpan.length > 0) {
          addHeader(currentSpan);
        }

        // Access the data
        var resolvedData = data.map(function (d, i) {
          var row = {
            __original: d,
            __index: i
          };
          allDecoratedColumns.forEach(function (column) {
            if (column.expander) return;
            row[column.id] = column.accessor(d);
          });
          return row;
        });

        // If pivoting, recursively group the data
        var aggregate = function aggregate(rows) {
          var aggregationValues = {};
          aggregatingColumns.forEach(function (column) {
            var values = rows.map(function (d) {
              return d[column.id];
            });
            aggregationValues[column.id] = column.aggregate(values, rows);
          });
          return aggregationValues;
        };
        var aggregatingColumns = allVisibleColumns.filter(function (d) {
          return !d.expander && d.aggregate;
        });
        var pivotColumn = void 0;
        if (pivotBy.length) {
          (function () {
            pivotColumn = allVisibleColumns[0];
            var groupRecursively = function groupRecursively(rows, keys) {
              var i = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;

              // This is the last level, just return the rows
              if (i === keys.length) {
                return rows;
              }
              // Group the rows together for this level
              var groupedRows = Object.entries(_utils2.default.groupBy(rows, keys[i])).map(function (_ref) {
                var _ref3;

                var _ref2 = _slicedToArray(_ref, 2),
                    key = _ref2[0],
                    value = _ref2[1];

                return _ref3 = {}, _defineProperty(_ref3, pivotIDKey, keys[i]), _defineProperty(_ref3, pivotValKey, key), _defineProperty(_ref3, keys[i], key), _defineProperty(_ref3, subRowsKey, value), _ref3;
              });
              // Recurse into the subRows
              groupedRows = groupedRows.map(function (rowGroup) {
                var subRows = groupRecursively(rowGroup[subRowsKey], keys, i + 1);
                return _extends({}, rowGroup, _defineProperty({}, subRowsKey, subRows), aggregate(subRows));
              });
              return groupedRows;
            };
            resolvedData = groupRecursively(resolvedData, pivotBy);
          })();
        }

        return _extends({}, newState, {
          resolvedData: resolvedData,
          pivotColumn: pivotColumn,
          allVisibleColumns: allVisibleColumns,
          headerGroups: headerGroups,
          allDecoratedColumns: allDecoratedColumns,
          hasHeaderGroups: hasHeaderGroups
        });
      }
    }, {
      key: 'getSortedData',
      value: function getSortedData(resolvedState) {
        var manual = resolvedState.manual,
            sorting = resolvedState.sorting,
            filtering = resolvedState.filtering,
            showFilters = resolvedState.showFilters,
            defaultFilterMethod = resolvedState.defaultFilterMethod,
            resolvedData = resolvedState.resolvedData,
            allVisibleColumns = resolvedState.allVisibleColumns;

        // Resolve the data from either manual data or sorted data

        return {
          sortedData: manual ? resolvedData : this.sortData(this.filterData(resolvedData, showFilters, filtering, defaultFilterMethod, allVisibleColumns), sorting)
        };
      }
    }, {
      key: 'fireOnChange',
      value: function fireOnChange() {
        this.props.onChange(this.getResolvedState(), this);
      }
    }, {
      key: 'getPropOrState',
      value: function getPropOrState(key) {
        return _utils2.default.getFirstDefined(this.props[key], this.state[key]);
      }
    }, {
      key: 'getStateOrProp',
      value: function getStateOrProp(key) {
        return _utils2.default.getFirstDefined(this.state[key], this.props[key]);
      }
    }, {
      key: 'filterData',
      value: function filterData(data, showFilters, filtering, defaultFilterMethod, allVisibleColumns) {
        var _this3 = this;

        var filteredData = data;

        if (showFilters && filtering.length) {
          filteredData = filtering.reduce(function (filteredSoFar, nextFilter) {
            return filteredSoFar.filter(function (row) {
              var column = void 0;

              if (nextFilter.pivotId) {
                var parentColumn = allVisibleColumns.find(function (x) {
                  return x.id === nextFilter.id;
                });
                column = parentColumn.pivotColumns.find(function (x) {
                  return x.id === nextFilter.pivotId;
                });
              } else {
                column = allVisibleColumns.find(function (x) {
                  return x.id === nextFilter.id;
                });
              }

              var filterMethod = column.filterMethod || defaultFilterMethod;

              return filterMethod(nextFilter, row, column);
            });
          }, filteredData);

          // Apply the filter to the subrows if we are pivoting, and then
          // filter any rows without subcolumns because it would be strange to show
          filteredData = filteredData.map(function (row) {
            if (!row[_this3.props.subRowsKey]) {
              return row;
            }
            return _extends({}, row, _defineProperty({}, _this3.props.subRowsKey, _this3.filterData(row[_this3.props.subRowsKey], showFilters, filtering, defaultFilterMethod, allVisibleColumns)));
          }).filter(function (row) {
            if (!row[_this3.props.subRowsKey]) {
              return true;
            }
            return row[_this3.props.subRowsKey].length > 0;
          });
        }

        return filteredData;
      }
    }, {
      key: 'sortData',
      value: function sortData(data, sorting) {
        var _this4 = this;

        if (!sorting.length) {
          return data;
        }

        var sorted = _utils2.default.orderBy(data, sorting.map(function (sort) {
          return function (row) {
            if (row[sort.id] === null || row[sort.id] === undefined) {
              return -Infinity;
            }
            return typeof row[sort.id] === 'string' ? row[sort.id].toLowerCase() : row[sort.id];
          };
        }), sorting.map(function (d) {
          return !d.desc;
        }));

        return sorted.map(function (row) {
          if (!row[_this4.props.subRowsKey]) {
            return row;
          }
          return _extends({}, row, _defineProperty({}, _this4.props.subRowsKey, _this4.sortData(row[_this4.props.subRowsKey], sorting)));
        });
      }
    }, {
      key: 'getMinRows',
      value: function getMinRows() {
        return _utils2.default.getFirstDefined(this.props.minRows, this.getStateOrProp('pageSize'));
      }

      // User actions

    }, {
      key: 'onPageChange',
      value: function onPageChange(page) {
        var _this5 = this;

        var _props = this.props,
            onPageChange = _props.onPageChange,
            collapseOnPageChange = _props.collapseOnPageChange;

        if (onPageChange) {
          return onPageChange(page);
        }
        var newState = { page: page };
        if (collapseOnPageChange) {
          newState.expandedRows = {};
        }
        this.setStateWithData(newState, function () {
          _this5.fireOnChange();
        });
      }
    }, {
      key: 'onPageSizeChange',
      value: function onPageSizeChange(newPageSize) {
        var _this6 = this;

        var onPageSizeChange = this.props.onPageSizeChange;

        var _getResolvedState = this.getResolvedState(),
            pageSize = _getResolvedState.pageSize,
            page = _getResolvedState.page;

        // Normalize the page to display


        var currentRow = pageSize * page;
        var newPage = Math.floor(currentRow / newPageSize);

        if (onPageSizeChange) {
          return onPageSizeChange(newPageSize, newPage);
        }

        this.setStateWithData({
          pageSize: newPageSize,
          page: newPage
        }, function () {
          _this6.fireOnChange();
        });
      }
    }, {
      key: 'sortColumn',
      value: function sortColumn(column, additive) {
        var _this7 = this;

        var _getResolvedState2 = this.getResolvedState(),
            sorting = _getResolvedState2.sorting,
            skipNextSort = _getResolvedState2.skipNextSort;

        // we can't stop event propagation from the column resize move handlers
        // attached to the document because of react's synthetic events
        // so we have to prevent the sort function from actually sorting
        // if we click on the column resize element within a header.


        if (skipNextSort) {
          this.setStateWithData({
            skipNextSort: false
          });
          return;
        }

        var onSortingChange = this.props.onSortingChange;

        if (onSortingChange) {
          return onSortingChange(column, additive);
        }
        var newSorting = _utils2.default.clone(sorting || []).map(function (d) {
          d.desc = _utils2.default.isSortingDesc(d);
          return d;
        });
        if (!_utils2.default.isArray(column)) {
          // Single-Sort
          var existingIndex = newSorting.findIndex(function (d) {
            return d.id === column.id;
          });
          if (existingIndex > -1) {
            var existing = newSorting[existingIndex];
            if (existing.desc) {
              if (additive) {
                newSorting.splice(existingIndex, 1);
              } else {
                existing.desc = false;
                newSorting = [existing];
              }
            } else {
              existing.desc = true;
              if (!additive) {
                newSorting = [existing];
              }
            }
          } else {
            if (additive) {
              newSorting.push({
                id: column.id,
                desc: false
              });
            } else {
              newSorting = [{
                id: column.id,
                desc: false
              }];
            }
          }
        } else {
          (function () {
            // Multi-Sort
            var existingIndex = newSorting.findIndex(function (d) {
              return d.id === column[0].id;
            });
            // Existing Sorted Column
            if (existingIndex > -1) {
              var _existing = newSorting[existingIndex];
              if (_existing.desc) {
                if (additive) {
                  newSorting.splice(existingIndex, column.length);
                } else {
                  column.forEach(function (d, i) {
                    newSorting[existingIndex + i].desc = false;
                  });
                }
              } else {
                column.forEach(function (d, i) {
                  newSorting[existingIndex + i].desc = true;
                });
              }
              if (!additive) {
                newSorting = newSorting.slice(existingIndex, column.length);
              }
            } else {
              // New Sort Column
              if (additive) {
                newSorting = newSorting.concat(column.map(function (d) {
                  return {
                    id: d.id,
                    desc: false
                  };
                }));
              } else {
                newSorting = column.map(function (d) {
                  return {
                    id: d.id,
                    desc: false
                  };
                });
              }
            }
          })();
        }
        this.setStateWithData({
          page: !sorting.length && newSorting.length || !additive ? 0 : this.state.page,
          sorting: newSorting
        }, function () {
          _this7.fireOnChange();
        });
      }
    }, {
      key: 'filterColumn',
      value: function filterColumn(column, value, pivotColumn) {
        var _this8 = this;

        var _getResolvedState3 = this.getResolvedState(),
            filtering = _getResolvedState3.filtering;

        var onFilteringChange = this.props.onFilteringChange;


        if (onFilteringChange) {
          return onFilteringChange(column, value, pivotColumn);
        }

        // Remove old filter first if it exists
        var newFiltering = (filtering || []).filter(function (x) {
          if (x.id !== column.id) {
            return true;
          }
          if (x.pivotId) {
            if (pivotColumn) {
              return x.pivotId !== pivotColumn.id;
            }
            return true;
          }
        });

        if (value !== '') {
          newFiltering.push({
            id: column.id,
            value: value,
            pivotId: pivotColumn ? pivotColumn.id : undefined
          });
        }

        this.setStateWithData({
          filtering: newFiltering
        }, function () {
          _this8.fireOnChange();
        });
      }
    }, {
      key: 'resizeColumnStart',
      value: function resizeColumnStart(column, event, isTouch) {
        var _this9 = this;

        var onResize = this.props.onResize;


        if (onResize) {
          return onResize(column, event, isTouch);
        }

        var parentWidth = event.target.parentElement.getBoundingClientRect().width;

        var pageX = void 0;
        if (isTouch) {
          pageX = event.changedTouches[0].pageX;
        } else {
          pageX = event.pageX;
        }

        this.setStateWithData({
          currentlyResizing: {
            id: column.id,
            startX: pageX,
            parentWidth: parentWidth
          }
        }, function () {
          if (isTouch) {
            document.addEventListener('touchmove', _this9.resizeColumnMoving);
            document.addEventListener('touchcancel', _this9.resizeColumnEnd);
            document.addEventListener('touchend', _this9.resizeColumnEnd);
          } else {
            document.addEventListener('mousemove', _this9.resizeColumnMoving);
            document.addEventListener('mouseup', _this9.resizeColumnEnd);
            document.addEventListener('mouseleave', _this9.resizeColumnEnd);
          }
        });
      }
    }, {
      key: 'resizeColumnEnd',
      value: function resizeColumnEnd(event) {
        var isTouch = event.type === 'touchend' || event.type === 'touchcancel';

        if (isTouch) {
          document.removeEventListener('touchmove', this.resizeColumnMoving);
          document.removeEventListener('touchcancel', this.resizeColumnEnd);
          document.removeEventListener('touchend', this.resizeColumnEnd);
        }

        // If its a touch event clear the mouse one's as well because sometimes
        // the mouseDown event gets called as well, but the mouseUp event doesn't
        document.removeEventListener('mousemove', this.resizeColumnMoving);
        document.removeEventListener('mouseup', this.resizeColumnEnd);
        document.removeEventListener('mouseleave', this.resizeColumnEnd);

        // The touch events don't propagate up to the sorting's onMouseDown event so
        // no need to prevent it from happening or else the first click after a touch
        // event resize will not sort the column.
        if (!isTouch) {
          this.setStateWithData({
            skipNextSort: true
          });
        }
      }
    }, {
      key: 'resizeColumnMoving',
      value: function resizeColumnMoving(event) {
        var _getResolvedState4 = this.getResolvedState(),
            resizing = _getResolvedState4.resizing,
            currentlyResizing = _getResolvedState4.currentlyResizing;

        // Delete old value


        var newResizing = resizing.filter(function (x) {
          return x.id !== currentlyResizing.id;
        });

        var pageX = void 0;

        if (event.type === 'touchmove') {
          pageX = event.changedTouches[0].pageX;
        } else if (event.type === 'mousemove') {
          pageX = event.pageX;
        }

        // Set the min size to 10 to account for margin and border or else the group headers don't line up correctly
        var newWidth = Math.max(currentlyResizing.parentWidth + pageX - currentlyResizing.startX, 11);

        newResizing.push({
          id: currentlyResizing.id,
          value: newWidth
        });

        this.setStateWithData({
          resizing: newResizing
        });
      }
    }]);

    return _class;
  }(Base);
};
//# sourceMappingURL=data:application/json;base64,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