'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _utils = require('./utils');

var _utils2 = _interopRequireDefault(_utils);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

exports.default = function (Base) {
  return function (_Base) {
    _inherits(_class, _Base);

    function _class() {
      _classCallCheck(this, _class);

      return _possibleConstructorReturn(this, (_class.__proto__ || Object.getPrototypeOf(_class)).apply(this, arguments));
    }

    _createClass(_class, [{
      key: 'getResolvedState',
      value: function getResolvedState(props, state) {
        var resolvedState = _extends({}, _utils2.default.compactObject(this.state), _utils2.default.compactObject(this.props), _utils2.default.compactObject(state), _utils2.default.compactObject(props));
        return resolvedState;
      }
    }, {
      key: 'getDataModel',
      value: function getDataModel(newState) {
        var _this2 = this;

        var columns = newState.columns,
            _newState$pivotBy = newState.pivotBy,
            pivotBy = _newState$pivotBy === undefined ? [] : _newState$pivotBy,
            data = newState.data,
            pivotIDKey = newState.pivotIDKey,
            pivotValKey = newState.pivotValKey,
            subRowsKey = newState.subRowsKey,
            aggregatedKey = newState.aggregatedKey,
            nestingLevelKey = newState.nestingLevelKey,
            originalKey = newState.originalKey,
            indexKey = newState.indexKey,
            groupedByPivotKey = newState.groupedByPivotKey,
            SubComponent = newState.SubComponent;

        // Determine Header Groups

        var hasHeaderGroups = false;
        columns.forEach(function (column) {
          if (column.columns) {
            hasHeaderGroups = true;
          }
        });

        var columnsWithExpander = [].concat(_toConsumableArray(columns));

        var expanderColumn = columns.find(function (col) {
          return col.expander || col.columns && col.columns.some(function (col2) {
            return col2.expander;
          });
        });
        // The actual expander might be in the columns field of a group column
        if (expanderColumn && !expanderColumn.expander) {
          expanderColumn = expanderColumn.columns.find(function (col) {
            return col.expander;
          });
        }

        // If we have SubComponent's we need to make sure we have an expander column
        if (SubComponent && !expanderColumn) {
          expanderColumn = { expander: true };
          columnsWithExpander = [expanderColumn].concat(_toConsumableArray(columnsWithExpander));
        }

        var makeDecoratedColumn = function makeDecoratedColumn(column) {
          var dcol = void 0;
          if (column.expander) {
            dcol = _extends({}, _this2.props.column, _this2.props.expanderDefaults, column);
          } else {
            dcol = _extends({}, _this2.props.column, column);
          }

          if (typeof dcol.accessor === 'string') {
            var _ret = function () {
              dcol.id = dcol.id || dcol.accessor;
              var accessorString = dcol.accessor;
              dcol.accessor = function (row) {
                return _utils2.default.get(row, accessorString);
              };
              return {
                v: dcol
              };
            }();

            if ((typeof _ret === 'undefined' ? 'undefined' : _typeof(_ret)) === "object") return _ret.v;
          }

          if (dcol.accessor && !dcol.id) {
            console.warn(dcol);
            throw new Error('A column id is required if using a non-string accessor for column above.');
          }

          if (!dcol.accessor) {
            dcol.accessor = function (d) {
              return undefined;
            };
          }

          // Ensure minWidth is not greater than maxWidth if set
          if (dcol.maxWidth < dcol.minWidth) {
            dcol.minWidth = dcol.maxWidth;
          }

          return dcol;
        };

        // Decorate the columns
        var decorateAndAddToAll = function decorateAndAddToAll(col) {
          var decoratedColumn = makeDecoratedColumn(col);
          allDecoratedColumns.push(decoratedColumn);
          return decoratedColumn;
        };
        var allDecoratedColumns = [];
        var decoratedColumns = columnsWithExpander.map(function (column, i) {
          if (column.columns) {
            return _extends({}, column, {
              columns: column.columns.map(decorateAndAddToAll)
            });
          } else {
            return decorateAndAddToAll(column);
          }
        });

        // Build the visible columns, headers and flat column list
        var visibleColumns = decoratedColumns.slice();
        var allVisibleColumns = [];

        visibleColumns = visibleColumns.map(function (column, i) {
          if (column.columns) {
            var visibleSubColumns = column.columns.filter(function (d) {
              return pivotBy.indexOf(d.id) > -1 ? false : _utils2.default.getFirstDefined(d.show, true);
            });
            return _extends({}, column, {
              columns: visibleSubColumns
            });
          }
          return column;
        });

        visibleColumns = visibleColumns.filter(function (column) {
          return column.columns ? column.columns.length : pivotBy.indexOf(column.id) > -1 ? false : _utils2.default.getFirstDefined(column.show, true);
        });

        // Find any custom pivot location
        var pivotIndex = visibleColumns.findIndex(function (col) {
          return col.pivot;
        });

        // Handle Pivot Columns
        if (pivotBy.length) {
          (function () {
            // Retrieve the pivot columns in the correct pivot order
            var pivotColumns = [];
            pivotBy.forEach(function (pivotID) {
              var found = allDecoratedColumns.find(function (d) {
                return d.id === pivotID;
              });
              if (found) {
                pivotColumns.push(found);
              }
            });

            var pivotColumnGroup = {
              header: function header() {
                return _react2.default.createElement(
                  'strong',
                  null,
                  'Group'
                );
              },
              columns: pivotColumns.map(function (col) {
                return _extends({}, _this2.props.pivotDefaults, col, {
                  pivoted: true
                });
              })
            };

            // Place the pivotColumns back into the visibleColumns
            if (pivotIndex >= 0) {
              pivotColumnGroup = _extends({}, visibleColumns[pivotIndex], pivotColumnGroup);
              visibleColumns.splice(pivotIndex, 1, pivotColumnGroup);
            } else {
              visibleColumns.unshift(pivotColumnGroup);
            }
          })();
        }

        // Build Header Groups
        var headerGroups = [];
        var currentSpan = [];

        // A convenience function to add a header and reset the currentSpan
        var addHeader = function addHeader(columns, column) {
          headerGroups.push(_extends({}, _this2.props.column, column, {
            columns: columns
          }));
          currentSpan = [];
        };

        // Build flast list of allVisibleColumns and HeaderGroups
        visibleColumns.forEach(function (column, i) {
          if (column.columns) {
            allVisibleColumns = allVisibleColumns.concat(column.columns);
            if (currentSpan.length > 0) {
              addHeader(currentSpan);
            }
            addHeader(column.columns, column);
            return;
          }
          allVisibleColumns.push(column);
          currentSpan.push(column);
        });
        if (hasHeaderGroups && currentSpan.length > 0) {
          addHeader(currentSpan);
        }

        // Access the data
        var accessRow = function accessRow(d, i) {
          var _row;

          var level = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;

          var row = (_row = {}, _defineProperty(_row, originalKey, d), _defineProperty(_row, indexKey, i), _defineProperty(_row, subRowsKey, d[subRowsKey]), _defineProperty(_row, nestingLevelKey, level), _row);
          allDecoratedColumns.forEach(function (column) {
            if (column.expander) return;
            row[column.id] = column.accessor(d);
          });
          if (row[subRowsKey]) {
            row[subRowsKey] = row[subRowsKey].map(function (d, i) {
              return accessRow(d, i, level + 1);
            });
          }
          return row;
        };
        var resolvedData = data.map(function (d, i) {
          return accessRow(d, i);
        });

        // If pivoting, recursively group the data
        var aggregate = function aggregate(rows) {
          var aggregationValues = {};
          aggregatingColumns.forEach(function (column) {
            var values = rows.map(function (d) {
              return d[column.id];
            });
            aggregationValues[column.id] = column.aggregate(values, rows);
          });
          return aggregationValues;
        };

        // TODO: Make it possible to fabricate nested rows without pivoting
        var aggregatingColumns = allVisibleColumns.filter(function (d) {
          return !d.expander && d.aggregate;
        });
        if (pivotBy.length) {
          (function () {
            var groupRecursively = function groupRecursively(rows, keys) {
              var i = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;

              // This is the last level, just return the rows
              if (i === keys.length) {
                return rows;
              }
              // Group the rows together for this level
              var groupedRows = Object.entries(_utils2.default.groupBy(rows, keys[i])).map(function (_ref) {
                var _ref3;

                var _ref2 = _slicedToArray(_ref, 2),
                    key = _ref2[0],
                    value = _ref2[1];

                return _ref3 = {}, _defineProperty(_ref3, pivotIDKey, keys[i]), _defineProperty(_ref3, pivotValKey, key), _defineProperty(_ref3, keys[i], key), _defineProperty(_ref3, subRowsKey, value), _defineProperty(_ref3, nestingLevelKey, i), _defineProperty(_ref3, groupedByPivotKey, true), _ref3;
              });
              // Recurse into the subRows
              groupedRows = groupedRows.map(function (rowGroup) {
                var _extends2;

                var subRows = groupRecursively(rowGroup[subRowsKey], keys, i + 1);
                return _extends({}, rowGroup, (_extends2 = {}, _defineProperty(_extends2, subRowsKey, subRows), _defineProperty(_extends2, aggregatedKey, true), _extends2), aggregate(subRows));
              });
              return groupedRows;
            };
            resolvedData = groupRecursively(resolvedData, pivotBy);
          })();
        }

        return _extends({}, newState, {
          resolvedData: resolvedData,
          allVisibleColumns: allVisibleColumns,
          headerGroups: headerGroups,
          allDecoratedColumns: allDecoratedColumns,
          hasHeaderGroups: hasHeaderGroups
        });
      }
    }, {
      key: 'getSortedData',
      value: function getSortedData(resolvedState) {
        var manual = resolvedState.manual,
            sorted = resolvedState.sorted,
            filtered = resolvedState.filtered,
            defaultFilterMethod = resolvedState.defaultFilterMethod,
            resolvedData = resolvedState.resolvedData,
            allVisibleColumns = resolvedState.allVisibleColumns,
            allDecoratedColumns = resolvedState.allDecoratedColumns;


        var sortMethodsByColumnID = {};

        allDecoratedColumns.filter(function (col) {
          return col.sortMethod;
        }).forEach(function (col) {
          sortMethodsByColumnID[col.id] = col.sortMethod;
        });

        // Resolve the data from either manual data or sorted data
        return {
          sortedData: manual ? resolvedData : this.sortData(this.filterData(resolvedData, filtered, defaultFilterMethod, allVisibleColumns), sorted, sortMethodsByColumnID)
        };
      }
    }, {
      key: 'fireFetchData',
      value: function fireFetchData() {
        this.props.onFetchData(this.getResolvedState(), this);
      }
    }, {
      key: 'getPropOrState',
      value: function getPropOrState(key) {
        return _utils2.default.getFirstDefined(this.props[key], this.state[key]);
      }
    }, {
      key: 'getStateOrProp',
      value: function getStateOrProp(key) {
        return _utils2.default.getFirstDefined(this.state[key], this.props[key]);
      }
    }, {
      key: 'filterData',
      value: function filterData(data, filtered, defaultFilterMethod, allVisibleColumns) {
        var _this3 = this;

        var filteredData = data;

        if (filtered.length) {
          filteredData = filtered.reduce(function (filteredSoFar, nextFilter) {
            return filteredSoFar.filter(function (row) {
              var column = void 0;

              column = allVisibleColumns.find(function (x) {
                return x.id === nextFilter.id;
              });

              // Don't filter hidden columns or columns that have had their filters disabled
              if (!column || column.filterable === false) {
                return true;
              }

              var filterMethod = column.filterMethod || defaultFilterMethod;

              return filterMethod(nextFilter, row, column);
            });
          }, filteredData);

          // Apply the filter to the subrows if we are pivoting, and then
          // filter any rows without subcolumns because it would be strange to show
          filteredData = filteredData.map(function (row) {
            if (!row[_this3.props.subRowsKey]) {
              return row;
            }
            return _extends({}, row, _defineProperty({}, _this3.props.subRowsKey, _this3.filterData(row[_this3.props.subRowsKey], filtered, defaultFilterMethod, allVisibleColumns)));
          }).filter(function (row) {
            if (!row[_this3.props.subRowsKey]) {
              return true;
            }
            return row[_this3.props.subRowsKey].length > 0;
          });
        }

        return filteredData;
      }
    }, {
      key: 'sortData',
      value: function sortData(data, sorted) {
        var _this4 = this;

        var sortMethodsByColumnID = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

        if (!sorted.length) {
          return data;
        }

        var sortedData = (this.props.orderByMethod || _utils2.default.orderBy)(data, sorted.map(function (sort) {
          // Support custom sorting methods for each column
          if (sortMethodsByColumnID[sort.id]) {
            return function (a, b) {
              return sortMethodsByColumnID[sort.id](a[sort.id], b[sort.id]);
            };
          }
          return function (a, b) {
            return _this4.props.defaultSortMethod(a[sort.id], b[sort.id]);
          };
        }), sorted.map(function (d) {
          return !d.desc;
        }), this.props.indexKey);

        sortedData.forEach(function (row) {
          if (!row[_this4.props.subRowsKey]) {
            return;
          }
          row[_this4.props.subRowsKey] = _this4.sortData(row[_this4.props.subRowsKey], sorted, sortMethodsByColumnID);
        });

        return sortedData;
      }
    }, {
      key: 'getMinRows',
      value: function getMinRows() {
        return _utils2.default.getFirstDefined(this.props.minRows, this.getStateOrProp('pageSize'));
      }

      // User actions

    }, {
      key: 'onPageChange',
      value: function onPageChange(page) {
        var _this5 = this;

        var _props = this.props,
            onPageChange = _props.onPageChange,
            collapseOnPageChange = _props.collapseOnPageChange;


        var newState = { page: page };
        if (collapseOnPageChange) {
          newState.expanded = {};
        }
        this.setStateWithData(newState, function () {
          onPageChange && onPageChange(page);
          _this5.fireFetchData();
        });
      }
    }, {
      key: 'onPageSizeChange',
      value: function onPageSizeChange(newPageSize) {
        var _this6 = this;

        var onPageSizeChange = this.props.onPageSizeChange;

        var _getResolvedState = this.getResolvedState(),
            pageSize = _getResolvedState.pageSize,
            page = _getResolvedState.page;

        // Normalize the page to display


        var currentRow = pageSize * page;
        var newPage = Math.floor(currentRow / newPageSize);

        this.setStateWithData({
          pageSize: newPageSize,
          page: newPage
        }, function () {
          onPageSizeChange && onPageSizeChange(newPageSize, newPage);
          _this6.fireFetchData();
        });
      }
    }, {
      key: 'sortColumn',
      value: function sortColumn(column, additive) {
        var _this7 = this;

        var _getResolvedState2 = this.getResolvedState(),
            sorted = _getResolvedState2.sorted,
            skipNextSort = _getResolvedState2.skipNextSort;

        // we can't stop event propagation from the column resize move handlers
        // attached to the document because of react's synthetic events
        // so we have to prevent the sort function from actually sorting
        // if we click on the column resize element within a header.


        if (skipNextSort) {
          this.setStateWithData({
            skipNextSort: false
          });
          return;
        }

        var onSortedChange = this.props.onSortedChange;


        var newSorted = _utils2.default.clone(sorted || []).map(function (d) {
          d.desc = _utils2.default.isSortingDesc(d);
          return d;
        });
        if (!_utils2.default.isArray(column)) {
          // Single-Sort
          var existingIndex = newSorted.findIndex(function (d) {
            return d.id === column.id;
          });
          if (existingIndex > -1) {
            var existing = newSorted[existingIndex];
            if (existing.desc) {
              if (additive) {
                newSorted.splice(existingIndex, 1);
              } else {
                existing.desc = false;
                newSorted = [existing];
              }
            } else {
              existing.desc = true;
              if (!additive) {
                newSorted = [existing];
              }
            }
          } else {
            if (additive) {
              newSorted.push({
                id: column.id,
                desc: false
              });
            } else {
              newSorted = [{
                id: column.id,
                desc: false
              }];
            }
          }
        } else {
          (function () {
            // Multi-Sort
            var existingIndex = newSorted.findIndex(function (d) {
              return d.id === column[0].id;
            });
            // Existing Sorted Column
            if (existingIndex > -1) {
              var _existing = newSorted[existingIndex];
              if (_existing.desc) {
                if (additive) {
                  newSorted.splice(existingIndex, column.length);
                } else {
                  column.forEach(function (d, i) {
                    newSorted[existingIndex + i].desc = false;
                  });
                }
              } else {
                column.forEach(function (d, i) {
                  newSorted[existingIndex + i].desc = true;
                });
              }
              if (!additive) {
                newSorted = newSorted.slice(existingIndex, column.length);
              }
            } else {
              // New Sort Column
              if (additive) {
                newSorted = newSorted.concat(column.map(function (d) {
                  return {
                    id: d.id,
                    desc: false
                  };
                }));
              } else {
                newSorted = column.map(function (d) {
                  return {
                    id: d.id,
                    desc: false
                  };
                });
              }
            }
          })();
        }

        this.setStateWithData({
          page: !sorted.length && newSorted.length || !additive ? 0 : this.state.page,
          sorted: newSorted
        }, function () {
          onSortedChange && onSortedChange(newSorted, column, additive);
          _this7.fireFetchData();
        });
      }
    }, {
      key: 'filterColumn',
      value: function filterColumn(column, value) {
        var _this8 = this;

        var _getResolvedState3 = this.getResolvedState(),
            filtered = _getResolvedState3.filtered;

        var onFilteredChange = this.props.onFilteredChange;

        // Remove old filter first if it exists

        var newFiltering = (filtered || []).filter(function (x) {
          if (x.id !== column.id) {
            return true;
          }
        });

        if (value !== '') {
          newFiltering.push({
            id: column.id,
            value: value
          });
        }

        this.setStateWithData({
          filtered: newFiltering
        }, function () {
          onFilteredChange && onFilteredChange(newFiltering, column, value);
          _this8.fireFetchData();
        });
      }
    }, {
      key: 'resizeColumnStart',
      value: function resizeColumnStart(column, event, isTouch) {
        var _this9 = this;

        var parentWidth = event.target.parentElement.getBoundingClientRect().width;

        var pageX = void 0;
        if (isTouch) {
          pageX = event.changedTouches[0].pageX;
        } else {
          pageX = event.pageX;
        }

        this.setStateWithData({
          currentlyResizing: {
            id: column.id,
            startX: pageX,
            parentWidth: parentWidth
          }
        }, function () {
          if (isTouch) {
            document.addEventListener('touchmove', _this9.resizeColumnMoving);
            document.addEventListener('touchcancel', _this9.resizeColumnEnd);
            document.addEventListener('touchend', _this9.resizeColumnEnd);
          } else {
            document.addEventListener('mousemove', _this9.resizeColumnMoving);
            document.addEventListener('mouseup', _this9.resizeColumnEnd);
            document.addEventListener('mouseleave', _this9.resizeColumnEnd);
          }
        });
      }
    }, {
      key: 'resizeColumnEnd',
      value: function resizeColumnEnd(event) {
        var isTouch = event.type === 'touchend' || event.type === 'touchcancel';

        if (isTouch) {
          document.removeEventListener('touchmove', this.resizeColumnMoving);
          document.removeEventListener('touchcancel', this.resizeColumnEnd);
          document.removeEventListener('touchend', this.resizeColumnEnd);
        }

        // If its a touch event clear the mouse one's as well because sometimes
        // the mouseDown event gets called as well, but the mouseUp event doesn't
        document.removeEventListener('mousemove', this.resizeColumnMoving);
        document.removeEventListener('mouseup', this.resizeColumnEnd);
        document.removeEventListener('mouseleave', this.resizeColumnEnd);

        // The touch events don't propagate up to the sorting's onMouseDown event so
        // no need to prevent it from happening or else the first click after a touch
        // event resize will not sort the column.
        if (!isTouch) {
          this.setStateWithData({
            skipNextSort: true,
            currentlyResizing: false
          });
        }
      }
    }, {
      key: 'resizeColumnMoving',
      value: function resizeColumnMoving(event) {
        var onResizedChange = this.props.onResizedChange;

        var _getResolvedState4 = this.getResolvedState(),
            resized = _getResolvedState4.resized,
            currentlyResizing = _getResolvedState4.currentlyResizing;

        // Delete old value


        var newResized = resized.filter(function (x) {
          return x.id !== currentlyResizing.id;
        });

        var pageX = void 0;

        if (event.type === 'touchmove') {
          pageX = event.changedTouches[0].pageX;
        } else if (event.type === 'mousemove') {
          pageX = event.pageX;
        }

        // Set the min size to 10 to account for margin and border or else the group headers don't line up correctly
        var newWidth = Math.max(currentlyResizing.parentWidth + pageX - currentlyResizing.startX, 11);

        newResized.push({
          id: currentlyResizing.id,
          value: newWidth
        });

        this.setStateWithData({
          resized: newResized
        }, function () {
          onResizedChange && onResizedChange(newResized, event);
        });
      }
    }]);

    return _class;
  }(Base);
};
//# sourceMappingURL=data:application/json;base64,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