'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol ? "symbol" : typeof obj; };

var _lodash = require('lodash');

var _themable = require('./themable');

var _themable2 = _interopRequireDefault(_themable);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function registerTheme(theme) {
  var _theme = theme || ThemeManager.globalTheme;

  if ((this || {}).themes) this.themes[_theme] = this.themes[_theme] || {};
  ThemeManager.themeVariables[_theme] = ThemeManager.themeVariables[_theme] || {};
}

function registerProperties(stylesObj) {
  var _this = this;

  if (!stylesObj) return {};

  var properties = {};

  var _loop = function _loop(key) {
    properties[key] = {
      configurable: true,
      get: function get() {
        return _this.getPropertyFromTheme(_this.theme, key);
      }
    };
  };

  for (var key in stylesObj) {
    _loop(key);
  }

  Object.defineProperties(stylesObj, properties);
  (0, _lodash.merge)(this.styles, stylesObj);

  return stylesObj;
}

function isVariable(key) {
  return typeof key === 'string' && key[0] === '$';
}

function fixVariableName(variableName) {
  return isVariable(variableName) ? variableName.slice(1) : variableName;
}

function fixVariableNames(variablesObject) {
  if (!variablesObject) return {};

  var fixedVariables = {};
  for (var key in variablesObject) {
    fixedVariables[fixVariableName(key)] = variablesObject[key];
  }return fixedVariables;
}

function addStyle(theme, stylesObj) {
  var _theme = theme || ThemeManager.globalTheme;

  registerTheme.bind(this)(_theme);
  return (0, _lodash.merge)(this.themes[_theme], stylesObj);
}

function addThemeVariables(theme, variables) {
  var _theme = theme || ThemeManager.globalTheme;
  if (!_theme) return;

  registerTheme(_theme);
  Object.assign(ThemeManager.themeVariables[_theme], fixVariableNames(variables));
}

function parseStyle(theme, style) {
  if (isVariable(style)) return ThemeManager.getVariable(theme, style);
  if ((typeof style === 'undefined' ? 'undefined' : _typeof(style)) !== 'object') return style;

  var _theme = theme || ThemeManager.globalTheme;
  var parsedStyle = (0, _lodash.cloneDeep)(style);
  for (var key in parsedStyle) {
    parsedStyle[key] = parseStyle(_theme, parsedStyle[key]);
  }return parsedStyle;
}

var ThemeManager = function () {
  function ThemeManager(config) {
    _classCallCheck(this, ThemeManager);

    this.config = Object.assign({}, ThemeManager._config, config || {});
    this.styles = {};
    this.themes = {};
    this.theme = ThemeManager.globalTheme;

    registerTheme.bind(this)(ThemeManager.globalTheme);
  }

  _createClass(ThemeManager, [{
    key: 'create',
    value: function create() {
      var _this2 = this;

      var themes = arguments.length <= 0 || arguments[0] === undefined ? [] : arguments[0];
      var styleObj = arguments[1];

      var _themes = void 0;
      var _styleObj = void 0;

      // allow to not specify first argument (considering theme as the global one)
      if (!Array.isArray(arguments[0]) && _typeof(arguments[0]) === 'object') {
        _themes = [ThemeManager.globalTheme];
        _styleObj = arguments[0];
      } else {
        _themes = Array.isArray(themes) ? themes : [themes];
        _styleObj = styleObj || {};
      }

      // create styles for each specified theme
      _themes.map(function (theme) {
        return addStyle.bind(_this2)(theme, _styleObj);
      });

      registerProperties.bind(this)(_styleObj);
      return this.styles;
    }
  }, {
    key: 'getPropertyFromTheme',
    value: function getPropertyFromTheme(theme, propertyName) {
      var _theme = void 0;
      var value = void 0;

      if ((0, _lodash.get)(this.themes[theme], propertyName) !== undefined) {
        _theme = theme;
        value = (0, _lodash.get)(this.themes[theme], propertyName);
      } else if (ThemeManager._config.fallbackToGlobalTheme && (0, _lodash.get)(this.themes[ThemeManager.globalTheme], propertyName) !== undefined) {
        _theme = ThemeManager.globalTheme;
        value = (0, _lodash.get)(this.themes[ThemeManager.globalTheme], propertyName);
      }

      return parseStyle(_theme, value);
    }
  }, {
    key: 'setTheme',
    value: function setTheme(theme) {
      var _theme = theme || ThemeManager.globalTheme;
      if (this.theme === _theme) return _theme;

      this.theme = _theme;
      this.styles = this.getStyles(this.theme); // ThemeManager._config.StyleSheet.create(styles);

      return this.theme;
    }
  }, {
    key: 'getStyles',
    value: function getStyles(theme) {
      var _theme = theme || this.theme;
      var _globalStyles = ThemeManager._config.fallbackToGlobalTheme && this.themes[ThemeManager.globalTheme] || {};

      this.setTheme(_theme);
      return parseStyle(_theme, (0, _lodash.merge)({}, _globalStyles, this.themes[_theme]));
    }
  }, {
    key: 'attach',
    value: function attach(component) {
      console.warn('DEPRECATED: themeManager.attach(Component). Use themable(Component) instead.');
      return (0, _themable2.default)(component);
    }
  }], [{
    key: 'config',
    value: function config(_config) {
      if (_config) ThemeManager._config = Object.assign({}, ThemeManager._config, _config);
    }
  }, {
    key: 'addVariables',
    value: function addVariables() {
      var themes = arguments.length <= 0 || arguments[0] === undefined ? [] : arguments[0];
      var variables = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

      var _themes = void 0;
      var _variables = void 0;

      // allow to not specify first argument (will consider variables as global ones)
      if (!Array.isArray(arguments[0]) && _typeof(arguments[0]) === 'object') {
        _themes = [ThemeManager.globalTheme];
        _variables = arguments[0] || {};
      } else {
        _themes = (Array.isArray(themes) ? themes : [themes]).filter(Boolean);
        _variables = variables || {};
      }

      // add variables for each specified theme
      _themes.map(function (theme) {
        return addThemeVariables(theme, _variables);
      });
    }
  }, {
    key: 'getVariable',
    value: function getVariable(theme, variableName) {
      var _variableName = variableName[0] === '$' ? variableName.slice(1) : variableName;

      var value = theme && (0, _lodash.get)(this.themeVariables[theme], _variableName) || ThemeManager._config.fallbackToGlobalTheme && (0, _lodash.get)(this.themeVariables[ThemeManager.globalTheme], _variableName);

      return value === undefined ? '$' + _variableName : value;
    }
  }]);

  return ThemeManager;
}();

ThemeManager.globalTheme = 'default';
ThemeManager.themeVariables = {};
ThemeManager._config = {
  StyleSheet: null, // { StyleSheet } from 'react-native' or a custom one like EStyleSheet
  fallbackToGlobalTheme: true
};
exports.default = ThemeManager;
;