"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var clsx_1 = __importDefault(require("clsx"));
var date_utils_1 = require("@wojtekmaj/date-utils");
var dates_js_1 = require("../shared/dates.js");
var utils_js_1 = require("../shared/utils.js");
function AmPm(_a) {
    var ariaLabel = _a.ariaLabel, autoFocus = _a.autoFocus, className = _a.className, disabled = _a.disabled, inputRef = _a.inputRef, locale = _a.locale, maxTime = _a.maxTime, minTime = _a.minTime, onChange = _a.onChange, onKeyDown = _a.onKeyDown, required = _a.required, value = _a.value;
    var amDisabled = minTime ? (0, dates_js_1.convert24to12)((0, date_utils_1.getHours)(minTime))[1] === 'pm' : false;
    var pmDisabled = maxTime ? (0, dates_js_1.convert24to12)((0, date_utils_1.getHours)(maxTime))[1] === 'am' : false;
    var name = 'amPm';
    var _b = (0, utils_js_1.getAmPmLabels)(locale), amLabel = _b[0], pmLabel = _b[1];
    return (react_1.default.createElement("select", { "aria-label": ariaLabel, autoFocus: autoFocus, className: (0, clsx_1.default)("".concat(className, "__input"), "".concat(className, "__").concat(name)), "data-input": "true", "data-select": "true", disabled: disabled, name: name, onChange: onChange, onKeyDown: onKeyDown, ref: inputRef, required: required, value: value !== null ? value : '' },
        !value && react_1.default.createElement("option", { value: "" }, "--"),
        react_1.default.createElement("option", { disabled: amDisabled, value: "am" }, amLabel),
        react_1.default.createElement("option", { disabled: pmDisabled, value: "pm" }, pmLabel)));
}
exports.default = AmPm;
