import React from 'react';
import makeEventProps from 'make-event-props';
import Clock from 'react-clock';
import type { ReactNodeArray } from 'prop-types';
import type { ClassName, CloseReason, Detail, LooseValue, OpenReason, Value } from './shared/types.js';
type Icon = React.ReactElement | ReactNodeArray | null | string | number | boolean;
type IconOrRenderFunction = Icon | React.ComponentType | React.ReactElement;
type ClockProps = Omit<React.ComponentPropsWithoutRef<typeof Clock>, 'value'>;
type EventProps = ReturnType<typeof makeEventProps>;
export type TimePickerProps = {
    amPmAriaLabel?: string;
    autoFocus?: boolean;
    className?: ClassName;
    clearAriaLabel?: string;
    clearIcon?: IconOrRenderFunction | null;
    clockAriaLabel?: string;
    clockClassName?: ClassName;
    clockIcon?: IconOrRenderFunction | null;
    closeClock?: boolean;
    'data-testid'?: string;
    disableClock?: boolean;
    disabled?: boolean;
    format?: string;
    hourAriaLabel?: string;
    hourPlaceholder?: string;
    id?: string;
    isOpen?: boolean;
    locale?: string;
    maxDetail?: Detail;
    maxTime?: string;
    minTime?: string;
    minuteAriaLabel?: string;
    minutePlaceholder?: string;
    name?: string;
    nativeInputAriaLabel?: string;
    onChange?: (value: Value) => void;
    onClockClose?: () => void;
    onClockOpen?: () => void;
    onFocus?: (event: React.FocusEvent<HTMLDivElement>) => void;
    onInvalidChange?: () => void;
    openClockOnFocus?: boolean;
    portalContainer?: HTMLElement | null;
    required?: boolean;
    secondAriaLabel?: string;
    secondPlaceholder?: string;
    shouldCloseClock?: ({ reason }: {
        reason: CloseReason;
    }) => boolean;
    shouldOpenClock?: ({ reason }: {
        reason: OpenReason;
    }) => boolean;
    value?: LooseValue;
} & ClockProps & Omit<EventProps, 'onChange' | 'onFocus'>;
declare const TimePicker: React.FC<TimePickerProps>;
export default TimePicker;
