'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactDom = require('react-dom');

var _reactDom2 = _interopRequireDefault(_reactDom);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Portal = function (_Component) {
  _inherits(Portal, _Component);

  function Portal() {
    _classCallCheck(this, Portal);

    return _possibleConstructorReturn(this, Object.getPrototypeOf(Portal).apply(this, arguments));
  }

  _createClass(Portal, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      this._renderOverlay();
    }
  }, {
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      if (this._overlayTarget && nextProps.container !== this.props.container) {
        this._portalContainerNode.removeChild(this._overlayTarget);
        this._portalContainerNode = getContainer(nextProps.container);
        this._portalContainerNode.appendChild(this._overlayTarget);
      }
    }
  }, {
    key: 'componentDidUpdate',
    value: function componentDidUpdate() {
      this._renderOverlay();
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      this._unrenderOverlay();
      this._unmountOverlayTarget();
    }
  }, {
    key: '_mountOverlayTarget',
    value: function _mountOverlayTarget() {
      if (!this._overlayTarget) {
        this._overlayTarget = document.createElement('div');
        this._portalContainerNode = getContainer(this.props.container);
        this._portalContainerNode.appendChild(this._overlayTarget);
      }
    }
  }, {
    key: '_unmountOverlayTarget',
    value: function _unmountOverlayTarget() {
      if (this._overlayTarget) {
        this._portalContainerNode.removeChild(this._overlayTarget);
        this._overlayTarget = null;
      }
      this._portalContainerNode = null;
    }
  }, {
    key: '_renderOverlay',
    value: function _renderOverlay() {
      var overlay = !this.props.children ? null : _react2.default.Children.only(this.props.children);

      if (overlay !== null) {
        if (this.props.lockBody) document.body.style.overflow = 'hidden';
        this._mountOverlayTarget();
        this._overlayInstance = _reactDom2.default.unstable_renderSubtreeIntoContainer(this, overlay, this._overlayTarget);
      } else {
        this._unrenderOverlay();
        this._unmountOverlayTarget();
      }
    }
  }, {
    key: '_unrenderOverlay',
    value: function _unrenderOverlay() {
      if (this._overlayTarget) {
        if (this.props.lockBody) document.body.style.overflow = 'scroll';
        _reactDom2.default.unmountComponentAtNode(this._overlayTarget);
        this._overlayInstance = null;
      }
    }
  }, {
    key: 'getMountNode',
    value: function getMountNode() {
      return this._overlayTarget;
    }
  }, {
    key: 'getOverlayDOMNode',
    value: function getOverlayDOMNode() {
      if (!this.isMounted()) {
        throw new Error('getOverlayDOMNode(): A component must be mounted to have a DOM node.');
      }

      if (this._overlayInstance) {
        if (this._overlayInstance.getWrappedDOMNode) {
          return this._overlayInstance.getWrappedDOMNode();
        } else {
          return _reactDom2.default.findDOMNode(this._overlayInstance);
        }
      }

      return null;
    }
  }, {
    key: 'render',
    value: function render() {
      return null;
    }
  }]);

  return Portal;
}(_react.Component);

Portal.propTypes = {
  children: _react.PropTypes.any,
  container: _react.PropTypes.any,
  lockBody: _react.PropTypes.bool
};
Portal.defaultProps = {
  lockBody: true
};


function getContainer(container) {
  var _container = typeof container === 'function' ? container() : container;
  return _reactDom2.default.findDOMNode(_container) || document.body;
}

exports.default = Portal;