import { themr } from 'react-css-themr';
import { LIST } from '../identifiers.js';
import { Avatar } from '../avatar';
import { Checkbox } from '../checkbox';
import { ListItemText } from './ListItemText.js';
import { ListItemAction } from './ListItemAction.js';
import { ListSubHeader } from './ListSubHeader.js';
import { ListDivider } from './ListDivider.js';
import { listFactory } from './List.js';
import { listItemFactory } from './ListItem.js';
import { listCheckboxFactory } from './ListCheckbox.js';
import { listItemActionsFactory } from './ListItemActions.js';
import { listItemContentFactory } from './ListItemContent.js';
import { listItemLayoutFactory } from './ListItemLayout.js';
import themedRippleFactory from '../ripple';
import theme from './theme.scss';

const applyTheme = (Component) => themr(LIST, theme)(Component);
const ripple = themedRippleFactory({ centered: false, listItemIgnore: true });
const ThemedListItemAction = applyTheme(ListItemAction);
const ThemedListSubHeader = applyTheme(ListSubHeader);
const ThemedListItemText = applyTheme(ListItemText);
const ThemedListDivider = applyTheme(ListDivider);
const ThemedListItemContent = applyTheme(listItemContentFactory(ThemedListItemText));
const ThemedListItemActions = applyTheme(listItemActionsFactory(ThemedListItemAction));
const ThemedListItemLayout = applyTheme(listItemLayoutFactory(Avatar, ThemedListItemContent, ThemedListItemActions));
const ThemedListCheckbox = applyTheme(listCheckboxFactory(Checkbox, ThemedListItemContent));
const ThemedListItem = applyTheme(listItemFactory(ripple, ThemedListItemLayout, ThemedListItemContent));
const ThemedList = applyTheme(listFactory(ThemedListItem));

export { ThemedListItemActions as ListItemActions };
export { ThemedListItemContent as ListItemContent };
export { ThemedListItemLayout as ListItemLayout };
export { ThemedListSubHeader as ListSubHeader };
export { ThemedListItemText as ListItemText };
export { ThemedListCheckbox as ListCheckbox };
export { ThemedListDivider as ListDivider };
export { ThemedListItem as ListItem };
export { ThemedList as List };
