'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Checkbox = exports.checkboxFactory = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _classnames2 = require('classnames');

var _classnames3 = _interopRequireDefault(_classnames2);

var _reactCssThemr = require('react-css-themr');

var _identifiers = require('../identifiers.js');

var _Ripple = require('../ripple/Ripple.js');

var _Ripple2 = _interopRequireDefault(_Ripple);

var _Check = require('./Check.js');

var _Check2 = _interopRequireDefault(_Check);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var factory = function factory(Check) {
  var Checkbox = function (_Component) {
    _inherits(Checkbox, _Component);

    function Checkbox() {
      var _ref;

      var _temp, _this, _ret;

      _classCallCheck(this, Checkbox);

      for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = Checkbox.__proto__ || Object.getPrototypeOf(Checkbox)).call.apply(_ref, [this].concat(args))), _this), _this.handleToggle = function (event) {
        if (event.pageX !== 0 && event.pageY !== 0) _this.blur();
        if (!_this.props.disabled && _this.props.onChange) {
          _this.props.onChange(!_this.props.checked, event);
        }
      }, _temp), _possibleConstructorReturn(_this, _ret);
    }

    _createClass(Checkbox, [{
      key: 'blur',
      value: function blur() {
        this.inputNode && this.inputNode.blur();
      }
    }, {
      key: 'focus',
      value: function focus() {
        this.inputNode && this.inputNode.focus();
      }
    }, {
      key: 'render',
      value: function render() {
        var _this2 = this;

        var _props = this.props,
            checked = _props.checked,
            children = _props.children,
            disabled = _props.disabled,
            label = _props.label,
            name = _props.name,
            style = _props.style,
            onChange = _props.onChange,
            onMouseEnter = _props.onMouseEnter,
            onMouseLeave = _props.onMouseLeave,
            theme = _props.theme,
            others = _objectWithoutProperties(_props, ['checked', 'children', 'disabled', 'label', 'name', 'style', 'onChange', 'onMouseEnter', 'onMouseLeave', 'theme']);

        var className = (0, _classnames3.default)(theme.field, _defineProperty({}, theme.disabled, this.props.disabled), this.props.className);

        return _react2.default.createElement(
          'label',
          {
            'data-react-toolbox': 'checkbox',
            className: className,
            onMouseEnter: onMouseEnter,
            onMouseLeave: onMouseLeave
          },
          _react2.default.createElement('input', _extends({}, others, {
            checked: checked,
            className: theme.input,
            disabled: disabled,
            name: name,
            onChange: function onChange() {},
            onClick: this.handleToggle,
            ref: function ref(node) {
              _this2.inputNode = node;
            },
            type: 'checkbox'
          })),
          _react2.default.createElement(Check, {
            checked: checked,
            disabled: disabled,
            rippleClassName: theme.ripple,
            style: style,
            theme: theme
          }),
          label ? _react2.default.createElement(
            'span',
            { 'data-react-toolbox': 'label', className: theme.text },
            label
          ) : null,
          children
        );
      }
    }]);

    return Checkbox;
  }(_react.Component);

  Checkbox.propTypes = {
    checked: _react.PropTypes.bool,
    children: _react.PropTypes.node,
    className: _react.PropTypes.string,
    disabled: _react.PropTypes.bool,
    label: _react.PropTypes.oneOfType([_react.PropTypes.string, _react.PropTypes.node]),
    name: _react.PropTypes.string,
    onChange: _react.PropTypes.func,
    onMouseEnter: _react.PropTypes.func,
    onMouseLeave: _react.PropTypes.func,
    style: _react.PropTypes.object,
    theme: _react.PropTypes.shape({
      disabled: _react.PropTypes.string,
      field: _react.PropTypes.string,
      input: _react.PropTypes.string,
      ripple: _react.PropTypes.string
    })
  };
  Checkbox.defaultProps = {
    checked: false,
    className: '',
    disabled: false
  };


  return Checkbox;
};

var Check = (0, _Check2.default)((0, _Ripple2.default)({ centered: true, spread: 2.6 }));
var Checkbox = factory(Check);
exports.default = (0, _reactCssThemr.themr)(_identifiers.CHECKBOX)(Checkbox);
exports.checkboxFactory = factory;
exports.Checkbox = Checkbox;