import * as React from 'react';
export declare type IdSourceType = {
    value: number;
    prefix: string;
    uid: (item: any, index?: number) => string;
};
export declare const createSource: (prefix?: string) => IdSourceType;
export interface UIDProps {
    name?: (n: string | number) => string;
    idSource?: IdSourceType;
    children: (id: string, uid: (item: any, index?: number) => string) => React.ReactNode;
}
export declare let counter: IdSourceType;
export declare const source: React.Context<IdSourceType>;
export declare const lastUsed: React.Context<string>;
export declare const getId: (source: IdSourceType) => number;
export declare const getPrefix: (source?: IdSourceType) => string;
export declare class UID extends React.Component<UIDProps> {
    state: {
        quartz: IdSourceType;
        prefix: string;
        id: number;
    };
    prefixId(id: number | string): string;
    uid: (item: any) => string;
    render(): React.ReactNode;
}
export declare const UIDReset: React.SFC;
export declare const UIDFork: React.SFC;
export declare const UIDConsumer: React.SFC<UIDProps>;
