var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import * as React from 'react';
import { generateUID } from "./uid";
export var createSource = function (prefix) {
    if (prefix === void 0) { prefix = ''; }
    return ({
        value: 1,
        prefix: prefix,
        uid: generateUID()
    });
};
export var counter = createSource();
export var source = React.createContext(createSource());
export var lastUsed = React.createContext("");
export var getId = function (source) { return source.value++; };
export var getPrefix = function (source) { return source ? source.prefix : ''; };
var UID = (function (_super) {
    __extends(UID, _super);
    function UID() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.state = {
            quartz: _this.props.idSource || counter,
            prefix: getPrefix(_this.props.idSource),
            id: getId(_this.props.idSource || counter)
        };
        _this.uid = function (item) { return _this.prefixId(_this.state.quartz.uid(item)); };
        return _this;
    }
    UID.prototype.prefixId = function (id) {
        var uid = (this.state.prefix + id);
        return String(this.props.name ? this.props.name(uid) : uid);
    };
    UID.prototype.render = function () {
        var children = this.props.children;
        var id = this.state.id;
        return children(this.prefixId(id), this.uid);
    };
    return UID;
}(React.Component));
export { UID };
export var UIDReset = function (_a) {
    var children = _a.children;
    return (React.createElement(source.Provider, { value: createSource() }, children));
};
export var UIDFork = function (_a) {
    var children = _a.children;
    return (React.createElement(UIDConsumer, null, function (id) { return (React.createElement(source.Provider, { value: createSource(id + '-') }, children)); }));
};
export var UIDConsumer = function (_a) {
    var name = _a.name, children = _a.children;
    return (React.createElement(source.Consumer, null, function (value) { return (React.createElement(UID, { name: name, idSource: value, children: children })); }));
};
