import * as React from "react";
import { counter, getId, getPrefix, source } from "./context";
var generateUID = function (context) {
    var quartz = context || counter;
    var prefix = getPrefix(quartz);
    var id = getId(quartz);
    var uid = prefix + id;
    var gen = function (item) { return uid + quartz.uid(item); };
    return { uid: uid, gen: gen };
};
var useUIDState = function () {
    if (process.env.NODE_ENV !== "production") {
        if (!('useContext' in React)) {
            throw new Error('Hooks API requires React 16.7+');
        }
    }
    return React.useState(generateUID(React.useContext(source)));
};
export var useUID = function () {
    var uid = useUIDState()[0].uid;
    return uid;
};
export var useUIDSeed = function () {
    var gen = useUIDState()[0].gen;
    return gen;
};
