"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var React = require("react");
var uid_1 = require("./uid");
exports.createSource = function (prefix) {
    if (prefix === void 0) { prefix = ''; }
    return ({
        value: 1,
        prefix: prefix,
        uid: uid_1.generateUID()
    });
};
exports.counter = exports.createSource();
exports.source = React.createContext(exports.createSource());
exports.lastUsed = React.createContext("");
exports.getId = function (source) { return source.value++; };
exports.getPrefix = function (source) { return source ? source.prefix : ''; };
