"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var React = require("react");
var context_1 = require("./context");
var generateUID = function (context) {
    var quartz = context || context_1.counter;
    var prefix = context_1.getPrefix(quartz);
    var id = context_1.getId(quartz);
    var uid = prefix + id;
    var gen = function (item) { return uid + quartz.uid(item); };
    return { uid: uid, gen: gen };
};
var useUIDState = function () {
    if (process.env.NODE_ENV !== "production") {
        if (!('useContext' in React)) {
            throw new Error('Hooks API requires React 16.7+');
        }
    }
    return React.useState(generateUID(React.useContext(context_1.source)));
};
exports.useUID = function () {
    var uid = useUIDState()[0].uid;
    return uid;
};
exports.useUIDSeed = function () {
    var gen = useUIDState()[0].gen;
    return gen;
};
