"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateUID = function () {
    var counter = 1;
    var map = new WeakMap();
    var uid = function (item, index) {
        if (typeof item === 'number' ||
            typeof item === 'string') {
            return index ? "idx-" + index : "val-" + item;
        }
        if (!map.has(item)) {
            map.set(item, counter++);
            return uid(item);
        }
        return 'uid' + map.get(item);
    };
    return uid;
};
