"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UID = void 0;
var tslib_1 = require("tslib");
var React = require("react");
var context_1 = require("./context");
// --------------------------------------------
var prefixId = function (id, prefix, name) {
    var uid = (prefix + id);
    return String(name ? name(uid) : uid);
};
/**
 * @deprecated
 * UID in form of renderProps (not SSR friendly)
 * @see https://github.com/thearnica/react-uid#react-components
 * @example
 * // get UID to connect label to input
 * <UID>
 *   {(id)} => <label htmlFor={id}><input id={id}/>}
 * </UID>
 *
 * // get uid to generate uid for a keys in a list
 * <UID>
 *   {(, uid)} => items.map(item => <li key={uid(item) />)}
 * </UID>
 */
var UID = /** @class */ (function (_super) {
    tslib_1.__extends(UID, _super);
    function UID() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.state = {
            quartz: _this.props.idSource || context_1.counter,
            prefix: context_1.getPrefix(_this.props.idSource),
            id: context_1.getId(_this.props.idSource || context_1.counter)
        };
        _this.uid = function (item) { return prefixId(_this.state.id + '-' + _this.state.quartz.uid(item), _this.state.prefix, _this.props.name); };
        return _this;
    }
    UID.prototype.render = function () {
        var _a = this.props, children = _a.children, name = _a.name;
        var _b = this.state, id = _b.id, prefix = _b.prefix;
        return children(prefixId(id, prefix, name), this.uid);
    };
    return UID;
}(React.Component));
exports.UID = UID;
