"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.attachSharedListeners = void 0;
var globals_1 = require("./globals");
var constants_1 = require("./constants");
var manage_subscribers_1 = require("./manage-subscribers");
var socket_io_1 = require("./socket-io");
var bindMessageHandler = function (webSocketInstance, url) {
    webSocketInstance.onmessage = function (message) {
        manage_subscribers_1.getSubscribers(url).forEach(function (subscriber) {
            if (subscriber.optionsRef.current.onMessage) {
                subscriber.optionsRef.current.onMessage(message);
            }
            if (typeof subscriber.optionsRef.current.filter === 'function' &&
                subscriber.optionsRef.current.filter(message) !== true) {
                return;
            }
            subscriber.setLastMessage(message);
        });
    };
};
var bindOpenHandler = function (webSocketInstance, url) {
    webSocketInstance.onopen = function (event) {
        manage_subscribers_1.getSubscribers(url).forEach(function (subscriber) {
            subscriber.reconnectCount.current = 0;
            if (subscriber.optionsRef.current.onOpen) {
                subscriber.optionsRef.current.onOpen(event);
            }
            subscriber.setReadyState(constants_1.ReadyState.OPEN);
        });
    };
};
var bindCloseHandler = function (webSocketInstance, url) {
    if (webSocketInstance instanceof WebSocket) {
        webSocketInstance.onclose = function (event) {
            manage_subscribers_1.getSubscribers(url).forEach(function (subscriber) {
                if (subscriber.optionsRef.current.onClose) {
                    subscriber.optionsRef.current.onClose(event);
                }
                subscriber.setReadyState(constants_1.ReadyState.CLOSED);
            });
            delete globals_1.sharedWebSockets[url];
            manage_subscribers_1.getSubscribers(url).forEach(function (subscriber) {
                var _a, _b;
                if (subscriber.optionsRef.current.shouldReconnect &&
                    subscriber.optionsRef.current.shouldReconnect(event)) {
                    var reconnectAttempts = (_a = subscriber.optionsRef.current.reconnectAttempts) !== null && _a !== void 0 ? _a : constants_1.DEFAULT_RECONNECT_LIMIT;
                    if (subscriber.reconnectCount.current < reconnectAttempts) {
                        setTimeout(function () {
                            subscriber.reconnectCount.current++;
                            subscriber.reconnect.current();
                        }, (_b = subscriber.optionsRef.current.reconnectInterval) !== null && _b !== void 0 ? _b : constants_1.DEFAULT_RECONNECT_INTERVAL_MS);
                    }
                    else {
                        subscriber.optionsRef.current.onReconnectStop && subscriber.optionsRef.current.onReconnectStop(subscriber.optionsRef.current.reconnectAttempts);
                        console.warn("Max reconnect attempts of " + reconnectAttempts + " exceeded");
                    }
                }
            });
        };
    }
};
var bindErrorHandler = function (webSocketInstance, url) {
    webSocketInstance.onerror = function (error) {
        manage_subscribers_1.getSubscribers(url).forEach(function (subscriber) {
            if (subscriber.optionsRef.current.onError) {
                subscriber.optionsRef.current.onError(error);
            }
            if (constants_1.isEventSourceSupported && webSocketInstance instanceof EventSource) {
                subscriber.optionsRef.current.onClose && subscriber.optionsRef.current.onClose(__assign(__assign({}, error), { code: 1006, reason: "An error occurred with the EventSource: " + error, wasClean: false }));
                subscriber.setReadyState(constants_1.ReadyState.CLOSED);
            }
        });
        if (constants_1.isEventSourceSupported && webSocketInstance instanceof EventSource) {
            webSocketInstance.close();
        }
    };
};
exports.attachSharedListeners = function (webSocketInstance, url, optionsRef, sendMessage) {
    var interval;
    if (optionsRef.current.fromSocketIO) {
        interval = socket_io_1.setUpSocketIOPing(sendMessage);
    }
    bindMessageHandler(webSocketInstance, url);
    bindCloseHandler(webSocketInstance, url);
    bindOpenHandler(webSocketInstance, url);
    bindErrorHandler(webSocketInstance, url);
    return function () {
        if (interval)
            clearInterval(interval);
    };
};
//# sourceMappingURL=attach-shared-listeners.js.map