"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.removeSubscriber = exports.addSubscriber = exports.hasSubscribers = exports.getSubscribers = void 0;
var subscribers = {};
var EMPTY_LIST = [];
exports.getSubscribers = function (url) {
    if (exports.hasSubscribers(url)) {
        return Array.from(subscribers[url]);
    }
    return EMPTY_LIST;
};
exports.hasSubscribers = function (url) {
    var _a;
    return ((_a = subscribers[url]) === null || _a === void 0 ? void 0 : _a.size) > 0;
};
exports.addSubscriber = function (url, subscriber) {
    subscribers[url] = subscribers[url] || new Set();
    subscribers[url].add(subscriber);
};
exports.removeSubscriber = function (url, subscriber) {
    subscribers[url].delete(subscriber);
};
//# sourceMappingURL=manage-subscribers.js.map