import { useCallback, useState } from 'react';
import useMountedState from './useMountedState';
export default function useAsyncFn(fn, deps, initialState) {
    if (deps === void 0) { deps = []; }
    if (initialState === void 0) { initialState = { loading: false }; }
    var _a = useState(initialState), state = _a[0], set = _a[1];
    var isMounted = useMountedState();
    var callback = useCallback(function () {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        set({ loading: true });
        return fn.apply(void 0, args).then(function (value) {
            isMounted() && set({ value: value, loading: false });
            return value;
        }, function (error) {
            isMounted() && set({ error: error, loading: false });
            return error;
        });
    }, deps);
    return [state, callback];
}
