import { useEffect, useRef } from 'react';
import isEqual from 'react-fast-compare';
var isPrimitive = function (val) { return val !== Object(val); };
var useDeepCompareEffect = function (effect, deps) {
    if (process.env.NODE_ENV !== 'production') {
        if (!deps || !deps.length) {
            console.warn('`useDeepCompareEffect` should not be used with no dependencies. Use React.useEffect instead.');
        }
        if (deps.every(isPrimitive)) {
            console.warn('`useDeepCompareEffect` should not be used with dependencies that are all primitive values. Use React.useEffect instead.');
        }
    }
    var ref = useRef(undefined);
    if (!isEqual(deps, ref.current)) {
        ref.current = deps;
    }
    useEffect(effect, ref.current);
};
export default useDeepCompareEffect;
