import { useEffect } from 'react';
import { isClient } from './util';
var defaultTarget = isClient ? window : null;
var useEvent = function (name, handler, target, options) {
    if (target === void 0) { target = defaultTarget; }
    useEffect(function () {
        if (!handler) {
            return;
        }
        if (!target) {
            return;
        }
        var fn = target.addEventListener || target.on;
        fn.call(target, name, handler, options);
        return function () {
            var cleanFn = target.removeEventListener || target.off;
            cleanFn.call(target, name, handler, options);
        };
    }, [name, handler, target, JSON.stringify(options)]);
};
export default useEvent;
